#!/bin/sh
#. /etc/init.d/source_functions.sh #U_M39G_MV-1752 script is not present in FW, furthermore it is not needed since everything's working anyway

CONSOLE=/dev/null
MAX_RETRY_COUNT=10
RADVD_DEFAULT_CONF=/etc/radvd.conf
NPD6_DEFAULT_CONF=/etc/npd6.conf
DHCP6C_DEFAULT_CONF=/etc/dhcp6c.conf

RESOLV_CONF=/tmp/resolv.conf

WAN_INTERFACE=ccinet`getprop mrvl.net.activeDataPdp`
IP6=
IP6_FULL=
IP6_PREFIX_LEN=
IP6_PREFIX=

RA_MOBIT_CHANGED=1
RA_PREFIX_CHANGED=2
RA_ROUTER_LIFETIME_CHANGED=4
RA_MTU_CHANGED=8
RA_RDNSS_CHANGED=16

export PATH="/xbin/:$PATH"

print_changes()
{
	change=$1
	if [ "x$change" != "x" ]; then
		if [ "x$change" = "x0" ]; then
			echo "RA_NO_CHANGED" >> $CONSOLE
		else
			test 0 -eq $(($change&$RA_MOBIT_CHANGED)) || echo "RA_MOBIT_CHANGED" >> $CONSOLE
			test 0 -eq $(($change&$RA_PREFIX_CHANGED)) || echo "RA_PREFIX_CHANGED" >> $CONSOLE
			test 0 -eq $(($change&$RA_ROUTER_LIFETIME_CHANGED)) || echo "RA_ROUTER_LIFETIME_CHANGED" >> $CONSOLE
			test 0 -eq $(($change&$RA_MTU_CHANGED)) || echo "RA_MTU_CHANGED" >> $CONSOLE
			test 0 -eq $(($change&$RA_RDNSS_CHANGED)) || echo "RA_RDNSS_CHANGED" >> $CONSOLE
		fi
		echo >> $CONSOLE
	fi
}
get_ip6()
{
	ifc=$1
	IP6=`ifconfig $ifc| grep "inet6 addr.*Scope:Global" | /xbin/awk '{print $3}'`
	echo "get global IP6:$IP6" >> $CONSOLE
}

get_prefix_len()
{
	# xxxx::/yy  get yy after /
	IP6_PREFIX_LEN=`echo $IP6 | /xbin/sed 's/.*\/\(.*\)/\1/g'`
	echo "IP6_PREFIX_LEN:$IP6_PREFIX_LEN" >> $CONSOLE
}

convert_to_full_ip6()
{
	TEMP_IP6=`echo $1 | /xbin/sed 's/\/.*//g'`
	AGG=":0:"
	AGG_COUNT=`echo -n $TEMP_IP6 | /xbin/sed 's/[^:]//g' | wc -c `
	while [ $AGG_COUNT -lt 7 -a $AGG_COUNT -gt 1 ]
	do
		AGG=`echo -n $AGG | /xbin/sed 's/:$/:0:/g'`
		AGG_COUNT=$(($AGG_COUNT+1))
	done

	IP6_FULL=`echo $TEMP_IP6 | /xbin/sed "s/::/$AGG/g"`
}

get_prefix()
{
	convert_to_full_ip6 $1
	case "$IP6_PREFIX_LEN" in
	48)
		IP6_PREFIX=`echo $IP6_FULL | /xbin/awk 'BEGIN{FS=":"}{print $1":"$2":"$3"::"}'`
		;;
	# TODO: $3 & 0xFF00
	#56)
	#	IP6_PREFIX=`echo $IP6_FULL | /xbin/awk 'BEGIN{FS=":"}{print $1":"$2":"$3":"$4"::"}'`
	#	;;
	64)
		IP6_PREFIX=`echo $IP6_FULL | /xbin/awk 'BEGIN{FS=":"}{print $1":"$2":"$3":"$4"::"}'`
		;;
	*)
		echo "IP6_PREFIX_LEN:$IP6_PREFIX_LEN error" >> $CONSOLE
	esac

	while [ "x`echo $IP6_PREFIX| grep ':0::'`" != "x" ]
	do
		IP6_PREFIX=`echo $IP6_PREFIX | /xbin/sed 's/:0::/::/g'`
	done

	echo "IP6_PREFIX:$IP6_PREFIX" >> $CONSOLE
}

handle_radvd()
{
	radvd_conf=/tmp/radvd.conf
	cp -f $RADVD_DEFAULT_CONF $radvd_conf
	new_ip6_prefix=$1
	new_ip6_prefix_len=$2
	if [ -f $radvd_conf ];  then
		# Change br0 to usb0
		/xbin/sed -i -e "s/br/usb/g" $radvd_conf
		# deal with prefix
		/xbin/sed -i -e "s/prefix\ .*/prefix\ $new_ip6_prefix\/$new_ip6_prefix_len/g" $radvd_conf
		# deal with M bit
		if [ "x$M_BIT" = "x1" ]; then
			/xbin/sed -i -e "s/AdvManagedFlag.*;/AdvManagedFlag\ on;/g" $radvd_conf
		else
			/xbin/sed -i -e "s/AdvManagedFlag.*;/AdvManagedFlag\ off;/g" $radvd_conf
		fi

		# Force the O bit to 1 to resolve the DNS issue (RDNSS is not supported by most OS)
		# deal with O bit
		#if [ "x$O_BIT" = "x1" ]; then
			/xbin/sed -i -e "s/AdvOtherConfigFlag.*;/AdvOtherConfigFlag\ on;/g" $radvd_conf
		#else
		#	/xbin/sed -i -e "s/AdvOtherConfigFlag.*;/AdvOtherConfigFlag\ off;/g" $radvd_conf
		#fi

		# deal with MTU
		if [ "x$MTU" != "x" ]; then
			/xbin/sed -i -e "s/AdvLinkMTU\ .*;/AdvLinkMTU\ $MTU;/g" $radvd_conf
		fi

		# deal with RDNSS
		/xbin/sed -i -e "/#rdnss$/d" $RESOLV_CONF
		if [ "x$RDNSS" != "x" ]; then
			/xbin/sed -i -e "s/RDNSS\ .*/RDNSS\ $RDNSS/g" $radvd_conf

			## add dns to resolv.conf
			for i in $RDNSS
			do
				echo "nameserver $i #rdnss" >> $RESOLV_CONF
			done
		else
			USB0_GLOBAL_IP6=`ifconfig usb0 | grep inet6 | grep Global | head -n 1 | /xbin/awk '{print $3}'`
			if [ "x$USB0_GLOBAL_IP6" != "x" ]; then
				/xbin/sed -i -e "s/RDNSS\ .*/RDNSS\ $USB0_GLOBAL_IP6/g" $radvd_conf
			else
				USB0_LOCAL_IP6=`ifconfig usb0 | grep inet6 | head -n 1 | /xbin/awk '{print $3}' | /xbin/sed 's/\/.*//g'`
				/xbin/sed -i -e "s/RDNSS\ .*/RDNSS\ $USB0_LOCAL_IP6/g" $radvd_conf
			fi
		fi


		killall radvd 2>/dev/null
		/xbin/radvd -C $radvd_conf &
	else
		echo "radvd_conf:$radvd_conf doesn't exist!" >> $CONSOLE
	fi
}

handle_npd6()
{
	npd6_conf=/tmp/npd6.conf
	new_ip6_prefix=$1
	wan_ifc=$2

	if [ -f $NPD6_DEFAULT_CONF ]; then


		if [ "x`echo $new_ip6_prefix | grep ":0000$"`" != "x" ]; then
			while [ "x`echo $new_ip6_prefix | grep :0000$`" != "x" ]
			do
				new_ip6_prefix=`echo $new_ip6_prefix | sed 's/:0000$//g'`
			done
			new_ip6_prefix=$new_ip6_prefix":"
		fi
		echo > $npd6_conf
		echo "prefix = $new_ip6_prefix" >> $npd6_conf
		echo "interface = $wan_ifc" >> $npd6_conf
		echo "prefix = $new_ip6_prefix" >> $npd6_conf
		echo "interface = usb0" >> $npd6_conf
		echo >> $npd6_conf
		cat $NPD6_DEFAULT_CONF >> $npd6_conf
		killall npd6 2>/dev/null

		/xbin/npd6 -c $npd6_conf -l /tmp/npd6.log
	else
		echo "NPD6_DEFAULT_CONF:$NPD6_DEFAULT_CONF donesn't exist!" >> $CONSOLE
	fi
}

handle_dhcp6c()
{
	wan_ifc=$1
	dhcp6c_conf=/tmp/dhcp6c.conf
	killall dhcp6c 2>/dev/null

	if [ "x$M_BIT" != "x1" ]; then
		return
	fi

	cp -f $DHCP6C_DEFAULT_CONF $dhcp6c_conf
	if [ -f $dhcp6c_conf ]; then
		/xbin/sed -i -e "s/interface\ mlan0\ {/interface\ $wan_ifc\ {/g" $dhcp6c_conf
		/xbin/dhcp6c -D -c $dhcp6c_conf -k /dev/null $wan_ifc
	else
		echo "dhcp6c_conf:$dhcp6c_conf doesn't exist!" >> $CONSOLE
	fi
}

handle_dhcp6s()
{
	wan_ifc=$1
	dhcp6s_conf=/tmp/dhcp6s.conf
	killall dhcp6s 2>/dev/null
	echo "$M_BIT/$O_BIT" >> $CONSOLE

	if [ "x$M_BIT" = "x1" -o "x$O_BIT" = "x1" ]; then
		return
	fi

	dhcp6s_dns=

	orig_dns=`grep "nameserver.*:" /etc/resolv.conf  | awk '{print $2}'`
	if [ "x$orig_dns" != "x" ]; then
		for i in $orig_dns
		do
			dhcp6s_dns="$dhcp6s_dns $i"
		done
	fi

	if [ "x$dhcp6s_dns" != "x" ]; then
		echo > $dhcp6s_conf
		for i in $dhcp6s_dns
		do
			echo "option domain-name-servers $i;" >> $dhcp6s_conf
		done
		dhcp6s -c $dhcp6s_conf -k /dev/null usb0
	else
		echo "No DNS available to launch dhcp6s" >> $CONSOLE
	fi
}

handle_dhcp6relay()
{
	wan_ifc=$1
	if [ "x$M_BIT" = "x1" -o "x$O_BIT" = "x1" ]; then
		if [ "x`ps | grep -v grep | grep dhcp6relay`" = "x" ]; then
			/xbin/dhcp6relay -D -f -r $wan_ifc usb0 &
		fi
	else
		killall dhcp6relay 2>/dev/null
	fi
}

prepare_routing()
{
	# instead of set accept_ra to 2 (supported until kernel 2.6.37)
	# use workaround to do it
	echo 1 > /proc/sys/net/ipv6/conf/default/forwarding
	echo 1 > /proc/sys/net/ipv6/conf/all/forwarding

	echo 0 > /proc/sys/net/ipv6/conf/$WAN_INTERFACE/forwarding
	echo 1 > /proc/sys/net/ipv6/conf/$WAN_INTERFACE/accept_ra
	echo 1 > /proc/sys/net/ipv6/conf/all/accept_ra
	echo 1 > /proc/sys/net/ipv6/conf/default/accept_ra

	SOLICIT_MAX=`cat /proc/sys/net/ipv6/conf/$WAN_INTERFACE/router_solicitations`
	SOLICIT_INTERVAL=`cat /proc/sys/net/ipv6/conf/$WAN_INTERFACE/router_solicitation_interval`
	COUNT=0

	while [ $COUNT -lt $SOLICIT_MAX ]
	do
		ip6_ramon -t -i $WAN_INTERFACE
		sleep $SOLICIT_INTERVAL
		COUNT=$(($COUNT+1))
	done

	GW=`/xbin/ip -6 route show | /xbin/grep "^default.*$WAN_INTERFACE" | /xbin/awk '{print $3}'`
	/xbin/ip -6 route del default
	/xbin/ip -6 route add default via $GW dev $WAN_INTERFACE
}

reset_routing()
{
	echo 0 > /proc/sys/net/ipv6/conf/default/forwarding
	echo 0 > /proc/sys/net/ipv6/conf/all/forwarding
	# Clear the default gateway set at prepare_routing()
	/xbin/ip -6 route del default
}

ACTION=$1
RA_INFO_FILE=$2
RA_CHANGED=$3

if [ "$ACTION" == "start" ]; then
	prepare_routing
fi

if [ "$ACTION" == "set" ]; then
	####### init check #####
	if [ "x$WAN_INTERFACE" = "x" ]; then
		echo "WAN_INTERFACE empty. wan_proto:$wan_proto" >> $CONSOLE
		return 1;
	fi

	if [ "x$RA_CHANGED" = "x" ]; then
		echo "RA_CHANGED empty" >> $CONSOLE
		return 1;
	fi

	####### start #####
	if [ -f $RA_INFO_FILE ]; then
		IP6_PREFIX=`grep '^IPPrefix' $RA_INFO_FILE | /xbin/awk 'BEGIN{FS=" "}{print $2}'`
		IP6_PREFIX_LEN=`grep '^PrefixLen' $RA_INFO_FILE | /xbin/awk 'BEGIN{FS=" "}{print $2}'`
		M_BIT=`grep '^AdvManagedFlag' $RA_INFO_FILE | /xbin/awk 'BEGIN{FS=" "}{print $2}'`
		O_BIT=`grep '^AdvOtherConfigFlag' $RA_INFO_FILE | /xbin/awk 'BEGIN{FS=" "}{print $2}'`
		ROUTER_LFT=`grep '^AdvDefaultLifetime' $RA_INFO_FILE | /xbin/awk 'BEGIN{FS=" "}{print $2}'`
		MTU=`grep '^AdvLinkMTU' $RA_INFO_FILE | /xbin/awk 'BEGIN{FS=" "}{print $2}'`
		RDNSS=`grep '^RDNSS' $RA_INFO_FILE | /xbin/sed 's/^RDNSS\ //g'`

		echo >> $CONSOLE
		echo "Info from WAN RA:" >> $CONSOLE
		echo "    RA Prefix/len:$IP6_PREFIX/$IP6_PREFIX_LEN" >> $CONSOLE
		echo "    MO:$M_BIT/$O_BIT" >> $CONSOLE
		echo "    ROUTER_LFT:$ROUTER_LFT" >> $CONSOLE
		echo "    MTU:$MTU" >> $CONSOLE
		echo "    RDNSS:$RDNSS" >> $CONSOLE
	else
		echo "$RA_INFO_FILE doesn't exist. Use the default settings" >> $CONSOLE
		COUNT=0
		while [ "x$IP6_PREFIX" = "x" -a $COUNT -lt $MAX_RETRY_COUNT ]
		do
			get_ip6 $WAN_INTERFACE
			get_prefix_len $IP6
			get_prefix $IP6
			sleep 1
			COUNT=$(($COUNT+1))
		done

		if [ $COUNT -eq $MAX_RETRY_COUNT ]; then
			echo "Retry fail" >> $CONSOLE
			return 2
		fi

		M_BIT=1
		O_BIT=1
	fi
	####### handle IPv6 tools #####

	print_changes $RA_CHANGED
	if [ $(($RA_CHANGED & $RA_PREFIX_CHANGED)) -gt 0 ]; then
		echo "handle_npd6" >> $CONSOLE
		handle_npd6 $IP6_PREFIX $WAN_INTERFACE
	fi
	if [ $(($RA_CHANGED & ($RA_MOBIT_CHANGED|$RA_PREFIX_CHANGED|$RA_MTU_CHANGED|$RA_RDNSS_CHANGED) )) -gt 0 ]; then
		# ROUTER_LFT should be handled alone with MaxRtrAdvInterval and MinRtrAdvInterval
		# Since we set Max/Min RtrAdvInterval to fixed 600/300, do not handle it in radvd for now.
		echo "handle_radvd" >> $CONSOLE
		handle_radvd $IP6_PREFIX $IP6_PREFIX_LEN
	fi
	if [ $(($RA_CHANGED & $RA_MOBIT_CHANGED)) -gt 0 ]; then
		echo "handle_dhcp6relay" >> $CONSOLE
		handle_dhcp6relay $WAN_INTERFACE
	fi
	if [ $(($RA_CHANGED & ($RA_PREFIX_CHANGED|$RA_MOBIT_CHANGED) )) -gt 0 ]; then
		echo "handle_dhcp6c" >> $CONSOLE
		handle_dhcp6c $WAN_INTERFACE
	fi

	if [ $(($RA_CHANGED & ($RA_MOBIT_CHANGED|$RA_RDNSS_CHANGED) )) -gt 0 ]; then
		echo "handle_dhcp6s" >> $CONSOLE
		handle_dhcp6s
	fi

	# If M_BIT is set to 1, it takes a while to get an IP address from DHCPv6
	if [ "x$M_BIT" = "x1" ]; then
		sleep 3
	fi
fi

if [ "$ACTION" == "stop" ]; then
	killall radvd 2>/dev/null
	killall npd6 2>/dev/null
	killall dhcp6relay 2>/dev/null
	killall dhcp6c 2>/dev/null
	reset_routing
	/xbin/sed -i -e "/#rdnss$/d" $RESOLV_CONF
	/xbin/sed -i -e "/#dhcp6c$/d" $RESOLV_CONF
fi

if [ "x$ACTION" == "x" ]; then
	echo "Usage: $0 start " >> $CONSOLE
	echo "Usage: $0 set RA_INFO_FILE RA_CHANGED_FLAG " >> $CONSOLE
	echo "Usage: $0 stop " >> $CONSOLE
fi
