<?php
/*
 * Overview page for default "home" page
 *
 * $Revision: 4506 $
 * $Author: PENET\roncsak $
 * $Date: 2014-07-22 10:07:52 +0200 (Tue, 22 Jul 2014) $
 *
 **/
require_once('init.php');
//require_once('_lwuciConnector.php'); //by HS
require_once('_lw2TobyConnector.php'); //by HS
require_once('_pageBuilder.php');
$conn = new LWUCI_Connector();

$page = new PageBuilder("overview");

//$json = json_decode($conn->read("pageOverview"), true); //by HS
$json = $conn->read("pageOverview"); //by HS
$page->SetLanguageCode($json['settings']['system']['language']);
$page->SetPasswordProtection($json['settings']['system']['pass_prot']);

$smarty->configLoad($page->project.'.conf', 'languages');
$json['settings']['system']['language'] = $page->lang;
$json['settings']['system']['languages'] = $smarty->getConfigVars('language');

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

for($i=0; $i<sizeof($json['conn_devs']['wlan']); $i++) {
	$key = key($json['conn_devs']['wlan'][$i]);
	$json['status']['conn_devs']['wlan'][$i]['name'] = $json['conn_devs']['wlan'][$i]['name'];
	$json['status']['conn_devs']['wlan'][$i]['ip'] = $json['conn_devs']['wlan'][$i]['ip'];
}
if( !empty($json['status']['modem']['uptime']) ) {
	$uptime = get_uptime();
	$json['status']['modem']['uptime'] = $uptime - $json['status']['modem']['uptime'];
} else {
	$json['status']['modem']['uptime'] = 0;
}


$iccid = $conn->read("sim_current_iccid");
$userasked		= ($conn->read("sim_".$iccid."_user_asked") == 1)? 1 : 0; 
$profileasked	= ($conn->read("sim_".$iccid."_profile_asked") == 1)? 1 : 0; // Does SIM Profile asked?
$pinasked		= ($conn->read("sim_".$iccid."_pin_asked") == 1)? 1 : 0; // Does SIM PIN asked?
$json['sim_status']['attempts']			= $conn->read("sim_attempts");
$json['sim_status']['user_asked']		= $userasked;
$json['sim_status']['profile_asked']	= $profileasked;
$json['sim_status']['pin_asked']		= $pinasked;
$json['sim_status']['iccid']			= $iccid;
if( $profileasked == 0 ) {
	require_once('_ServiceProviders.php');
	$imsi = json_decode($conn->read("sim_".$iccid."_imsi"), true);
	$sp = new ServiceProviders( (string) $imsi['mcc'], (string) $imsi['mnc']);
	$profiles = $sp->getResults();
	$json['sim_status']['profiles'] = $profiles;
}


/* The following two switch-case should match with the two in sim.php */
$sim_status = $json['sim_status']['pin'];
$sim_setup = $_SESSION['sim-setup'];
switch($sim_status) {
	case "PIN_NEEDED":
		$sim_setup = "pin-input";
		break;
	case "PUK_NEEDED":
		$sim_setup = "puk-input";
		break;
	default:
		break;
}
//~ $sim_setup = "pin-input";
switch( $sim_setup ) {
	case "pin-input":
		$attempts = $conn->read("sim_attempts");
		$json['sim_status']['attempts'] = $attempts;
		break;
	case "pin-change":
		$json['sim_status']['iccid'] = $iccid;
		break;
	case "puk-input":
		$attempts = $conn->read("sim_attempts");
		$json['sim_status']['attempts'] = $attempts;
	default:
		break;
}

if( !empty($json['status']['sod']) ) {
	$sod = $json['status']['sod'];
	$delay = (int) $conn->read('rundown_time');
	$now = get_uptime();
	unset($json['status']['sod']);
	$json['status']['sod']['started_at'] = $sod;
	$json['status']['sod']['delay'] = $delay;
	$json['status']['sod']['remained'] = ($delay < $now - $sod )? 0 : $delay - ($now - $sod);
}

$smarty->assign('sim_setup', $sim_setup);
$smarty->assign('lwuci', $json);
$smarty->assign('page', $page);
$smarty->display('_template.tpl.html');

function get_uptime() {
	$tmp = explode(' ', file_get_contents('/proc/uptime'));
    return intval($tmp[0]);
}

?>
