<?php
/*
 * Here is a big switch-case. This file used for AJAX calls only!
 * Please maintain ABC order when inserting new cases!
 * 
 * $Revision: 4506 $
 * $Author: PENET\roncsak $
 * $Date: 2014-07-22 10:07:52 +0200 (Tue, 22 Jul 2014) $
 *
 * ToDo:
 *		* There were some problems with array_diff() and had to change to array_diff_assoc(). However there multiple array_diff remained in code which could work unexpectedly.
 *
 * */

require_once('init.php');
//require_once('_lwuciConnector.php'); //by HS
require_once('_lw2TobyConnector.php'); //by HS
require_once('_inputValidator.php');
$conn = new LWUCI_Connector();
$v = new InputValidator();
if( !empty($http['c']) ) {
	$notJSONoutput	= false;
	$r['data']		= '';
	$r['msg']		= '';
	$r['status']	= '';
	$r['c']			= $http['c'];
	//sleep(5);
	switch( $http['c'] ) {
		case "CheckBusyStatus":
			$dev_reset = $conn->read("device_reset");
			$r['session'] = (isset($_SESSION['system_busy']))?$_SESSION['system_busy']:'';
			$r['type'] = $dev_reset;
			$r['status'] = "success";
			if($dev_reset == "system")  {
				shell_exec("lwconfig delete device_reset");
				shell_exec("reboot");
			}
			break;
		case "CheckSIMStatus":
			$accepted = $conn->read("pin_accept");
			$accepted = (empty($accepted))? 0 : $accepted;
			if( $accepted == 1) {
				$iccid = $conn->read("sim_current_iccid");
				$profiles = json_decode($conn->read("sim_".$iccid."_profiles"), true);
				$r['data']['profiles'] = $profiles;
				$r['status'] = "success";
			} else {
				$r['status'] = "waiting";
			}
			break;
		case "LoginSettings":
			$wuipass = $conn->getWuiPassword();
			if( md5($http['wuipassword']) == $wuipass ) {
				$_SESSION['admin_authed'] = 1;
				$r['status'] = "success";
			} else {
				$r['status'] = "error";
				$r['msg'] = "no match";
			}
			break;
		case "LogoutAdmin":
			$_SESSION['admin_authed'] = 0;
			$r['status'] = "success";
			break;
		case "pin-change":
			$iccid = $http['iccid'];
			$current_pin = $conn->read('sim_'.$iccid.'_pin');
			$v->addField('oldPIN', $http['oldPIN'])
					->minLength(4)
					->maxLength(8)
					->number()
					->equals($iccid)
				->addField('newPIN', $http['newPIN'])
					->minLength(4)
					->maxLength(8)
					->number()
				->addField('newPIN2', $http['newPIN2'])
					->equals($http['newPIN']);
			if( $v->run() ) {
				
			} else {
				$r['data'] = $v->getErrors();
				$r['status'] = "error";
				$r['msg'] = "validation error";
			}
			break;
		case "pin-input":
			$v->addField('PIN_input', $http['PIN_input'])
					->required()
					->minLength(4)
					->maxLength(8)
					->number();
			if( $v->run() ) {
				do {
					sleep(1);
					$iccid = $conn->read("sim_current_iccid");
				} while( empty($iccid) );
				$iccid = $conn->read("sim_current_iccid");
				$attempts = $conn->read("sim_attempts");
				//~ $lwuci_params['sim_pin_input'] = $http['PIN_input'];
				//~ $lwuci_params['sim_pin_entered'] = '1';
				$lwuci_params['sim_'.$iccid.'_pin_asked'] = '1';
				$conn->write($lwuci_params);
				shell_exec("echo -n 'PIN " . escapeshellarg($http["PIN_input"]) . "' > /tmp/modemMan.fifo");
				$error_counter = 5; // how many times should check SIM_STATUS at maximum?
				do{
					$sim_status = $conn->read("sim_status");
					$r['data']['sim_status']['pin'] = $sim_status;
					switch( $sim_status ) {
						case "SIM_BLOCKED":
							$r['status'] = "error";
							if( $error_counter == 0 ) {
								break 2;
							} else {
								$error_counter--;
								break 1; 									// break from switch-case and do-while, also
							}
							break 2; 									// break from switch-case and do-while, also
						case "SIM_UNKNOWN":
							if( $error_counter == 0 ) {
								break 2;
							} else {
								$error_counter--;
								break 1; 									// break from switch-case and do-while, also
							}
							break 1;
						case "PIN_NEEDED":
							$r['data']['sim_status']['attempts'] = $conn->read("sim_attempts");
							$r['status'] = "error";
							if( $error_counter == 0 ) {
								break 2;
							} else {
								$error_counter--;
								break 1; 									// break from switch-case and do-while, also
							}
						case "PIN_OK":
							require_once('_ServiceProviders.php');
/* M39G_MV_2-1694 */
							sleep(2);
							$imsi = json_decode($conn->read("sim_".$iccid."_imsi"), true);
							$sp = new ServiceProviders( (string) $imsi['mcc'], (string) $imsi['mnc']);
							$profiles = $sp->getResults();
							// $profiles = json_decode($conn->read("sim_".$iccid."_profiles"), true);
// 							$profiles = json_decode($conn->read("sim_".$iccid."_profiles"), true);
							$_SESSION['sim-setup'] = "profile-select";
/* M39G_MV_2-1694 */
//							if(!empty($profiles)) {
							if ( ( !empty($imsi["mcc"]) ) && ( !empty($imsi["mcc"]) ) ) {
								$r['data']['sim_status']['profiles'] = $profiles;
								$r['data']['sim_status']['iccid'] = $iccid;
								$smarty->configLoad($_SESSION['lang'].'.lang');
								$r['i18n']['newsimprofile_header'] = $smarty->getConfigVars('newsimprofile_header');
								$r['status'] = "success";
								break 2;
							}
							break 1; 									// break from switch-case and do-while, also
						case "PUK_NEEDED":
							if( $error_counter == 0 ) {
								$_SESSION['sim-setup'] = "puk-input";
								break 2;
							} else {
								$error_counter--;
								break 1; 									// break from switch-case and do-while, also
							}
							$r['status'] = "error";
							break 2; 									// break from switch-case and do-while, also
						default:
							$r['status'] = "error";
							$r['msg'] = "unknown state";
							break 2; 									// break from switch-case and do-while, also
					}
/* M39G_MV_2-1694 */
//					sleep(1);
					sleep(3);
				} while(true);
			} else {
				$r['data'] = $v->getErrors();
				$r['status'] = "error";
				$r['msg'] = "validation error";
			}
			break;
		case "profile-select":
		case "PINProfile":
			$d = $http;
			$iccid = $d['iccid'];
			$lwuci_params['sim_'.$iccid.'_user_asked'] = '1';
/* M39G_MV_2-984 */
			$lwuci_params['sim_'.$iccid.'_roaming'] = '0';
			unset($d['iccid']);
			unset($d['c']);
			if( !empty($d['user_name']) && !empty($d['user_pass']) ) {
				$d['authentication'] = "PAP";
			}
			foreach( $d as $key => $val ) {
				$lwuci_params['sim_'.$iccid.'_'.$key] = $val;
			}
			$lwuci_params['sim_'.$iccid.'_profile_asked'] = '1';
			$conn->write($lwuci_params);
			$r['status'] = "success";
			shell_exec("echo -n 'PDP " . escapeshellarg($iccid) . "' > /tmp/modemMan.fifo");
			break;
		case "puk-input":
			$v->addField('PUK_input', $http['PUK_input'])
					->required()
					->number()
				->addField('PIN_input_new', $http['PIN_input_new'])
					->required()
					->minLength(4)
					->maxLength(8)
					->number();
			if( $v->run() ) {
				$iccid = $conn->read("sim_current_iccid");
				$attempts = $conn->read("sim_attempts");
				//~ $lwuci_params['sim_puk_input'] = $http['PUK_input'];
				//~ $lwuci_params['sim_pin_input'] = $http['PIN_input_new'];
				//~ $conn->write($lwuci_params);
				shell_exec("echo -n 'PIN " . escapeshellarg($http["PUK_input"]) . " " .
					escapeshellarg($http["PIN_input_new"]) . "' > /tmp/modemMan.fifo");
				$res = CheckSimStatus($iccid, "PUK_NEEDED");
				if( $res['status'] == "success" ) {
					$r = array_merge($r, $res);
					require_once('_ServiceProviders.php');
					$imsi = json_decode($conn->read("sim_".$iccid."_imsi"), true);
					$sp = new ServiceProviders( (string) $imsi['mcc'], (string) $imsi['mnc']);
					$profiles = $sp->getResults();
					$r['data']['sim_status']['profiles'] = $profiles;
					$r['data']['sim_status']['iccid'] = $iccid;
					$smarty->configLoad($_SESSION['lang'].'.lang');
					$r['i18n']['newsimprofile_header'] = $smarty->getConfigVars('newsimprofile_header');

					$r['params'] = $lwuci_params;
					$r['status'] = 'success';
				} else {
					$r = $res;
				}			
			} else {
				$r['data'] = $v->getErrors();
				$r['status'] = "error";
				$r['msg'] = "validation error";
			}
			break;
		case "RefreshStatus":
			$isOverview = $http['isOverview'];
			$now = '';
			if( $isOverview ) {
				$json = $conn->read("pageOverview"); //by HS
				if( !empty($json['status']['modem']['uptime']) ) {
					$now = get_uptime();
					$json['status']['modem']['connected_since'] = $now - $json['status']['modem']['uptime'];
				}
			} else {
				$json = $conn->read("pageAjax");
			}
			for($i=0; $i<sizeof($json['conn_devs']['wlan']); $i++) {
				$key = key($json['conn_devs']['wlan'][$i]);
				$json['status']['conn_devs']['wlan'][$i]['name'] = $json['conn_devs']['wlan'][$i]['name'];
				$json['status']['conn_devs']['wlan'][$i]['ip'] = $json['conn_devs']['wlan'][$i]['ip'];
			}

			$json['status']['modem']['up'] = auto_byte_convert($json['status']['modem']['up']);
			$json['status']['modem']['down'] = auto_byte_convert($json['status']['modem']['down']);
			if( $json['status']['modem']['session'] == "SESSION_DISCONNECTED" || empty($json['status']['modem']['session'])  ) {
				$sim_inserted	= $conn->read('sim_inserted');
				$sim_status		= $conn->read('sim_status');
				$json['sim_status']['inserted']	= ($sim_inserted == "y")? 1 : 0;
				$json['sim_status']['pin']		= $sim_status;
				$smarty->configLoad($_SESSION['lang'].'.lang');
				$r['i18n']['global_nosim_msg'] = $smarty->getConfigVars('global_nosim_msg');
				$r['i18n']['global_sim_nopin_msg'] = $smarty->getConfigVars('global_sim_nopin_msg');
			}
			if( !empty($json['status']['sod']) ) {
				$sod = $json['status']['sod'];
				$delay = (int) $conn->read('rundown_time');
				$now = (!empty($now)) ? $now : get_uptime();
				unset($json['status']['sod']);
				$json['status']['sod']['started_at'] = $sod;
				$json['status']['sod']['delay'] = $delay;
				$json['status']['sod']['remained'] = ($delay < $now - $sod )? 0 : $delay - ($now - $sod);
			}
			/* U_M39G_MV-2327 update the region block */
			$json['settings']['wlan']['region_blocked'] = $conn->read("region_blocked");
			$r['data'] = $json;
			$r['status'] = "success";
			break;
		case "ResetDataVolume":
			$iccid = $conn->read("sim_current_iccid");
			$lwuci_params['sim_'.$iccid.'_traffic_reset'] = $http['date'];
			$conn->write($lwuci_params);
			$smarty->configLoad($_SESSION['lang'].'.lang');
			$date_format = $smarty->getConfigVars('date_format');
			$r['status'] = "success";
			$r['data']['date'] = strftime($date_format, strtotime($http['date']));
			break;
		case "SaveInternetSettings":
			$d = $http;
			unset($d['c']);
			unset($d['currentPage']);
			$iccid = $conn->read("sim_current_iccid");
			$json = $conn->read("pageInternet"); //by HS
			$r['test']['auth'] = $http['auth'];
			$r['test']['with'] = 'PAP';
			$r['test']['cond'] = !empty($http['user']) && !empty($http['pass']);
			$v->addField('connName', $http['connName'])
					->required()
					->ascii()
				->addField('apn', $http['apn'])
					->required()
					->ascii()
/* M39G_MV_2-984 */
				->addField('apn4G', $http['apn4G'])
					->ascii()
				->addField('user', $http['user'])
					->ascii()
					->requiredIf( !empty($http['pass']) || $http['auth'] != "NONE" ) // if password is given or authentication is not 'NONE' then username is required
				->addField('pass', $http['pass'])
					->requiredIf( !empty($http['user']) || $http['auth'] != "NONE" ) // if username is given or authentication is not 'NONE' then password is required
				->addField('auth', $http['auth'])
					->equalsIf(array('CHAP','PAP'), !empty($http['user']) && !empty($http['pass']) )
				->addField('dns1', $http['dns1'])
					->ip()
				->addField('dns2', $http['dns2'])
					->ip()
				->addField('iccid', $http['iccid'])
					->equals($iccid);
			if( $v->run() ) {
				$current = $conn->read("pageInternet"); //by HS
				$current = $current['settings']['internet'];
				unset($current['volume_rst']);
				$diff = array_diff_assoc($d, $current);
				if( sizeof($diff) != 0 ) {
					$lwuci_key = array(
						  "connName" => "sim_*_internet_profile"
						, "apn" => "sim_*_apn"
/* M39G_MV_2-984 */
						, "apn4G" => "sim_*_apn4G"
						, "roaming" => "sim_*_roaming"
						, "user" => "sim_*_user_name"
						, "pass" => "sim_*_user_pass"
						, "auth" => "sim_*_authentication"
						, "dns1" => "sim_*_dns1"
						, "dns2" => "sim_*_dns2"
					);
					foreach($diff as $key => $value) {
						if( array_key_exists($key, $lwuci_key) ) {
							$key_tmp = str_replace("*", $iccid, $lwuci_key[$key]);
							$lwuci_params[$key_tmp] = $value;
						}
					}
					// $r['lwuci'] = $lwuci_params;
					$conn->write($lwuci_params);
					$r['status'] = "success";
				} else {
					$r['status'] = "success";
					$r['msg'] = "no change";
				}
			} else {
				$r['data'] = $v->getErrors();
				$r['status'] = "error";
				$r['msg'] = "validation error";
			}
			break;
		case "SaveLanguageSettings":
			$lwuci_params['wui_language'] = $http['selectedLang'];
			$conn->write($lwuci_params);
			$_SESSION['lang'] = $http['selectedLang'];
			$r['status'] = "success";
			break;
		case "SaveSystemSettings":
			$d = $http;
			unset($d['c']);
			unset($d['currentPage']);
			if( !empty($d['password']) ) {
				$v->addField('password', $d['password'])
					->minLength(5)
					->maxLength(128)
					->ascii();
			}
			$v->addField('password2', $d['password2'])
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
				->equals($d['password']);
			if( $v->run() ) {
				$lwuciPageSystem = $conn->read("pageSystem"); //by HS
				$current = $lwuciPageSystem['settings']['system'];
				if( empty($d['password']) ) {
					unset($current['password']);
				}
				unset($d['password2']);
				$current["selectedLang"] = $current['language'];
				unset($current['language']);
				if( empty($d['password']) ) {
					unset($d['password']);
					unset($d['password2']);
					unset($current['password']);
				}
				$diff = array_diff_assoc($d, $current);

				if( sizeof($diff) != 0 ) {
					$lwuci_key = array(
						  "password" => "wui_password"
						, "pass_prot" => "wui_password_validity"
						, "selectedLang" => "wui_language"
						, "home" => "wui_startscreen"
						, "dialin" => "modemMan_enable"
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
						, "wui_access" => "wui_access_enable"
					);
					foreach($diff as $key => $value) {
						if( array_key_exists($key, $lwuci_key) ) {
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
							if( $key == "wui_access" ) {
								shell_exec("/system/marvell/tel/run_wifi.sh set_webui_ftp_status '".$value."'");
							} else if( $key == "password") {
								$lwuci_params[$lwuci_key[$key]] = md5($value);
							} else {
								if( $key == "selectedLang" ) {
									$_SESSION['lang'] = $http['selectedLang'];
								}
								$lwuci_params[$lwuci_key[$key]] = $value;
							}
						}
					}
					$conn->write($lwuci_params);
// 					$r['params'] = $lwuci_params;
					$r['status'] = "success";
				} else {
					$r['status'] = "success";
					$r['msg'] = "no change";
				}
			} else {
				$r['data'] = $v->getErrors();
				$r['status'] = "error";
				$r['msg'] = "validation error";
			}
			break;
		case "SaveWlanApSettings":
				$d = $http;
				unset($d['c']);
				unset($d['currentPage']);
				unset($d['encryption_key2']);
				
				$v->addField('ssid_name', $http['ssid_name'])
						->required()
						->minLength(1)
						->maxLength(32)
						->ascii()
					->addField('ip', $http['ip'])
						->required()
						->ip()
					->addField('subnet', $http['subnet'])
						->required()
						->ip();
/* M39G_MV_2-1152 */
				if( $http['selectedNetworkmode'] == "A" || $http['selectedNetworkmode'] == "AN_MIXED" || $http['selectedNetworkmode'] == "AN") {
					if( $http['selectedChannel'] != "AUTO") {
						$r['status'] = "error_validity";
						$r['msg'] = "validation error";
						break;
					}
				}
				if( $http['selectedNetworkmode'] != "A" && $http['selectedNetworkmode'] != "AN_MIXED" && $http['selectedNetworkmode'] != "AN") {
					if( $http['selectedChannel'] != "AUTO" ) {
						if( $http['selectedRegion'] == "US" ) {
							if( $http['selectedChannel'] < "1" || $http['selectedChannel'] > "11") {
								$r['status'] = "error_validity";
								$r['msg'] = "validation error";
								break;
							}
						}
						if( $http['selectedRegion'] == "EU" ) {
							if( $http['selectedChannel'] < "1" || $http['selectedChannel'] > "13") {
								$r['status'] = "error_validity";
								$r['msg'] = "validation error";
								break;
							}
						}
						if( $http['selectedRegion'] == "JP" ) {
							if( $http['selectedChannel'] == "14" && $http['selectedNetworkmode'] != "B") {
								$r['status'] = "error_validity";
								$r['msg'] = "validation error";
								break;
							}
							if( $http['selectedChannel'] < "1" || $http['selectedChannel'] > "14") {
								$r['status'] = "error_validity";
								$r['msg'] = "validation error";
								break;
							}
						}
					}
				}
				if( $http['selectedSecurityMode'] != "OPEN" ) {
					$v->addField('encryption_key', $http['encryption_key'])
						->required()
						->minLength(8)
						->maxLength(64)
						->ascii()
						->equals($http['encryption_key2']);
/*
					if( $http['selectedSecurityMode'] == "WPA2_ENTERPRISE" ) {
						$v->addField('eap_user', $http['eap_user'])
							->required()
							->minLength(4)
							->maxLength(32)
							->ascii();
					}
*/
				}
/* M39G_MV_2-1152 */
				if( $http['selectedSecurityMode'] == "WPA") {
					if( $http['selectedNetworkmode'] != "A" && $http['selectedNetworkmode'] != "B" && $http['selectedNetworkmode'] != "BG_MIXED" && $http['selectedNetworkmode'] != "G") {
						$r['status'] = "error_validity";
						$r['msg'] = "validation error";
						break;
					}
				}
				if( $http['selectedSecurityMode'] == "WPA2") {
					if( $http['selectedNetworkmode'] != "N" && $http['selectedNetworkmode'] != "AN" && $http['selectedNetworkmode'] != "AN_MIXED" && $http['selectedNetworkmode'] != "BGN_MIXED") {
						$r['status'] = "error_validity";
						$r['msg'] = "validation error";
						break;
					}
				}
				if( $http['selectedSecurityMode'] == "WPA_WPA2_MIXED") {
					if( $http['selectedNetworkmode'] != "N" && $http['selectedNetworkmode'] != "AN" && $http['selectedNetworkmode'] != "AN_MIXED" && $http['selectedNetworkmode'] != "BGN_MIXED") {
						$r['status'] = "error_validity";
						$r['msg'] = "validation error";
						break;
					}
				}
				if( $v->run() ) {
					$prefix = "wibear_uap0_";
					$wlan['ssid_name']				= $conn->read($prefix.'ssid');
					//~ $wlan['ssid_hidden']			= ($conn->read($prefix.'hide_ssid') == 'y')? 1 : 0;
					$wlan['selectedRegion']			= $conn->read($prefix.'country');
					$wlan['selectedChannel']		= $conn->read($prefix.'channel');
					$wlan['selectedSecurityMode']	= $conn->read($prefix.'security_mode');
					$wlan['encryption_key']			= $conn->read($prefix.'security_key');
					$wlan['ip']						= $conn->read('net_iface_uap0_address');
					$wlan['subnet']					= $conn->read('net_iface_uap0_netmask');
					$wlan['selectedNetworkmode'] 	= $conn->read($prefix.'mode');
					// The following keys may be empty in some project, so
					// handle these optional
					if( !empty($http['guardint']) ) {
						$wlan['guardint'] = $conn->read($prefix.'guard_interval');
					}
					if( !empty($http['bandwidth']) ) {
						$wlan['bandwidth'] = $conn->read($prefix.'bandwidth');
					}
					
					$diff = array_diff_assoc($d, $wlan);
					if( sizeof($diff) != 0 ) {
						$lwuci_key = array(
							  "ssid_name" => $prefix."ssid"
							//~ , "ssid_hidden" => $prefix."hide_ssid"
							, "selectedRegion" => $prefix."country"
							, "selectedChannel" => $prefix."channel"
							, "selectedSecurityMode" => $prefix."security_mode"
							, "encryption_key" => $prefix."security_key"
							, "ip" => "net_iface_uap0_address"
							, "subnet" => "net_iface_uap0_netmask"
							, "selectedNetworkmode" => $prefix."mode"
							//~ , "guardint" => $prefix."guard_interval"
							//~ , "bandwidth" => $prefix."bandwidth"
						);
						foreach($diff as $key => $value) {
							if( array_key_exists($key, $lwuci_key) ) {
								//~ if($key == "ssid_hidden") {
									//~ $lwuci_params[$lwuci_key[$key]] = ($value == 1)? "y" : "n";
								//~ } else {
									$lwuci_params[$lwuci_key[$key]] = $value;
								//~ }
							}
						}
						// $r['lwuci'] = $lwuci_params;
						$conn->write($lwuci_params);
						$r['status'] = "success";
					} else {
						$r['status'] = "success";
						$r['msg'] = "no change";
					}
					$r['status'] = "success";
				} else {
					$r['data'] = $v->getErrors();
					$r['status'] = "error";
					$r['msg'] = "validation error";
				}
			break;
			case "SaveWlanStaSettings":
				$d = $http;
				unset($d['c']);
				unset($d['currentPage']);
				
				if ($http['sta_enable'] == "1") {
					$v->addField('ssid', $http['sta_ssid_name'])
						->required()
						->minLength(1)
						->maxLength(32)
						->ascii();
				}
				if( $http['staSelectedSecurityMode'] != "OPEN" ) {
// M39G_MV_2-2251
					if( $http['staSelectedSecurityMode'] == "WPA_PSK" ) {
					$v->addField('sta_encryption_key', $http['sta_encryption_key'])
						->required()
						->minLength(8)
						->maxLength(64)
						->ascii();
// M39G_MV_2-2251
					}

					else if ( ( $http['staSelectedSecurityMode'] == "WEP_HEX1" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_HEX1_SH" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_HEX2" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_HEX2_SH" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_HEX3" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_HEX3_SH" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_HEX4" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_HEX4_SH" ) )
					{
						$v->addField('sta_encryption_key', $http['sta_encryption_key'])
							->required()
							->UblxWEPHEXLength()
							->UblxHEX();
					}
					else if ( ( $http['staSelectedSecurityMode'] == "WEP_ASCII1" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_ASCII1_SH" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_ASCII2" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_ASCII2_SH" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_ASCII3" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_ASCII3_SH" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_ASCII4" )
						|| ( $http['staSelectedSecurityMode'] == "WEP_ASCII4_SH" ) )
					{
						$v->addField('sta_encryption_key', $http['sta_encryption_key'])
							->required()
							->UblxWEPASCIILength()
							->UblxASCII();
					}
				}
				if ($http['sta_dhcp'] == "0") {
					$v->addField('address', $http['address'])
						->required()
						->ip()
					->addField('netmask', $http['netmask'])
						->required()
						->ip();
				}
				if( $v->run() ) {
					$prefix = "wibear_mlan0_";
					$wlan_sta['sta_enable']					= $conn->read($prefix.'enable');
					$wlan_sta['sta_ssid_name']				= $conn->read($prefix.'ssid');
					$wlan_sta['staSelectedSecurityMode']	= $conn->read($prefix.'security_mode');
					$wlan_sta['sta_encryption_key']			= $conn->read($prefix.'security_key');
					$wlan_sta['sta_dhcp']					= $conn->read('net_iface_mlan0_dhcp');
					$wlan_sta['address']					= $conn->read('net_iface_mlan0_address');
					$wlan_sta['netmask']					= $conn->read('net_iface_mlan0_netmask');
					$wlan_sta['gateway']					= $conn->read('net_mlan0_gateway');
					$wlan_sta['nameservers']				= $conn->read('net_mlan0_nameservers');
					
					$diff = array_diff_assoc($d, $wlan_sta);
					if( sizeof($diff) != 0 ) {
						$lwuci_key = array(
							"sta_enable" => $prefix."enable"
							, "sta_ssid_name" => $prefix."ssid"
							, "staSelectedSecurityMode" => $prefix."security_mode"
							, "sta_encryption_key" => $prefix."security_key"
							, "sta_dhcp" => "net_iface_mlan0_dhcp"
							, "address" => "net_iface_mlan0_address"
							, "netmask" => "net_iface_mlan0_netmask"
							, "gateway" => "net_mlan0_gateway"
							, "nameservers" => "net_mlan0_nameservers"
						);
						foreach($diff as $key => $value) {
							if( array_key_exists($key, $lwuci_key) ) {
								$lwuci_params[$lwuci_key[$key]] = $value;
							}
						}
						// $r['lwuci'] = $lwuci_params;
						$conn->write($lwuci_params);
						$r['status'] = "success";
					} else {
						$r['status'] = "success";
						$r['msg'] = "no change";
					}
					$r['status'] = "success";
				} else {
					$r['data'] = $v->getErrors();
					$r['status'] = "error";
					$r['msg'] = "validation error";
				}
			break;
		case "SetSessionVar":
			$allowed_keys = array("sim-setup", "system_busy", "thumbnail_view");
			if( in_array($http['key'], $allowed_keys) ) {
				$_SESSION[$http['key']] = $http['value'];
				$r['status'] = "success";
			} else {
				$r['status'] = "error";
			}
			break;
		case "ToggleConnection":
			$_SESSION['connection'] = ( $_SESSION['connection'] == 1 )? 0 : 1;
			$r['data']['btn_title'] = ( $_SESSION['connection'] == 1 )? "Disconnect" : "Connect";
			$r['data']['connection'] = $_SESSION['connection'];
			$r['status'] = "success";
			break;
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
        case "RevertWUIPages":
			shell_exec("/system/marvell/tel/run_wifi.sh revert_webui");
			// fall through...
		case "ClearWUICache":
			$smarty->clearCompiledTemplate();
			$smarty->clearAllCache();
			session_unset();
			break;
		default:
			$r['data']		= $http;
			$r['msg']		= "Unknown command specified!";
			$r['status']	= "error";
		break;
	}
	if( !$notJSONoutput ) {
		print json_encode($r);
	}
} else {
	$r['status'] = "working";
	print json_encode($r);
}
function CheckSimStatus($iccid, $prev_status) {
	global $conn, $_SESSION, $smarty;
	$r = array();
	$error_counter = 5; // how many times should check SIM_STATUS at maximum?
	do {
		sleep(1);
		$sim_status = $conn->read("sim_status");
//		print "$sim_status<br />";
		$r['data']['sim_status']['pin'] = $sim_status;
		switch( $sim_status ) {
			case "SIM_BLOCKED":
				$r['status'] = "error";
				if( $error_counter == 0 ) {
					break 2;
				} else {
					$error_counter--;
					break 1; 									// break from switch-case and do-while, also
				}
				break 2; 									// break from switch-case and do-while, also
			case "SIM_UNKNOWN":
				if( $error_counter == 0 ) {
					break 2;
				} else {
					$error_counter--;
					break 1; 									// break from switch-case and do-while, also
				}
				break 1;
			case "PIN_NEEDED":
				$r['data']['sim_status']['attempts'] = $conn->read("sim_attempts");
				//~ if( $prev_status == "PUK_NEEDED" ) {
					//~ $r['status'] = "success";
				//~ } else {
					if( $error_counter == 0 ) {
						$r['data']['sim_status']['attempts'] = $conn->read("sim_attempts");
						$r['status'] = "error";
						break 2;
					} else {
						$error_counter--;
						break 1; 									// break from switch-case and do-while, also
					}
				//~ }
			case "PIN_OK":
				if( $prev_status == "PUK_NEEDED" ) {
					$r['status'] = "success";
					break 2;
				} else {
					$r['status'] = "success";
					break 2;
				}
				break 1; 									// break from switch-case and do-while, also
			case "PUK_NEEDED":
				if( $error_counter == 0 ) {
					$r['data']['sim_status']['attempts'] = $conn->read("sim_attempts");
					$_SESSION['sim-setup'] = "puk-input";
					$r['status'] = "error";
					break 2;
				} else {
					$error_counter--;
					break 1; 									// break from switch-case and do-while, also
				}
				break 2; 									// break from switch-case and do-while, also
			default:
				$r['status'] = "error";
				$r['msg'] = "unknown state";
				break 2; 									// break from switch-case and do-while, also
		}
	} while(true);
	return $r;
}
function get_uptime() {
	if( PHPOS !== "WIN" ) {
		$tmp = explode(' ', file_get_contents('/proc/uptime'));
	} else {
		$tmp[0] = 100;
	}

    return intval($tmp[0]);
}
?>
