# ************************************************************************** #
# Input Parameters                                                           #
# --------------------------------                                           #
# $1 path and filename of the FW update file                                 #
# $2 iname of the CERTIFICATE or PUBLIC KEY used for signature verification  #
# $3 base64 string of the signature                                          #
# ************************************************************************** #

#!/bin/sh

filepath=$1
iname=$2
signature=$3

if [ -z "$filepath" -o  ! -f $filepath ];then
  echo "ERROR :: file \"$filepath\" not found. Please provide valid file."
  exit 1
fi

if [ -z "$iname" ];then
  echo "ERROR :: iname not present. Please provide valid iname."
  exit 2
fi

if [ -z "$signature" ];then
  echo "ERROR :: signature not present. Please provide valid signature."
  exit 3
fi

/system/marvell/tel/usign $filepath $iname $signature

RESULT=$?
if [ $RESULT != 0 ]; then
  echo "ERROR :: signature verification failed"
  exit 4
fi

echo "SUCCESS :: signature verification OK"

echo "INFO :: starting fw install process"

mkdir -p /cache/recovery
echo "--update_package=$filepath" > /cache/recovery/command

# Disable PANIC DRAW after we kill telephony processes
echo 1 > /sys/module/seh/parameters/hawk_fota_active

sync

# DO NOT CHANGE bellow print - since User Test APK parses it.
echo "FOTA REBOOT."
eeh -F 1
