#!/bin/sh
#
# Description: wlan test script
# Parameters:
#   $1 BAND - set wlan band: 0-BG 1-A
#   $2 CHANNEL - set wlan channel
#   $3 DATARATE - set wlan tx datarate 
#   $4 POWER - set power at antenna (only for TX mode)
#   $5 MODE - set wlan test mode: TX-continous tx mode; RX-rx mode
#   $6 BANDWIDTH - set channel bandwidth
#

BAND=${1:-0}
CHANNEL=${2:-6}
DATARATE=${3:-0}
POWER=${4:-20}
MODE=${5:-RX}
BANDWIDTH=${6:-0}

# name of the interface the device is connected to
INTERFACE_NAME=mlan0

# switch baseband to the test mode
# U_M39G_MV-2339 U_M39G_MV-2339
#load_mfg_8787.sh

TEST_INTERFACE_CHECK=`load_mfg_8787.sh && echo "0" || echo "1"`
log "TEST_INTERFACE_CHECK _ $TEST_INTERFACE_CHECK _0=OK"
if [ "${TEST_INTERFACE_CHECK}" == "1" ] ; then
	return 1;
fi

log "Running dutcmd with: BAND=$BAND CH=$CHANNEL DATARATE=$DATARATE POWER=$POWER MODE=$MODE BW=$BANDWIDTH"

# set band
dutcmd $INTERFACE_NAME 30 $BAND
# set rf channel
dutcmd $INTERFACE_NAME 12 $CHANNEL
# set power
if [ "$DATARATE" -lt "5" ]; then
	dutcmd $INTERFACE_NAME 22 $CHANNEL $POWER 0
else
	dutcmd $INTERFACE_NAME 22 $CHANNEL $POWER 1
fi
# set bandwidth for 11n modes (MCS)
if [ "$DATARATE" -gt "14" ]; then
	dutcmd $INTERFACE_NAME 112 $BANDWIDTH
else
	# TOBY_L200_50S-118
	echo "WifiIf_OpenDevice"
fi

# run test.
if [ "$MODE" == "TX" ]; then
	# start packet tx (with duty cycle)
	dutcmd $INTERFACE_NAME 25 1 $DATARATE
elif [ "$MODE" == "CTX" ]; then
	# start continuous modulated tx mode
	dutcmd $INTERFACE_NAME 17 1 $DATARATE
elif [ "$MODE" == "CW" ]; then
	# start CW mode
	dutcmd $INTERFACE_NAME 18 1
else
	# RX mode
	true
	# TOBY_L200_50S-118
	echo "WifiIf_OpenDevice"
fi
