#!/bin/sh
#
# Main WiFi configuration script
#

#*** u-blox modifications *** TOBY_L200_50S-161
. /system/marvell/tel/8787_common.cfg

#######################################
# Global defines
#######################################
readonly TEMP_DIR=/mrvlsys
readonly RESOLV_CONF=/tmp/resolv.conf
readonly RESOLV_CONF_DNS=/tmp/resolv-dnsmasq.conf
readonly UAPUTL='8787_uaputl.exe -i uap0'
readonly MLANUTL='8787_mlanutl mlan0'
readonly WPA_SUPPLICANT_CONF=/tmp/wpa_supplicant.conf
readonly RFKILL=/sys/class/rfkill/rfkill0/state
# TOBY_L200_50S-202 M39G_MV_2-380
readonly WWW_DIR=/system/marvell/www
readonly WWW_DATA_DIR=/data/www

# M39G_MV_2-760 M39G_MV_2-428
readonly LWCONFIG_APP=/system/marvell/bin/lwconfig
readonly LWCONFIG_APP_DEFAULT_DB=--db=default
readonly LWCONFIG_APP_USER_DB=--db=user
readonly LWCONFIG_APP_STATUS_DB=--db=status
readonly MOUNT_APP=/system/xbin/mount
readonly GETPROP_APP=/system/bin/getprop
readonly WIFIMAN_APP=wifiMan
readonly RUN_WIFIMAN_SCRIPT=/system/marvell/tel/run_wifiMan.sh
readonly WIFIMAN_PID_FILE=/tmp/wifiMan.pid
readonly RM_APP=/system/xbin/rm
# M39G_MV_2-1303 M39G_MV_2-428
readonly MODEMMAN_PID_FILE=/tmp/modemMan.pid
readonly MODEMMAN_FIFO_FILE=/tmp/modemMan.fifo
# list of supported data rates
readonly UAP_BASIC_RATES='0x82 0x84 0x8b 0x96'
readonly UAP_NON_BASIC_RATES='0xc 0x12 0x18 0x24 0x30 0x48 0x60 0x6c'

# valid channels for automatic channel selection (ACS) mode
readonly UAP_ACS_CHANNELS='1 2 3 4 5 6 7 8 9 10 11'
readonly UAP_ACS_CHANNELS_5GHZ='36 40 44 48 52 56 60 64'

readonly UAP_CHANNELS_5GHZ_2ND_ABOVE=':36:44:52:60:100:108:116:124:132:140:149:157:'
readonly UAP_CHANNELS_5GHZ_2ND_BELOW=':40:48:56:64:104:112:120:128:136:144:153:161:'

# M39G_MV_2-1845 U_M39G_MV-2256
readonly SYSTEM_CONFIG_HOST=`getprop ro.cmdline.SYCG 0`
readonly IP_TERMINATION_AUX=`getprop ro.cmdline.IPTM 0`
readonly ECHO_APP=/system/xbin/echo
# U_M39G_MV-2244
readonly DNSMASQ_APP=/system/marvell/tel/dnsmasq
readonly IFCONFIG_APP=/system/xbin/ifconfig
readonly MKDIR_APP=/system/xbin/mkdir
readonly LN_APP=/system/xbin/ln

# U_M39G_MV-2243
readonly MAX_STA_CLIENT='8'
# U_M39G_MV-2332
readonly TXPOWER_LIMIT_FILE=/system/marvell/tel/txpwrlimit_cfg.conf

# M39G_MV-2130
#######################################
# Prevent starting WI-Fi AP is password and auth_suite are not set
# 1 -> block the AP
# 0 -> do not block tha AP
#######################################
prevent_starting_ap()
{
	log "***************AP passwrd .$1."
	log "***************AP a_suite .$2."
	SECURITY_MODE=$(${LWCONFIG_APP} read wibear_uap0_security_mode)
	SECURITY_KEY=$(${LWCONFIG_APP} read wibear_uap0_security_key)
	log "*************** wibear_uap0_security_key .$SECURITY_KEY."
	log "*************** wibear_uap0_security_mode .$SECURITY_MODE."

	if [ "$1" == "" ] && [ "$2" == "" ] && [ "$SECURITY_MODE" == "" ] && [ "$SECURITY_KEY" == "" ] ; then
		log "************** prevent from starting AP wifi"
		echo "1";
	else
		if [ "$2" == "OPEN" ] && [ "$1" == "" ] ; then
			echo "1";
		else
			echo "0";
		fi
	fi
}

#######################################
# Prevent starting WI-Fi STA is password and auth_suite are not set
# 1 -> block the STA
# 0 -> do not block tha STA
#######################################
prevent_starting_sta()
{
	log "***************STA passwrd .$1."
	log "***************STA a_suite .$2."
	SECURITY_MODE=$(${LWCONFIG_APP} read wibear_mlan0_security_mode)
	SECURITY_KEY=$(${LWCONFIG_APP} read wibear_mlan0_security_key)
	log "*************** wibear_mlan0_security_key .$SECURITY_KEY."
	log "*************** wibear_mlan0_security_mode .$SECURITY_MODE."

	if [ "$1" == "" ] && [ "$2" == "" ] && [ "$SECURITY_MODE" == "" ] && [ "$SECURITY_KEY" == "" ] ; then
		log "************** prevent from starting STA wifi"
		echo "1";
	else
		if [ "$2" == "OPEN" ] && [ "$1" == "" ] ; then
			echo "1";
		else
			echo "0";
		fi
	fi
}

# TOBY_L200_50S-49
#######################################
# Set the default country code
#######################################
set_country()
{
	log "set_country"
# M39G_MV_2-492
# u-blox modification: lesswire code removed 
	# board code:
	# EU: L210 (D2), L280 (D3)
	# US: L200 (D1), L201 (D4)
	# JP: L220 (D5)
	
# M39G_MV_2-760
	DEFAULT_BOARD=`${GETPROP_APP} ro.cmdline.BOAR`
	DEFAULT_COUNTRY="US";
	if [ "$DEFAULT_BOARD" == "d2" -o "$DEFAULT_BOARD" == "D2" -o "$DEFAULT_BOARD" == "d3" -o "$DEFAULT_BOARD" == "D3" ] ; then
		DEFAULT_COUNTRY="EU";
	elif [ "$DEFAULT_BOARD" == "d4" -o "$DEFAULT_BOARD" == "D4" -o "$DEFAULT_BOARD" == "d1" -o "$DEFAULT_BOARD" == "D1" ] ; then
		DEFAULT_COUNTRY="US";
	elif [ "$DEFAULT_BOARD" == "d5" -o "$DEFAULT_BOARD" == "D5" ] ; then
		DEFAULT_COUNTRY="JP";
	else
		log "Unexpected values for DEFAULT_BOARD!";
	fi
# M39G_MV_2-760
	# factory-programmed value present in the default detabase
	# these operations are applied only at the first boot
	CURRENT_DEFAULT_COUNTRY=`${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} read wibear_uap0_country`
# U_M39G_MV-2289
	CURRENT_REG_DOMAIN=`${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} read region_blocked`
	if [ "$DEFAULT_COUNTRY" != "$CURRENT_DEFAULT_COUNTRY" ] && [ "$CURRENT_REG_DOMAIN" != "OFF" ] ; then
		${MOUNT_APP} -o rw,remount /system
		# the value should be updated
		if [ "$DEFAULT_COUNTRY" == "US" ] ; then
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write wibear_uap0_country "US";
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write region_blocked "US";
			${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write region_blocked "US";
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write wifiMan_enable "0";
		elif [ "$DEFAULT_COUNTRY" == "EU" ] ; then
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write wibear_uap0_country "EU";
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write region_blocked "EU";
			${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write region_blocked "EU";
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write wifiMan_enable "1";
# M39G_MV_2-492
		elif [ "$DEFAULT_COUNTRY" == "JP" ] ; then
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write wibear_uap0_country "JP";
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write region_blocked "JP";
			${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write region_blocked "JP";
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write wifiMan_enable "1";
		else 
			log "Unexpected values for DEFAULT_COUNTRY!";
			# set to US
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write wibear_uap0_country "US";
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write region_blocked "US";
			${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write region_blocked "US";
			${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} write wifiMan_enable "1";
		fi
		${MOUNT_APP} -o ro,remount /system
	fi
# M39G_MV_2-760
# these settings are applied if the option region_bloced is not present in the user db
	CURRENT_USER_REG_BLOCK=`${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} read region_blocked`
	if [ "$CURRENT_USER_REG_BLOCK" != "OFF" ] && [ "$CURRENT_USER_REG_BLOCK" != "US" ] && [ "$CURRENT_USER_REG_BLOCK" != "EU" ] && [ "$CURRENT_USER_REG_BLOCK" != "JP" ] ; then
		# the value should be updated
		if [ "$DEFAULT_COUNTRY" == "US" ] ; then
			${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write region_blocked "US";
		elif [ "$DEFAULT_COUNTRY" == "EU" ] ; then
			${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write region_blocked "EU";
		elif [ "$DEFAULT_COUNTRY" == "JP" ] ; then
			${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write region_blocked "JP";
		else 
			log "Unexpected values for DEFAULT_COUNTRY! Nothing to set";
			# set to US
		fi
	fi
	
	# nothing to do
}
# TOBY_L200_50S-49

#######################################
# Write to Android log
#######################################
log()
{
	/system/bin/log -t wifi:init "$*"
}

#*** u-blox modifications *** TOBY_L200_50S-153
#######################################
# Unset SDIO line for wifi
#######################################
unset_sdio_line()
{
# U_M39G_MV-2244 M39G_MV_2-364 M39G_MV_2-760 U_M39G_MV-2339
	insmod /system/marvell/tel/hwmap.ko 2>/dev/null # U_M39G_MV-2565 in case the module is already mounted
#*** u-blox modifications *** TOBY_L200_50S-132 TOBY_L200_50S-176
	log "unset_sdio_line"
	# MFPR0  = SDIO_D0 idle
	hwacc w 0x40e10190 0xa0c8 2>/dev/null
	# MFPR1  = SDIO_D1 idle
	hwacc w 0x40e10194 0xa0c8 2>/dev/null
	# MFPR2  = SDIO_D2 idle
	hwacc w 0x40e10198 0xa0c8 2>/dev/null
	# MFPR3  = SDIO_D3 idle
	hwacc w 0x40e1019c 0xa0c8 2>/dev/null
	# MFPR4  = SDIO_CLK idle
	hwacc w 0x40e101a0 0xa0c8 2>/dev/null
	# MFPR5  = SDIO_CMD idle
	hwacc w 0x40e101a4 0xa0c8 2>/dev/null
# U_M39G_MV-2244 M39G_MV_2-364
#	rmmod hwmap.ko # U_M39G_MV-2565
}

#######################################
# Load driver for 8787
#######################################
load_8787_driver()
{
#*** u-blox modifications *** TOBY_L200_50S-153  U_M39G_MV-2339
	log "unload_8787_driver"
	set_sdio_line
	echo 1 >${RFKILL}
	modprobe mlan
	modprobe sd8787

	for i in 1 2 3 4 5; do
		log "probing uap0 ... $i"
		grep -q "uap0:" /proc/net/dev && break
		sleep 1
	done

	if ! grep -q "uap0:" /proc/net/dev; then
		log "uap0 not found!"
		echo 0 >${RFKILL}
# M39G_MV_2-1846
		set_wifi_pwr_mode "OFF"

# U_M39G_MV_2-2273 U_M39G_MV-2339
		unset_sdio_line > /dev/null
		return 1
	fi

	return 0
}

#*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-161 U_M39G_MV-2339
#######################################
# Unload 8787 driver
#######################################
unload_8787_driver()
{
	log "unload_8787_driver"
	echo 0 >${RFKILL}
	rmmod sd8xxx
	rmmod mlan
# U_M39G_MV-2339
	unset_sdio_line > /dev/null
}

#######################################
# Sets global MODE and BAND variables
#######################################
get_80211_mode()
{
# M39G_MV_2-760 M39G_MV_2-1124
	MODE=$(${LWCONFIG_APP} read wibear_uap0_mode)
	if [ "$MODE" == "A" -o "$MODE" == "AN" -o "$MODE" == "AN_MIXED" ] ; then
		BAND=5
	else
		BAND=2.4
	fi
}

#######################################
# Configure & start WiFi Access Point
#######################################
start_wifi_ap()
{
	${UAPUTL} sys_reset


# M39G_MV_2-2130 U_M39G_MV-2278
log "*************** $1 password"
log "*************** $2 auth_suite"
	if [ "$1" != "" ] && [ "$2" != "" ] ; then
		log "************** $1 and $2 not ZERO"
		VOLATILE_AUTH="ON"
		SECURITY_MODE=$2;
		SECURITY_KEY=$1;
	else
		log "************** $1 or $2 ZERO"
		VOLATILE_AUTH="OFF"
	fi

# M39G_MV_2-760
	# read config
	SSID=$(${LWCONFIG_APP} read wibear_uap0_ssid)
	CHANNEL=$(${LWCONFIG_APP} read wibear_uap0_channel)
	# M39G_MV_2-492
	# u-blox modification: lesswire code removed 
	# read region_blocked value
	REGION_BLOCKED=$(${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} read region_blocked)
	
	# factory-programmed value present in the default detabase
	DEFAULT_COUNTRY=`${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} read wibear_uap0_country`
	if [ "$REGION_BLOCKED" == "OFF" ] ; then 
		# region block disabled
		COUNTRY=$(${LWCONFIG_APP} read wibear_uap0_country)

		##${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "$DEFAULT_COUNTRY";
		##COUNTRY=$DEFAULT_COUNTRY;
	elif [ "$REGION_BLOCKED" == "JP" ] ; then 
		# camped on JP networks
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "JP";
		COUNTRY="JP";
	elif [ "$REGION_BLOCKED" == "US" ] ; then 
		# camped on US networks
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "US";
		COUNTRY="US";
	elif [ "$REGION_BLOCKED" == "EU" ] ; then 
		# camped on EU/rest of the world networks
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "EU";
		COUNTRY="EU";
	elif [ "$REGION_BLOCKED" != 0 ] ; then
		log "force:country: unknown, force to US"
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "US";
		COUNTRY="US";
	fi
	
	[ "$COUNTRY" == "EU" ] && COUNTRY="DE"	# any from ETSI
# M39G_MV_2-2130 U_M39G_MV-2278
	if [ "$VOLATILE_AUTH" == "OFF"  ] ; then
	SECURITY_MODE=$(${LWCONFIG_APP} read wibear_uap0_security_mode)
	if [ "$SECURITY_MODE" != "OPEN" ] ; then
		SECURITY_KEY=$(${LWCONFIG_APP} read wibear_uap0_security_key)
# M39G_MV_2-2130
	fi
	fi

	# ssid
	${UAPUTL} sys_cfg_ssid "$SSID"

	# channel
	if [ "$BAND" == "2.4" ] ; then
		if [ "$CHANNEL" == "AUTO" ] ; then
			${UAPUTL} sys_cfg_scan_channels $UAP_ACS_CHANNELS
			${UAPUTL} sys_cfg_channel 0 1  # ACS
		else
			${UAPUTL} sys_cfg_channel $CHANNEL
		fi
	else
		if [ "$CHANNEL" == "AUTO" ] ; then
			${UAPUTL} sys_cfg_scan_channels $UAP_ACS_CHANNELS_5GHZ
			${UAPUTL} sys_cfg_channel 0 1  # ACS
		elif [ "${UAP_CHANNELS_5GHZ_2ND_ABOVE#*:${CHANNEL}:}" != "$UAP_CHANNELS_5GHZ_2ND_ABOVE" ] ; then
			${UAPUTL} sys_cfg_channel $CHANNEL 2
		elif [ "${UAP_CHANNELS_5GHZ_2ND_BELOW#*:${CHANNEL}:}" != "$UAP_CHANNELS_5GHZ_2ND_BELOW" ] ; then
			${UAPUTL} sys_cfg_channel $CHANNEL 4
		fi
	fi

	# 802.11a/b/g/n config
	case $MODE in
	B)            # 11b(2.4GHz) only
		${UAPUTL} sys_cfg_11n 0
		${UAPUTL} sys_cfg_rates $UAP_BASIC_RATES
		;;
	BG_MIXED|G)   # 11bg(2.4GHz) mixed
		${UAPUTL} sys_cfg_11n 0
		${UAPUTL} sys_cfg_rates $UAP_BASIC_RATES $UAP_NON_BASIC_RATES
		;;
	BGN_MIXED)    # 11bgn(2.4GHz) mixed
		${UAPUTL} sys_cfg_2040_coex 1            # enable 20/40 BSS coexistence
		${UAPUTL} sys_cfg_11n 1 0x116e 3 0 0xff  # 11n, 40MHz, short GI, MCS0-7
		${UAPUTL} sys_cfg_rates $UAP_BASIC_RATES $UAP_NON_BASIC_RATES
		;;
	N)            # 11n(2.4GHz) only (Greenfield)
		${UAPUTL} sys_cfg_2040_coex 0            # disable 20/40 coexistence
		${UAPUTL} sys_cfg_11n 1 0x117e 3 0 0xff  # 11n, 40MHz, short GI, MCS0-7, Greenfield
		${UAPUTL} sys_cfg_rates $UAP_BASIC_RATES $UAP_NON_BASIC_RATES
		;;
	A)            # 11g(5GHz) only
		${UAPUTL} sys_cfg_11n 0
		${UAPUTL} sys_cfg_rates $UAP_NON_BASIC_RATES
		;;
	AN_MIXED)     # 11an(5GHz) mixed
		${UAPUTL} sys_cfg_2040_coex 1            # enable 20/40 BSS coexistence
		${UAPUTL} sys_cfg_11n 1 0x116e 3 0 0xff  # 11n, 40MHz, short GI, MCS0-7
		${UAPUTL} sys_cfg_rates $UAP_NON_BASIC_RATES
		;;
	AN)           # 11n(5GHz) only (Greenfield)
		${UAPUTL} sys_cfg_2040_coex 0            # disable 20/40 coexistence
		${UAPUTL} sys_cfg_11n 1 0x117e 3 0 0xff  # 11n, 40MHz, short GI, MCS0-7, Greenfield
		${UAPUTL} sys_cfg_rates $UAP_NON_BASIC_RATES
		;;
	esac

	# 802.11d
	${UAPUTL} sys_cfg_80211d state 1 country $COUNTRY

	# power
	${UAPUTL} sys_cfg_tx_power 20

	# security
	case "$SECURITY_MODE" in
	OPEN)	# OPEN
		${UAPUTL} sys_cfg_auth 0       # open
		${UAPUTL} sys_cfg_protocol 1   # no encryption
		${UAPUTL} sys_cfg_cipher 0 0   # tkip
		;;
	WPA2)	# WPA2-PSK-CCMP
		${UAPUTL} sys_cfg_auth 0       # open
		${UAPUTL} sys_cfg_protocol 32  # wpa2
		${UAPUTL} sys_cfg_wpa_passphrase "$SECURITY_KEY"
		${UAPUTL} sys_cfg_cipher 8 8   # ccmp
		;;
# M39G_MV_2-655
	WPA_WPA2_MIXED)	# WPA2-PSK-TKIP+CCMP
		${UAPUTL} sys_cfg_auth 0       # open
		${UAPUTL} sys_cfg_protocol 40  # wpa|wpa2
		${UAPUTL} sys_cfg_wpa_passphrase "$SECURITY_KEY"
		${UAPUTL} sys_cfg_cipher 12 4  # tkip|ccmp
		;;
	WPA)	# WPA
		${UAPUTL} sys_cfg_auth 0       # open
		${UAPUTL} sys_cfg_protocol 8  # wpa
		${UAPUTL} sys_cfg_wpa_passphrase "$SECURITY_KEY"
		${UAPUTL} sys_cfg_cipher 12 4  # tkip|ccmp
		;;
	esac

	# start BSS
# U_M39G_MV-2243
	${UAPUTL} sys_cfg_max_sta_num ${MAX_STA_CLIENT}
# U_M39G_MV-2332
	${UAPUTL} hostcmd ${TXPOWER_LIMIT_FILE} txpwrlimit_2g_cfg_set
	${MLANUTL} hostcmd ${TXPOWER_LIMIT_FILE} txpwrlimit_2g_cfg_set

	${UAPUTL} bss_start
	log "BSS started."

# M39G_MV_2-1845
# enable IPv4 forwarding on interfaces
	${ECHO_APP} 1 > /proc/sys/net/ipv4/ip_forward

}

# M39G_MV_2-1124
#######################################
# Configure channel, rate and regulatory domain of the Wi-Fi Access Point
#######################################
set_transmission_conf_wifi_ap()
{
	# read channel
	CHANNEL=$(${LWCONFIG_APP} read wibear_uap0_channel)
	# read region_blocked value
	REGION_BLOCKED=$(${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} read region_blocked)

	get_80211_mode
	
	# factory-programmed value present in the default detabase
	DEFAULT_COUNTRY=`${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} read wibear_uap0_country`
	if [ "$REGION_BLOCKED" == "OFF" ] ; then 
		# region block disabled
		COUNTRY=$(${LWCONFIG_APP} read wibear_uap0_country)

	elif [ "$REGION_BLOCKED" == "JP" ] ; then 
		# camped on JP networks
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "JP";
		COUNTRY="JP";
	elif [ "$REGION_BLOCKED" == "US" ] ; then 
		# camped on US networks
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "US";
		COUNTRY="US";
	elif [ "$REGION_BLOCKED" == "EU" ] ; then 
		# camped on EU/rest of the world networks
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "EU";
		COUNTRY="EU";
	elif [ "$REGION_BLOCKED" != 0 ] ; then
		log "force:country: unknown, force to US"
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_uap0_country "US";
		COUNTRY="US";
	fi
	
	[ "$COUNTRY" == "EU" ] && COUNTRY="DE"	# any from ETSI

	# channel
	if [ "$BAND" == "2.4" ] ; then
		if [ "$CHANNEL" == "AUTO" ] ; then
			${UAPUTL} sys_cfg_scan_channels $UAP_ACS_CHANNELS
			${UAPUTL} sys_cfg_channel 0 1  # ACS
		else
			${UAPUTL} sys_cfg_channel $CHANNEL
		fi
	else
		if [ "$CHANNEL" == "AUTO" ] ; then
			${UAPUTL} sys_cfg_scan_channels $UAP_ACS_CHANNELS_5GHZ
			${UAPUTL} sys_cfg_channel 0 1  # ACS
		elif [ "${UAP_CHANNELS_5GHZ_2ND_ABOVE#*:${CHANNEL}:}" != "$UAP_CHANNELS_5GHZ_2ND_ABOVE" ] ; then
			${UAPUTL} sys_cfg_channel $CHANNEL 2
		elif [ "${UAP_CHANNELS_5GHZ_2ND_BELOW#*:${CHANNEL}:}" != "$UAP_CHANNELS_5GHZ_2ND_BELOW" ] ; then
			${UAPUTL} sys_cfg_channel $CHANNEL 4
		fi
	fi

	# 802.11a/b/g/n config
	case $MODE in
	B)            # 11b(2.4GHz) only
		${UAPUTL} sys_cfg_11n 0
		${UAPUTL} sys_cfg_rates $UAP_BASIC_RATES
		;;
	BG_MIXED|G)   # 11bg(2.4GHz) mixed
		${UAPUTL} sys_cfg_11n 0
		${UAPUTL} sys_cfg_rates $UAP_BASIC_RATES $UAP_NON_BASIC_RATES
		;;
	BGN_MIXED)    # 11bgn(2.4GHz) mixed
		${UAPUTL} sys_cfg_2040_coex 1            # enable 20/40 BSS coexistence
		${UAPUTL} sys_cfg_11n 1 0x116e 3 0 0xff  # 11n, 40MHz, short GI, MCS0-7
		${UAPUTL} sys_cfg_rates $UAP_BASIC_RATES $UAP_NON_BASIC_RATES
		;;
	N)            # 11n(2.4GHz) only (Greenfield)
		${UAPUTL} sys_cfg_2040_coex 0            # disable 20/40 coexistence
		${UAPUTL} sys_cfg_11n 1 0x117e 3 0 0xff  # 11n, 40MHz, short GI, MCS0-7, Greenfield
		${UAPUTL} sys_cfg_rates $UAP_BASIC_RATES $UAP_NON_BASIC_RATES
		;;
	A)            # 11g(5GHz) only
		${UAPUTL} sys_cfg_11n 0
		${UAPUTL} sys_cfg_rates $UAP_NON_BASIC_RATES
		;;
	AN_MIXED)     # 11an(5GHz) mixed
		${UAPUTL} sys_cfg_2040_coex 1            # enable 20/40 BSS coexistence
		${UAPUTL} sys_cfg_11n 1 0x116e 3 0 0xff  # 11n, 40MHz, short GI, MCS0-7
		${UAPUTL} sys_cfg_rates $UAP_NON_BASIC_RATES
		;;
	AN)           # 11n(5GHz) only (Greenfield)
		${UAPUTL} sys_cfg_2040_coex 0            # disable 20/40 coexistence
		${UAPUTL} sys_cfg_11n 1 0x117e 3 0 0xff  # 11n, 40MHz, short GI, MCS0-7, Greenfield
		${UAPUTL} sys_cfg_rates $UAP_NON_BASIC_RATES
		;;
	esac

	# 802.11d
	${UAPUTL} sys_cfg_80211d state 1 country $COUNTRY

}






#######################################
# Stop WiFi AP
#######################################
stop_wifi_ap()
{
	${UAPUTL} bss_stop
}

#######################################
# Configure IP and start services
#######################################
start_ip_services()
{
# M39G_MV_2-1845
	if [ "$BRIDGE_MODE" == "1" ] ; then
		log "BRIDGE mode usb0 uap0 return 1"
		return 1;
	fi

#*** u-blox modifications *** TOBY_L200_50S-153
	if ! grep -q "uap0:" /proc/net/dev; then
		log "uap0 not found!"
		echo 0 >${RFKILL}
		return 1
	fi

#*** u-blox modifications *** TOBY_L200_50S-38
#	USB_IP=$(lwconfig read net_iface_usb0_address)
#	USB_NETMASK=$(lwconfig read net_iface_usb0_netmask)
#	USB_DHCP_RANGE=$(lwconfig read dhcp_range_usb0)
# M39G_MV_2-760
USB_DHCPSTART=`${GETPROP_APP} persist.sys.ublx_rndis0_dhcpst`
USB_DHCPSTOP=`${GETPROP_APP} persist.sys.ublx_rndis0_dhcpsp`
USB_IP=`${GETPROP_APP} persist.sys.ublx_rndis0_ipaddr`
USB_NETMASK=`${GETPROP_APP} persist.sys.ublx_rndis0_ipmask`

if [ -z "$USB_IP" ] || [ -z "$USB_NETMASK" ] ||  [ -z "USB_DHCPSTART" ] || [ -z "USB_DHCPSTOP" ] ; then
	setprop persist.sys.ublx_rndis0_ipaddr 192.168.1.1
	setprop persist.sys.ublx_rndis0_ipmask 255.255.255.0
	setprop persist.sys.ublx_rndis0_dhcpst 192.168.1.100
	setprop persist.sys.ublx_rndis0_dhcpsp 192.168.1.100
# M39G_MV_2-760
	USB_DHCPSTART=`${GETPROP_APP} persist.sys.ublx_rndis0_dhcpst`
	USB_DHCPSTOP=`${GETPROP_APP} persist.sys.ublx_rndis0_dhcpsp`
	USB_IP=`${GETPROP_APP} persist.sys.ublx_rndis0_ipaddr`
	USB_NETMASK=`${GETPROP_APP} persist.sys.ublx_rndis0_ipmask`
fi
#*** u-blox modifications *** TOBY_L200_50S-38
	ifconfig usb0 $USB_IP netmask $USB_NETMASK up

# M39G_MV_2-760
	UAP_IP=$(${LWCONFIG_APP} read net_iface_uap0_address)
	UAP_NETMASK=$(${LWCONFIG_APP} read net_iface_uap0_netmask)
	UAP_DHCP_RANGE=$(${LWCONFIG_APP} read dhcp_range_uap0)
	ifconfig uap0 $UAP_IP netmask $UAP_NETMASK

	ln -sf ${RESOLV_CONF} ${RESOLV_CONF_DNS}
# M39G_MV_2-760
	HOSTNAME=$(${LWCONFIG_APP} read hostname)
	echo "${USB_IP} ${HOSTNAME}.ip ${HOSTNAME}" >/var/run/hosts_extra
	echo "${UAP_IP} ${HOSTNAME}.ip ${HOSTNAME}" >>/var/run/hosts_extra
#*** u-blox modifications *** TOBY_L200_50S-38
#	dnsmasq -K -F ${UAP_DHCP_RANGE},12h -F ${USB_DHCP_RANGE},12h -r ${RESOLV_CONF_DNS} \
#		-H /var/run/hosts_extra -y -l ${TEMP_DIR}/dnsmasq.leases -x ${TEMP_DIR}/dnsmasq.pid \
#		-8 ${TEMP_DIR}/dnsmasq.log </dev/tty0

#M39G_MV_2-2867
	DNSMASQ_UAP_NETMASK_OPTION=",${UAP_NETMASK}"
	DNSMASQ_RNDIS_NETMASK_OPTION=",${USB_NETMASK}"

	dnsmasq -K -F ${UAP_DHCP_RANGE}${DNSMASQ_UAP_NETMASK_OPTION},12h -F ${USB_DHCPSTART},${USB_DHCPSTOP}${DNSMASQ_RNDIS_NETMASK_OPTION},12h -r ${RESOLV_CONF_DNS} \
		-H /var/run/hosts_extra -y -l ${TEMP_DIR}/dnsmasq.leases -x ${TEMP_DIR}/dnsmasq.pid \
		-8 ${TEMP_DIR}/dnsmasq.log </dev/tty0
#*** u-blox modifications *** TOBY_L200_50S-38
	log "dnsmasq[$(pgrep dnsmasq)] started."

#TOBY-L200-50S-100
# WebUI disabled by default
#       httpd -c /system/marvell/etc/httpd.conf
#       log "httpd[$(pgrep httpd)] started."
#TOBY-L200-50S-100
#*** u-blox modifications *** TOBY_L200_50S-153
	return 0
}

#*** u-blox modifications *** TOBY_L200_50S-38
#######################################
# Configure IP and start services for usb0 interface
# when the wireless interface is not mounted
#######################################
start_ip_usb0_only_services()
{
#*** u-blox modifications ***
#	USB_IP=$(lwconfig read net_iface_usb0_address)
#	USB_NETMASK=$(lwconfig read net_iface_usb0_netmask)
#	USB_DHCP_RANGE=$(lwconfig read dhcp_range_usb0)
# M39G_MV_2-760

# M39G_MV_2-1845
	if [ "$BRIDGE_MODE" == "1" ] ; then
		log "BRIDGE mode usb0 only return 1"
		return 1;
	fi

USB_DHCPSTART=`${GETPROP_APP} persist.sys.ublx_rndis0_dhcpst`
USB_DHCPSTOP=`${GETPROP_APP} persist.sys.ublx_rndis0_dhcpsp`
USB_IP=`${GETPROP_APP} persist.sys.ublx_rndis0_ipaddr`
USB_NETMASK=`${GETPROP_APP} persist.sys.ublx_rndis0_ipmask`

if [ -z "$USB_IP" ] || [ -z "$USB_NETMASK" ] ||  [ -z "USB_DHCPSTART" ] || [ -z "USB_DHCPSTOP" ] ; then
	setprop persist.sys.ublx_rndis0_ipaddr 192.168.1.1
	setprop persist.sys.ublx_rndis0_ipmask 255.255.255.0
	setprop persist.sys.ublx_rndis0_dhcpst 192.168.1.100
	setprop persist.sys.ublx_rndis0_dhcpsp 192.168.1.100
# M39G_MV_2-760
	USB_DHCPSTART=`${GETPROP_APP} persist.sys.ublx_rndis0_dhcpst`
	USB_DHCPSTOP=`${GETPROP_APP} persist.sys.ublx_rndis0_dhcpsp`
	USB_IP=`${GETPROP_APP} persist.sys.ublx_rndis0_ipaddr`
	USB_NETMASK=`${GETPROP_APP} persist.sys.ublx_rndis0_ipmask`
fi
#M39G_MV_2-2058
	${IFCONFIG_APP} usb0 $USB_IP netmask $USB_NETMASK up 2>/dev/null

	${LN_APP} -sf ${RESOLV_CONF} ${RESOLV_CONF_DNS}
# M39G_MV_2-760
	HOSTNAME=$(${LWCONFIG_APP} read hostname)
	${ECHO_APP} "${USB_IP} ${HOSTNAME}.ip ${HOSTNAME}" >/var/run/hosts_extra

#M39G_MV_2-2867
	DNSMASQ_RNDIS_NETMASK_OPTION=",${USB_NETMASK}"

	${DNSMASQ_APP} -K -F ${USB_DHCPSTART},${USB_DHCPSTOP}${DNSMASQ_RNDIS_NETMASK_OPTION},12h -r ${RESOLV_CONF_DNS} \
		-H /var/run/hosts_extra -y -l ${TEMP_DIR}/dnsmasq.leases -x ${TEMP_DIR}/dnsmasq.pid \
		-8 ${TEMP_DIR}/dnsmasq.log </dev/tty0

# M39G_MV_2-1845
#	log "dnsmasq[$(pgrep dnsmasq)] started."
	log "dnsmasq[$(pgrep dnsmasq)] started usb0."
}
#*** u-blox modifications *** TOBY_L200_50S-38

# M39G_MV_2-1845
#######################################
# Configure IP and start services for uap0 interface
# when TOBY-L2 is in router mode
# In bridge mode this configuration is valid
#######################################
start_ip_uap0_only_services()
{

	if [ "$BRIDGE_MODE" != "1" ] ; then
		log "ROUTER mode uap0 only return 1"
		return 1;
	fi

	if ! grep -q "uap0:" /proc/net/dev; then
		log "uap0 not found!"
		${ECHO_APP} 0 >${RFKILL}
		return 1
	fi

	UAP_IP=$(${LWCONFIG_APP} read net_iface_uap0_address)
	UAP_NETMASK=$(${LWCONFIG_APP} read net_iface_uap0_netmask)
	UAP_DHCP_RANGE=$(${LWCONFIG_APP} read dhcp_range_uap0)
	${IFCONFIG_APP} uap0 ${UAP_IP} netmask ${UAP_NETMASK} up

	${LN_APP} -sf ${RESOLV_CONF} ${RESOLV_CONF_DNS}
	HOSTNAME=$(${LWCONFIG_APP} read hostname)
	${ECHO_APP} "${UAP_IP} ${HOSTNAME}.ip ${HOSTNAME}" >>/var/run/hosts_extra

#M39G_MV_2-2867
	DNSMASQ_UAP_NETMASK_OPTION=",${UAP_NETMASK}"

	${DNSMASQ_APP} -K -F ${UAP_DHCP_RANGE}${DNSMASQ_UAP_NETMASK_OPTION},12h -r ${RESOLV_CONF_DNS} \
		-H /var/run/hosts_extra -y -l ${TEMP_DIR}/dnsmasq.leases -x ${TEMP_DIR}/dnsmasq.pid \
		-8 ${TEMP_DIR}/dnsmasq.log </dev/tty0

	log "dnsmasq[$(pgrep dnsmasq)] started on uap0."
}


#*** u-blox modifications *** TOBY_L200_50S-153
#######################################
# Stop services
#######################################
stop_ip_services()
{
#	killall dnsmasq httpd 2>/dev/null
# M39G_MV_2-2867 M39G_MV_2-2828
# the /tmp/resolv_bridge.conf is no more used
# the /tmp/dnsmasq_bridge.pid is used by MTIL

    if [ ! -e "/tmp/dnsmasq_bridge.pid" ] ; then
    echo "router mode: kill dnsmasq" > /dev/kmsg
    killall dnsmasq 2>/dev/null
    else
    echo "bridge mode: do not kill dnsmasq" > /dev/kmsg
    fi
}

# TOBY_L200_50S-202 M39G_MV_2-380
#######################################
# Install web pages to data dir
#######################################
install_wifi_webui()
{
	rm -rf "$WWW_DATA_DIR"
	mkdir -p "$WWW_DATA_DIR"
	tar xzf "$WWW_DIR"/www-data.tar.gz -C "$WWW_DATA_DIR"
	sync
}

# TOBY_L200_50S-202 M39G_MV_2-380
#######################################
# Stop web page ftp access
#######################################
stop_wifi_webui_ftp()
{
	kill $(pgrep -f 'ftpd') 2>/dev/null
}

# TOBY_L200_50S-202 M39G_MV_2-380
#######################################
# Start web page ftp access
#######################################
start_wifi_webui_ftp()
{
	[ ! -d "$WWW_DATA_DIR" ] && install_wifi_webui
	tcpsvd 0 21 ftpd -t 1800 -w "$WWW_DATA_DIR" 1>/dev/null 2>/dev/null &
	log "ftpd [$(pgrep -n tcpsvd)] started."
}

#*** u-blox modifications *** TOBY_L200_50S-153
#*** u-blox modifications *** TOBY_L200_50S-153
#######################################
# Stop web service
#######################################
stop_wifi_webui_service()
{
	log "httpd[$(pgrep httpd)] stopped."
	killall httpd 2>/dev/null
# M39G_MV_2-760 M39G_MV_2-2058
	if [ "$PWRMODE" != "" ] && [ "$PWRMODE" != "ON" ] && [ "$PWRMODE" != "FLIGHT" ] && [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" != "1" ] ; then
		stop_wifiMan 1>/dev/null 2>/dev/null
	fi

}

#*** u-blox modifications *** TOBY_L200_50S-153
#######################################
# Start web service
#######################################
start_wifi_webui_service()
{
# TOBY_L200_50S-202 M39G_MV_2-380
	[ ! -d "$WWW_DATA_DIR" ] && install_wifi_webui
	httpd -c /system/marvell/etc/httpd.conf
	log "httpd[$(pgrep httpd)] started."
# M39G_MV_2-760
	start_wifiMan
}


#######################################
# Start connection manager
#######################################
start_modemMan()
{
# M39G_MV_2-364 M39G_MV_2-492 M39G_MV_2-760 M39G_MV_2-758 M39G_MV_2-1131
	if ! pgrep modemMan 2>/dev/null; then
#		if [ "$(${LWCONFIG_APP} read modemMan_enable)" == "1" ]; then
			sleep 1
			# M39G_MV_2-1590
			modemMan -d 4
			#modemMan -F
			log "modemMan[$(pgrep modemMan)] started."
#		else
#			log "modemMan disabled."
#		fi
	fi
}

#######################################
# Stop connection manager
#######################################
# M39G_MV_2-1996
stop_modemMan()
{
	# M39G_MV_2-364 M39G_MV_2-492 M39G_MV_2-760
	# u-blox modification: lesswire code removed 
	killall modemMan 2>/dev/null
# M39G_MV_2-1303
	${RM_APP} ${MODEMMAN_PID_FILE}
	${RM_APP} ${MODEMMAN_FIFO_FILE}
	sleep 2
	if pgrep modemMan; then
		killall -9 modemMan 2>/dev/null
# M39G_MV_2-1303
		${RM_APP} ${MODEMMAN_PID_FILE}
		${RM_APP} ${MODEMMAN_FIFO_FILE}
	fi
}

# M39G_MV_2-760
#######################################
# Start wifiMan (manager for SIM detection and wifi regional block)
#######################################
start_wifiMan()
{
# U_M39G_MV-2273
MLAN0_PRESENT=`ifconfig mlan0 2> /dev/null | grep Ethernet | wc -l`
UAP0_PRESENT=`ifconfig uap0 2> /dev/null | grep Ethernet | wc -l`
WEBUI_PRESENT=`pgrep httpd 2> /dev/null | wc -l`

if [ "${MLAN0_PRESENT}" == "1" ] || [ "${UAP0_PRESENT}" == "1" ] || [ "${WEBUI_PRESENT}" == "1" ] ; then 

	if ! pgrep -f ${RUN_WIFIMAN_SCRIPT} 1>/dev/null 2>/dev/null; then
		sleep 1
		${RUN_WIFIMAN_SCRIPT} &
		log "run_wifiMan [$(pgrep wifiMan)] started."
		echo ${RUN_WIFIMAN_SCRIPT} > /dev/kmsg

	else
		log "run_wifiMan running."
	fi
# U_M39G_MV-2273
else
		log "prevent wifiMan to run."
fi 

}

# M39G_MV_2-760 M39G_MV_2-1996 M39G_MV_2-2130
####################################################
# Stop wifiMan (manager for SIM detection and wifi regulatory domains block)
####################################################
stop_wifiMan()
{
	kill -9 `pgrep -f "${RUN_WIFIMAN_SCRIPT}"` 1>/dev/null 2>/dev/null
	sleep 1
	if pgrep -f ${RUN_WIFIMAN_SCRIPT} ; then
		killall -9 `pgrep -f "${RUN_WIFIMAN_SCRIPT}"` 1>/dev/null 2>/dev/null
	fi
	killall ${WIFIMAN_APP} 1>/dev/null 2>/dev/null
	sleep 1
	if [ $(pgrep ${WIFIMAN_APP}) ] ; then
		killall -9 ${WIFIMAN_APP} 1>/dev/null 2>/dev/null
	fi
	${RM_APP} ${WIFIMAN_PID_FILE} 1>/dev/null 2>/dev/null
}


#######################################
# Configure & start WiFi station mode
#######################################
start_wifi_station()
{
# M39G_MV_2-2130
	log "********** start_wifi_station $1 $2"
# M39G_MV_2-760
	${LWCONFIG_APP} ${LWCONFIG_APP_STATUS_DB} write mlan_routing_active 0

	IP_FORW_ENABLE=`cat /proc/sys/net/ipv4/ip_forward`
	if [ "$IP_FORW_ENABLE" == "0" ] ; then
		echo "ip_forward -> 1" >> /dev/kmsg
		${ECHO_APP} 1 > /proc/sys/net/ipv4/ip_forward
	fi
# no need to return a value; the return value is not handled
	[ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] || return;

# M39G_MV_2-1846
	DEFAULT_COUNTRY=`${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} read wibear_uap0_country`
	COUNTRY=${DEFAULT_COUNTRY}
	
	[ "$COUNTRY" == "EU" ] && COUNTRY="DE"	# any from ETSI
	${MLANUTL} countrycode $COUNTRY # from uAP settings (tbc.)
	if [ "$BAND" == "2.4" ] ; then
		${MLANUTL} bandcfg 11       # 2.4GHz only (BGN)
	else
		${MLANUTL} bandcfg 20       # 2.4GHz only (AN)
	fi
	${MLANUTL} htcapinfo 0x5820000  # 20/40MHz, short GI
	${MLANUTL} httxcfg 0x62         # 20/40MHz, short GI

# M39G_MV_2-760
	SSID=$(${LWCONFIG_APP} read wibear_mlan0_ssid)
	SECURITY_MODE=$(${LWCONFIG_APP} read wibear_mlan0_security_mode)
# M39G_MV_2-2130
	if [ "$2" != "" ] ; then
		SECURITY_MODE=$2
	fi

#M39G_MV_2-2815 the support to ieee80211w is now enabled in the driver
# to use it add ieee80211w=1 in the WPA_SUPPLICANT_CONF file


	cat >${WPA_SUPPLICANT_CONF} <<EOF
ctrl_interface=/var/run/wpa_supplicant
ap_scan=1
network={
	scan_ssid=1
	ieee80211w=1
	ssid="$SSID"
EOF

# M39G_MV_2-2251
#	if [ "$SECURITY_MODE" == "WPA_PSK" ] || [ "$SECURITY_MODE" == "WPA" ] ; then
	if [ "$SECURITY_MODE" == "WPA_PSK" ] || [ "$SECURITY_MODE" == "WPA" ] 
	 || [ "$SECURITY_MODE" == "WEP_HEX1" ] || [ "$SECURITY_MODE" == "WEP_ASCII1" ] 
	 || [ "$SECURITY_MODE" == "WEP_HEX2" ] || [ "$SECURITY_MODE" == "WEP_ASCII2" ] 
	 || [ "$SECURITY_MODE" == "WEP_HEX3" ] || [ "$SECURITY_MODE" == "WEP_ASCII3" ] 
	 || [ "$SECURITY_MODE" == "WEP_HEX4" ] || [ "$SECURITY_MODE" == "WEP_ASCII4" ]
	 || [ "$SECURITY_MODE" == "WEP_HEX1_SH" ] || [ "$SECURITY_MODE" == "WEP_ASCII1_SH" ] 
	 || [ "$SECURITY_MODE" == "WEP_HEX2_SH" ] || [ "$SECURITY_MODE" == "WEP_ASCII2_SH" ] 
	 || [ "$SECURITY_MODE" == "WEP_HEX3_SH" ] || [ "$SECURITY_MODE" == "WEP_ASCII3_SH" ] 
	 || [ "$SECURITY_MODE" == "WEP_HEX4_SH" ] || [ "$SECURITY_MODE" == "WEP_ASCII4_SH" ] ; then
# M39G_MV_2-760
		SECURITY_KEY=$(${LWCONFIG_APP} read wibear_mlan0_security_key)
# M39G_MV_2-2130
		if [ "$1" != "" ] ; then
			SECURITY_KEY=$1
		fi
# M39G_MV_2-2251
	fi

# M39G_MV_2-2130
	if [ "$SECURITY_MODE" == "WPA_PSK" ] || [ "$SECURITY_MODE" == "WPA" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
	key_mgmt=WPA-PSK
	psk="$SECURITY_KEY"
}
EOF

# M39G_MV_2-2251
	elif [ "$SECURITY_MODE" == "WEP_HEX1" ] || [ "$SECURITY_MODE" == "WEP_HEX1_SH" ] ; then
# wep_key0..3: Static WEP key (ASCII in double quotation, e.g. "abcde" or
# hex without quotation, e.g., 0102030405)
# wep_tx_keyidx: Default WEP key index (TX) (0..3)
		cat >>/tmp/wpa_supplicant.conf <<EOF
		key_mgmt=NONE
		wep_key0=$SECURITY_KEY
		priority=5
EOF

		if [ "$SECURITY_MODE" == "WEP_HEX1_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		auth_alg=SHARED
EOF

		fi
		cat >>/tmp/wpa_supplicant.conf <<EOF
		wep_tx_keyidx=0
	}
EOF

	elif [ "$SECURITY_MODE" == "WEP_ASCII1" ] || [ "$SECURITY_MODE" == "WEP_ASCII1_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		key_mgmt=NONE
		wep_key0="$SECURITY_KEY"
		priority=5
EOF

		if [ "$SECURITY_MODE" == "WEP_ASCII1_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		auth_alg=SHARED
EOF

		fi
		cat >>/tmp/wpa_supplicant.conf <<EOF
		wep_tx_keyidx=0
	}
EOF

	elif [ "$SECURITY_MODE" == "WEP_HEX2" ] || [ "$SECURITY_MODE" == "WEP_HEX2_SH" ] ; then
# wep_key0..3: Static WEP key (ASCII in double quotation, e.g. "abcde" or
# hex without quotation, e.g., 0102030405)
# wep_tx_keyidx: Default WEP key index (TX) (0..3)
		cat >>/tmp/wpa_supplicant.conf <<EOF
		key_mgmt=NONE
		wep_key1=$SECURITY_KEY
		priority=5
EOF

		if [ "$SECURITY_MODE" == "WEP_HEX2_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		auth_alg=SHARED
EOF

		fi
		cat >>/tmp/wpa_supplicant.conf <<EOF
		wep_tx_keyidx=1
	}
EOF

	elif [ "$SECURITY_MODE" == "WEP_ASCII2" ] || [ "$SECURITY_MODE" == "WEP_ASCII2_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		key_mgmt=NONE
		wep_key1="$SECURITY_KEY"
		priority=5
EOF

		if [ "$SECURITY_MODE" == "WEP_ASCII2_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		auth_alg=SHARED
EOF

		fi
		cat >>/tmp/wpa_supplicant.conf <<EOF
		wep_tx_keyidx=1
	}
EOF

	elif [ "$SECURITY_MODE" == "WEP_HEX3" ] || [ "$SECURITY_MODE" == "WEP_HEX3_SH" ] ; then
# wep_key0..3: Static WEP key (ASCII in double quotation, e.g. "abcde" or
# hex without quotation, e.g., 0102030405)
# wep_tx_keyidx: Default WEP key index (TX) (0..3)
		cat >>/tmp/wpa_supplicant.conf <<EOF
		key_mgmt=NONE
		wep_key2=$SECURITY_KEY
		priority=5
EOF

		if [ "$SECURITY_MODE" == "WEP_HEX3_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		auth_alg=SHARED
EOF

		fi
		cat >>/tmp/wpa_supplicant.conf <<EOF
		wep_tx_keyidx=2
	}
EOF

	elif [ "$SECURITY_MODE" == "WEP_ASCII3" ] || [ "$SECURITY_MODE" == "WEP_ASCII3_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		key_mgmt=NONE
		wep_key2="$SECURITY_KEY"
		priority=5
EOF

		if [ "$SECURITY_MODE" == "WEP_ASCII3_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		auth_alg=SHARED
EOF

		fi
		cat >>/tmp/wpa_supplicant.conf <<EOF
		wep_tx_keyidx=2
	}
EOF

	elif [ "$SECURITY_MODE" == "WEP_HEX4" ] || [ "$SECURITY_MODE" == "WEP_HEX4_SH" ] ; then
# wep_key0..3: Static WEP key (ASCII in double quotation, e.g. "abcde" or
# hex without quotation, e.g., 0102030405)
# wep_tx_keyidx: Default WEP key index (TX) (0..3)
		cat >>/tmp/wpa_supplicant.conf <<EOF
		key_mgmt=NONE
		wep_key3=$SECURITY_KEY
		priority=5
EOF

		if [ "$SECURITY_MODE" == "WEP_HEX4_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		auth_alg=SHARED
EOF

		fi
		cat >>/tmp/wpa_supplicant.conf <<EOF
		wep_tx_keyidx=3
	}
EOF

	elif [ "$SECURITY_MODE" == "WEP_ASCII4" ] || [ "$SECURITY_MODE" == "WEP_ASCII4_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		key_mgmt=NONE
		wep_key3="$SECURITY_KEY"
		priority=5
EOF

		if [ "$SECURITY_MODE" == "WEP_ASCII4_SH" ] ; then
		cat >>/tmp/wpa_supplicant.conf <<EOF
		auth_alg=SHARED
EOF

		fi
		cat >>/tmp/wpa_supplicant.conf <<EOF
		wep_tx_keyidx=3
	}
EOF

	else  # OPEN
		cat >>/tmp/wpa_supplicant.conf <<EOF
	key_mgmt=NONE
}
EOF

	fi

	mkdir -p /data/misc/wifi/sockets

# M39G_MV_2-1845
	if [ ! -d "/var/run" ] ; then 
		mkdir /var/run;
	fi

	wpa_supplicant -i mlan0 -D wext -c ${WPA_SUPPLICANT_CONF} -B
	log "wpa_supplicant[$(pgrep wpa_supplicant)] started."

	# start wpa_cli daemon to get CONNECTED/DISCONNECTED events
	wpa_cli -i mlan0 -p /var/run/wpa_supplicant -a /system/marvell/tel/mlan_action.sh -B

	# M39G_MV_2-2815 due to a not alligned IOCTL between the sd8787 driver and wpa_supplicant 2.5
	# we should add the following command to pass the driver the corrent SSID
	${MLANUTL} setuserscan ssid="${SSID}"

	iptables -t nat -A POSTROUTING -o mlan0 -j MASQUERADE

# M39G_MV_2-1846 #M39G_MV_2-2058 U_M39G_MV-2332
	${MLANUTL} hostcmd ${TXPOWER_LIMIT_FILE} txpwrlimit_2g_cfg_set
	ifconfig mlan0 up 2>/dev/null
}

#######################################
# Stop WiFi station
#######################################
# M39G_MV_2-1996
stop_wifi_station()
{
	killall wpa_supplicant 2>/dev/null
	if [ -e /var/run/udhcpc-mlan0.pid ] ; then
		kill $(cat /var/run/udhcpc-mlan0.pid) 2>/dev/null
	fi
	iptables -t nat -D POSTROUTING -o mlan0 -j MASQUERADE
# M39G_MV_2-1846
	sleep 1
	ifconfig mlan0 down
}

#######################################
# Turn 8787 radio off
#######################################
radio8787_off()
{
	${UAPUTL} bss_stop
	wpa_cli -i mlan0 -p /var/run/wpa_supplicant disconnect
	${UAPUTL} radioctrl 0
}

#######################################
# Turn 8787 radio on
#######################################
radio8787_on()
{
	${UAPUTL} radioctrl 1
# U_M39G_MV-2243
	${UAPUTL} sys_cfg_max_sta_num ${MAX_STA_CLIENT}
# U_M39G_MV-2332
	${UAPUTL} hostcmd ${TXPOWER_LIMIT_FILE} txpwrlimit_2g_cfg_set
	${MLANUTL} hostcmd ${TXPOWER_LIMIT_FILE} txpwrlimit_2g_cfg_set

	${UAPUTL} bss_start
	wpa_cli -i mlan0 -p /var/run/wpa_supplicant reconnect
}

#*** u-blox modifications *** TOBY_L200_50S-153
#######################################
# Return current Wifi power mode from default db
#######################################
get_wifi_factory_pwr_mode()
{
# M39G_MV_2-760
	${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} read wibear_power_mode
}

#*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-162
#######################################
# Return current Wifi power mode
#######################################
get_wifi_pwr_mode()
{
#	lwconfig --db=status read wibear_power_mode
# M39G_MV_2-760
	TOBY_RUN_MODE=`${GETPROP_APP} ro.cmdline.PROD`
	if [ "$TOBY_RUN_MODE" != "1" ] ; then
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} read wibear_power_mode
	else
		${LWCONFIG_APP} ${LWCONFIG_APP_STATUS_DB} read wibear_power_mode
	fi
}

#*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-161
# moved to 8787_common.cfg file
#*** original lesswire source code ***
#######################################
# Set current Wifi power mode
#######################################
#set_wifi_pwr_mode()
#{
#	lwconfig --db=status write wibear_power_mode "$1"
#}

#######################################
# Additional stuff (for debugging)
#######################################
init_other()
{
	dmesg -n1
	#~ telnetd -l /system/xbin/ash
	#~ iperf -s -D
	#~ mount -o remount,rw /system
}

#*** u-blox modifications *** TOBY_L200_50S-127
#######################################
# Return current Wifi WebUI status from default db
#######################################
get_wifi_factory_webui_status()
{
# M39G_MV_2-760
	${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} read wibear_webui_status
}

#*** u-blox modifications *** TOBY_L200_50S-127
#######################################
# Return current Wifi WebUI status
#######################################
get_wifi_webui_status()
{
# M39G_MV_2-760
	TOBY_RUN_MODE=`${GETPROP_APP} ro.cmdline.PROD`
	if [ "$TOBY_RUN_MODE" != "1" ] ; then
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} read wibear_webui_status
	else
		${LWCONFIG_APP} ${LWCONFIG_APP_STATUS_DB} read wibear_webui_status
	fi
}

#*** u-blox modifications *** TOBY_L200_50S-127
#######################################
# Set current Wifi WebUI status
#######################################
set_wifi_webui_status()
{
# M39G_MV_2-760
	TOBY_RUN_MODE=`${GETPROP_APP} ro.cmdline.PROD`
	if [ "$TOBY_RUN_MODE" != "1" ] ; then
		${LWCONFIG_APP} ${LWCONFIG_APP_USER_DB} write wibear_webui_status "$1"
	else
		${LWCONFIG_APP} ${LWCONFIG_APP_STATUS_DB} write wibear_webui_status "$1"
	fi
}

#######################################
# Main starts here...
#######################################

get_80211_mode
PWRMODE=$(get_wifi_pwr_mode)
#*** u-blox modifications *** TOBY_L200_50S-127
WEBUI_STATUS=$(get_wifi_webui_status)

# M39G_MV_2-760
DEFAULT_COUNTRY=`${LWCONFIG_APP} ${LWCONFIG_APP_DEFAULT_DB} read wibear_uap0_country`

# TOBY_L200_50S-202 M39G_MV_2-380
log "WiFi: $*"

# M39G_MV_2-1845
if [ ! -d "/var/run" ] ; then ${MKDIR_APP} /var/run; fi

if [ "$SYSTEM_CONFIG_HOST" == "3" ] && [ "$IP_TERMINATION_AUX" == "4" ] ; then
	log "BRIDGE mode = 1"
	BRIDGE_MODE="1";
fi

# M39G_MV_2-2130
BLOCK_AP=$(prevent_starting_ap $2 $3)
BLOCK_STA=$(prevent_starting_sta $4 $5)

log "B_AP" $BLOCK_AP
log "B_STA" $BLOCK_STA

case "$1" in
	init)           # startup initialization
# M39G_MV_2-2130 REWORK OF THE INIT
#*************** OLD INIT *******************************
##*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-139 TOBY_L200_50S-49
##		if [ -n "$PWRMODE" ]; then
##			echo "Invalid power mode: $PWRMODE" >&2
##			exit 1
##		fi
##		load_8787_driver || exit 1
##		load_8787_driver || ( start_ip_usb0_only_services &&  exit 1 )
##
##		start_wifi_ap
##		start_ip_services
##		start_modemMan
##		start_wifi_station
##		set_wifi_pwr_mode "ON"
##		init_other
#		if [ "$PWRMODE" == "" ] || [ "$PWRMODE" == "TEST" ] ; then
#			PWRMODE=$(get_wifi_factory_pwr_mode)
#		fi
##*** u-blox modifications *** TOBY_L200_50S-127
#		if [ "WEBUI_STATUS" == "" ]; then
#			WEBUI_STATUS=$(get_wifi_factory_webui_status)
#		fi
#
#		set_country
#		echo 0 >${RFKILL}
## M39G_MV_2-758 M39G_MV_2-1131
#		if [ "$(${LWCONFIG_APP} read modemMan_enable)" == "1" ]; then
#			sleep 1
#			start_modemMan
#			log "modemMan[$(pgrep modemMan)] started."
#		else
#			log "modemMan disabled."
#		fi
#		if [ "$PWRMODE" == "OFF" ]; then
#			stop_ip_services
#			start_ip_usb0_only_services
## M39G_MV_2-1846
#			if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
#				load_8787_driver;
#				ifconfig uap0 down;
#				start_wifi_station;
#			fi
#			set_wifi_pwr_mode "OFF"
#			init_other
#		elif [ "$PWRMODE" == "ON" ]; then
#			load_8787_driver
#			stop_ip_services
## M39G_MV_2-1845
##			start_ip_services || start_ip_usb0_only_services
#			start_ip_services || start_ip_usb0_only_services || start_ip_uap0_only_services
#			start_wifi_ap
#			start_wifi_station
## M39G_MV_2-760
#			start_wifiMan
## M39G_MV_2-758 M39G_MV_2-1131
##			start_modemMan
##			if [ "$(${LWCONFIG_APP} read modemMan_enable)" == "1" ]; then
##				sleep 1
##				start_modemMan
##				log "modemMan[$(pgrep modemMan)] started."
##			else
##				log "modemMan disabled."
##			fi
#			set_wifi_pwr_mode "ON"
#			init_other
#		elif [ "$PWRMODE" == "FLIGHT" ]; then
#			load_8787_driver
#			stop_ip_services
## M39G_MV_2-1845
##			start_ip_services || start_ip_usb0_only_services
#			start_ip_services || start_ip_usb0_only_services || start_ip_uap0_only_services
#			start_wifi_ap
#			start_wifi_station
## M39G_MV_2-760
#			start_wifiMan
#			start_modemMan
#			radio8787_off
#			init_other
#		else
#			echo "Invalid power mode: $PWRMODE" >&2
#			exit 1
#		fi
##*** u-blox modifications *** TOBY_L200_50S-127
#		if [ "$WEBUI_STATUS" == "ON" ]; then
## M39G_MV_2-760
#			start_wifiMan
#			start_wifi_webui_service
#			set_wifi_webui_status "ON"
#		else
## M39G_MV_2-760
#			if [ "$PWRMODE" != "" ] && [ "$PWRMODE" != "ON" ] && [ "$PWRMODE" != "FLIGHT" ] ; then
#				stop_wifiMan
#			fi
#			set_wifi_webui_status "OFF"
#		fi
## TOBY_L200_50S-202 M39G_MV_2-380 M39G_MV_2-760
#		WEBUI_FTP_STATUS=$(${LWCONFIG_APP} read wui_access_enable)
#		if [ "$WEBUI_FTP_STATUS" == "1" ]; then
#			start_wifi_webui_ftp
#		fi
#		;;
#
##*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-139
#*************** NEW INIT *******************************
# REWORK includes TOBY_L200_50S-153 TOBY_L200_50S-139 TOBY_L200_50S-49
# M39G_MV_2-2058 M39G_MV_2-1845 M39G_MV_2-760 M39G_MV_2-758 M39G_MV_2-1131 M39G_MV_2-2141

#*************** DEFAULT VALUES
		if [ "$PWRMODE" == "" ] || [ "$PWRMODE" == "TEST" ] ; then
			PWRMODE=$(get_wifi_factory_pwr_mode)
		fi
		if [ "WEBUI_STATUS" == "" ] ; then
			WEBUI_STATUS=$(get_wifi_factory_webui_status)
		fi

#*************** MODEM MAN
		if [ "$(${LWCONFIG_APP} read modemMan_enable)" == "1" ] ; then
			sleep 1
			start_modemMan
			log "modemMan[$(pgrep modemMan)] started."
		else
			log "modemMan disabled."
		fi

		set_country
		echo 0 >${RFKILL}
		if [ "$PWRMODE" == "OFF" ] ; then

#AP
			stop_ip_services
			start_ip_usb0_only_services
			set_wifi_pwr_mode "OFF"
			init_other

#STA
			if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
				if [ "$BLOCK_STA" == "0" ] ; then
					load_8787_driver
					sleep 1
					start_wifi_station "" "";
					sleep 3
					start_wifiMan;
				else
					# STA is blocked, disable it
					${LWCONFIG_APP} write wibear_mlan0_enable "0"
				fi
			fi

		elif [ "$PWRMODE" == "ON" ] ; then

#COMMON
			if [ "$BLOCK_AP" == "0" ] ; then
				load_8787_driver
			fi

			stop_ip_services
			start_ip_services || start_ip_usb0_only_services || start_ip_uap0_only_services
#AP
			if [ "$BLOCK_AP" == "0" ] ; then
				start_wifi_ap "" ""
				set_wifi_pwr_mode "ON"
			else
				set_wifi_pwr_mode "OFF"
			fi
#STA
			if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
				if [ "$BLOCK_STA" == "0" ] ; then
					if [ "$BLOCK_AP" == "1" ] ; then
						load_8787_driver
					fi
					start_wifi_station "" "";
				else
					# STA is blocked, disable it
					${LWCONFIG_APP} write wibear_mlan0_enable "0"
				fi
			fi
#COMMON
			if [ "$BLOCK_AP" == "0" ] || [ "$BLOCK_STA" == "0" ] ; then
				start_wifiMan
				init_other
			fi


		elif [ "$PWRMODE" == "FLIGHT" ] ; then
#COMMON
			if [ "$BLOCK_AP" == "0" ] ; then
				load_8787_driver
			fi
			stop_ip_services
			start_ip_services || start_ip_usb0_only_services || start_ip_uap0_only_services
			if [ "$BLOCK_AP" == "0" ] ; then 
				log "AP not blocked:  start it"
				start_wifi_ap "" ""
			fi

			if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
				if [ "$BLOCK_STA" == "0" ] ; then
					if [ "$BLOCK_AP" == "1" ] ; then
						load_8787_driver
					fi
					start_wifi_station "" "";
				else
					# STA is blocked, disable it
					${LWCONFIG_APP} write wibear_mlan0_enable "0"
				fi
			fi

			if [ "$BLOCK_AP" == "0" ] ; then
				log "AP not blocked:  radio off and start wifiman"
				set_wifi_pwr_mode "FLIGHT"
				radio8787_off
				start_wifiMan
			elif [ "$BLOCK_STA" == "0" ] && [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
				log "AP blocked,  STA not bl:  radio off and start wifiman"
				radio8787_off
				start_wifiMan
			fi
			if [ "$BLOCK_AP" == "1" ] & [ "$BLOCK_STA" == "1" ] ; then
				log "AP and STA blocked, power off"
				set_wifi_pwr_mode "OFF"
			fi
			init_other
		else
			echo "Invalid power mode: $PWRMODE" >&2
			exit 1
		fi


#*************** WEBUI ACCESS
		if [ "$WEBUI_STATUS" == "ON" ] ; then
			start_wifiMan
			start_wifi_webui_service
			set_wifi_webui_status "ON"
		else
			if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" != "1" ] && [ "$PWRMODE" != "" ] && [ "$PWRMODE" != "ON" ] && [ "$PWRMODE" != "FLIGHT" ] ; then
				stop_wifiMan
			fi
			set_wifi_webui_status "OFF"
		fi

#*************** WEBUI FTP ACCESS
		WEBUI_FTP_STATUS=$(${LWCONFIG_APP} read wui_access_enable)
		if [ "$WEBUI_FTP_STATUS" == "1" ] ; then
			start_wifi_webui_ftp
		fi
		;;
#*************** END INIT *******************************
	init_bsp_only)           # startup initialization
		PWRMODE=$(get_wifi_factory_pwr_mode)
#*** u-blox modifications *** TOBY_L200_50S-127
		WEBUI_STATUS=$(get_wifi_factory_webui_status)
		set_wifi_webui_status "OFF"
		unload_8787_driver 2>/dev/null
		log "WiFi: init_bsp_only begin ..."
		init_other
		if [ [ "$PWRMODE" != "OFF"] && [ "$PWRMODE" != "ON"] && [ "$PWRMODE" != "FLIGHT"] ] ; then
			echo "Invalid power mode: $PWRMODE" >&2
			exit 1
		fi
		log "WiFi: start_ip_usb ..."
		# for the wifi the factory-programmed value is OFF
		# only USB is available
		# write to status db (volatile)
# M392_MG_2-760
		set_country
		set_wifi_pwr_mode "OFF"
		start_ip_usb0_only_services
		;;
	wifioff)        # turn WiFi completely off
#*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-139
		if [ "$PWRMODE" == "ON" ] || [ "$PWRMODE" == "FLIGHT" ] || [ "$PWRMODE" == "TEST" ] ; then
# M39G_MV_2-1846
			if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
				# STA enabled
# M39G_MV_2-2058
				radio8787_on
				stop_wifi_ap 2>/dev/null
				ifconfig uap0 down 2>/dev/null
				set_wifi_pwr_mode "OFF"
# M39G_MV_2-2058
#				if [ "$WEBUI_STATUS" == "OFF" ]; then
#					stop_wifiMan
#				fi
				stop_ip_services 2>/dev/null
				start_ip_usb0_only_services 2>/dev/null
			else
				# STA disabled
		stop_wifi_ap 2>/dev/null
		stop_wifi_station 2>/dev/null
		unload_8787_driver 2>/dev/null
		set_wifi_pwr_mode "OFF"
# M392_MG_2-760
			if [ "$WEBUI_STATUS" == "OFF" ] ; then
				stop_wifiMan
			fi
#*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-139
			stop_ip_services
# M39G_MV_2-1845
#			start_ip_services || start_ip_usb0_only_services
			start_ip_services || start_ip_usb0_only_services || start_ip_uap0_only_services
# M39G_MV_2-1846
			fi

# M39G_MV_2-758 M39G_MV_2-1131
		elif [ "$PWRMODE" == "OFF" ] ; then
			exit 0
		else
			echo "Invalid power mode: $PWRMODE" >&2
			exit 1
		fi
		;;

	radiooff)       # turn radio off (airplane/flight mode)
		if [ "$PWRMODE" == "ON" ]; then
			radio8787_off
			set_wifi_pwr_mode "FLIGHT"
#*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-139 TOBY_L200_50S-161
		elif [ "$PWRMODE" == "OFF" ] || [ "$PWRMODE" == "TEST" ] ; then
			if [ "$PWRMODE" == "TEST" ]; then
				unload_8787_driver 2>/dev/null
			fi
			load_8787_driver
			stop_ip_services
# M39G_MV_2-1845
#			start_ip_services || start_ip_usb0_only_services
			start_ip_services || start_ip_usb0_only_services || start_ip_uap0_only_services
# M39G_MV_2-2130
			start_wifi_ap "$2" "$3"
			if [ "$2" != "" ] && [ "$3" != "" ] ; then
				log "volatile AP"
			else
				log "volatile not AP"
			fi
			
# M39G_MV_2-2058
#			start_wifi_station
			radio8787_off
# M39G_MV_2-2058
			if [ "$(${LWCONFIG_APP} read modemMan_enable)" == "1" ]; then
			start_modemMan
# M39G_MV_2-2058
			fi
			set_wifi_pwr_mode "FLIGHT"
# M39G_MV_2-758 M39G_MV_2-1131
		elif [ "$PWRMODE" == "FLIGHT" ]; then
			exit 0
		else
			echo "Invalid power mode: $PWRMODE" >&2
			exit 1
		fi
		;;

	wifion)         # turn WiFi on
# M39G_MV_2-2130 REWORK OF THE WIFION
#*************** OLD WIFION *******************************
#		if [ "$PWRMODE" == "OFF" ] || [ "$PWRMODE" == "TEST" ] ; then
## M39G_MV_2-1846
#		log "WIFION OFF and TEST"
#			if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
#				log "WIFION - MLAN 1"
#				stop_ip_services
#				if [ "$PWRMODE" == "TEST" ]; then
#					unload_8787_driver 2>/dev/null
#				fi
#				load_8787_driver
#				start_wifi_ap
#				start_ip_services || start_ip_uap0_only_services
#				start_wifi_station
#				start_wifiMan
#			else
#				log "WIFION - MLAN 0"
##*** u-blox modifications *** TOBY_L200_50S-153 TOBY_L200_50S-139 TOBY_L200_50S-161
#			stop_ip_services
#			if [ "$PWRMODE" == "TEST" ]; then
#				unload_8787_driver 2>/dev/null
#			fi
##			load_8787_driver || exit 1
#			load_8787_driver || ( start_ip_usb0_only_services &&  exit 1 )
#			start_wifi_ap
## M39G_MV_2-1845
#			start_ip_services || start_ip_uap0_only_services
#			start_wifi_station
## M39G_MV_2-760
#			start_wifiMan
#
## M39G_MV_2-1846
#			fi
#
#		elif [ "$PWRMODE" == "FLIGHT" ]; then
## M39G_MV_2-1846
#			log "WIFION FLIGHT"
#			radio8787_on
## M39G_MV_2-758 M39G_MV_2-1131
#		elif [ "$PWRMODE" == "ON" ]; then
## M39G_MV_2-1846
#			log "WIFION ON"
#			exit 0
#		else
## M39G_MV_2-1846
#			log "WIFION INVALID"
#			echo "Invalid power mode: $PWRMODE" >&2
#			exit 1
#		fi
#		set_wifi_pwr_mode "ON"
#		;;
#*************** NEW WIFION *******************************
# REWORK includes TOBY_L200_50S-153 TOBY_L200_50S-139 TOBY_L200_50S-161
# M39G_MV_2-2058 M39G_MV_2-1846 M39G_MV_2-1845 M39G_MV_2-760 M39G_MV_2-758 M39G_MV_2-2141
		if [ "$PWRMODE" == "OFF" ] || [ "$PWRMODE" == "TEST" ] ; then
			log "WIFION OFF and TEST"
			log "WIFION - MLAN 0"
			stop_ip_services
			if [ "$PWRMODE" == "TEST" ] ; then
				unload_8787_driver 2>/dev/null
			fi

			if [ "$BLOCK_AP" == "0" ] ; then 
				load_8787_driver || ( start_ip_usb0_only_services &&  exit 1 )
				# $2 password, $3 auth_suite
				start_wifi_ap "$2" "$3"
				start_ip_services || start_ip_uap0_only_services
				start_wifiMan
			fi

		elif [ "$PWRMODE" == "FLIGHT" ] ; then
			log "WIFION FLIGHT"
			
			if [ "$BLOCK_AP" == "0" ] ; then 
				log "Volatile mode not enabled, start with default values"
				stop_wifi_ap 2>/dev/null
				stop_ip_services
				start_wifi_ap "$2" "$3"
				start_ip_services || start_ip_uap0_only_services
				set_wifi_pwr_mode "ON"
				radio8787_on
			fi
		elif [ "$PWRMODE" == "ON" ] ; then
			log "WIFION already ON"
			exit 0
		else
			log "WIFION INVALID"
			echo "Invalid power mode: $PWRMODE" >&2
			exit 1
		fi
		;;

#*************** END WIFION *******************************
# M39G_MV_2-1846
	wifistaon)         # turn STA WiFi on
# M39G_MV_2-2130 REWORK OF THE WIFISTAON
#*************** OLD WIFISTAON *******************************
#		${LWCONFIG_APP} write wibear_mlan0_enable "1"
#		if [ "$PWRMODE" == "OFF" ] || [ "$PWRMODE" == "TEST" ] ; then
#			if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
#				stop_ip_services
#				if [ "$PWRMODE" == "TEST" ]; then
#					unload_8787_driver 2>/dev/null
#				fi
#				load_8787_driver
#				start_ip_usb0_only_services
#				ifconfig uap0 down
#				start_wifi_station
#			fi
#		elif [ "$PWRMODE" == "FLIGHT" ]; then
#			log "from FLIGHT to enable STA on"
#			start_wifi_station
#
#		elif [ "$PWRMODE" == "ON" ]; then
##			stop_ip_services
##			ifconfig uap0 down
##			start_ip_usb0_only_services
#			start_wifi_station
#		else
#			echo "Invalid power mode: $PWRMODE" >&2
#			exit 1
#		fi
## M39G_MV_2-1996
#		start_wifiMan
#		;;
#*************** NEW WIFISTAON *******************************
# REWORK includes M39G_MV_2-2130 1996
		if [ "$BLOCK_STA" == "0" ] ; then 
			${LWCONFIG_APP} write wibear_mlan0_enable "1"
			if [ "$PWRMODE" == "OFF" ] || [ "$PWRMODE" == "TEST" ] ; then
				if [ "$(${LWCONFIG_APP} read wibear_mlan0_enable)" == "1" ] ; then
					stop_ip_services
					if [ "$PWRMODE" == "TEST" ] ; then
						unload_8787_driver 2>/dev/null
					fi
					load_8787_driver
					start_ip_usb0_only_services
					ifconfig uap0 down 2>/dev/null
					start_wifi_station "$4" "$5"
				fi
			elif [ "$PWRMODE" == "FLIGHT" ] ; then
				log "from FLIGHT to enable STA on"
				start_wifi_station "$4" "$5"
	
			elif [ "$PWRMODE" == "ON" ] ; then
				start_wifi_station "$4" "$5"
			else
				echo "Invalid power mode: $PWRMODE" >&2
				exit 1
			fi
			start_wifiMan
		fi
		;;
#*************** END WIFISTAON *******************************
	wifistaoff)         # turn STA WiFi off
# M39G_MV_2-2130
# no need to check the block, disable STA also without pass/auth_suite
		if [ "$PWRMODE" == "OFF" ] || [ "$PWRMODE" == "TEST" ] ; then
# M39G_MV_2-1996
			stop_ip_services 2>/dev/null
			stop_wifi_station 2>/dev/null
			unload_8787_driver 2>/dev/null
			start_ip_usb0_only_services
		elif [ "$PWRMODE" == "FLIGHT" ] ; then
			log "from FLIGHT to enable STA off"
			stop_wifi_station

		elif [ "$PWRMODE" == "ON" ] ; then
			log "from ON to enable STA off"
# M39G_MV_2-1996
			stop_wifi_station 2>/dev/null
			log "from ON to enable STA off exit"
		else
			echo "Invalid power mode: $PWRMODE" >&2
			exit 1
		fi

# M39G_MV_2-1996 M39G_MV_2-2130
#		if [ "$PWRMODE" == "ON" ] || [ "$PWRMODE" == "FLIGHT" ] || [ "$PWRMODE" == "TEST" ] || [ "$WEBUI_STATUS" == "OFF" ]; then
		if [ "$PWRMODE" == "TEST" ] || [ "$PWRMODE" == "OFF" ] && [ "$WEBUI_STATUS" == "OFF" ] ; then
			stop_wifiMan  2>&1 /dev/null
		fi
		${LWCONFIG_APP} write wibear_mlan0_enable "0"
		;;

	routingstaon)         # set the routing and DNS to the STA
# the value is stored in the database before executing the mlan_action.sh script
# there is no sense to return error if the mlan0 is not enabled
		/system/marvell/tel/mlan_routing.sh CONNECTED
		;;

	routingstaoff)         # set the routing and DNS to the default (cellular)
# the value is stored in the database before executing the mlan_action.sh script
# there is no sense to return error if the mlan0 is not enabled
		/system/marvell/tel/mlan_routing.sh DISCONNECTED
		;;

	restartap)      # restart WiFi AP
		if [ "$PWRMODE" != "ON" ] ; then
			echo "Invalid power mode: $PWRMODE" >&2
			exit 1
		fi
		stop_ip_services
# M39G_MV_2-2130
		start_wifi_ap "$2" "$3"
		start_ip_services
		;;

	restartsta)     # restart WiFi station mode
# M39G_MV_2-1845
# the STA mode is indipendent from the AP mode
#		if [ "$PWRMODE" != "ON" ]; then
#			echo "Invalid power mode: $PWRMODE" >&2
#			exit 1
#		fi
# M39G_MV_2-2130
		if [ "$BLOCK_STA" == "0" ] ; then
		stop_wifi_station 2>/dev/null
		sleep 1
# M39G_MV_2-2130
		start_wifi_station "$4" "$5"
		fi
		;;

	startmm)        # start connection manager
		start_modemMan
		;;

	stopmm)         # stop connection manager
		stop_modemMan 2>/dev/null
		;;

#*** u-blox modifications *** TOBY_L200_50S-127
	get_webui_status)         # get the WebUI status
		get_wifi_webui_status
		;;

	set_webui_status)         # set the WebUI status
		if [ "$WEBUI_STATUS" == "ON" ] && [ "$2" == "OFF" ] ; then
			stop_wifi_webui_service
			echo "WebUI stopped" >&2
		elif [ "$WEBUI_STATUS" == "OFF" ] && [ "$2" == "ON" ] ; then
			start_wifi_webui_service
			echo "WebUI started" >&2
		elif [ "$WEBUI_STATUS" == "OFF" ] && [ "$2" == "OFF" ] ; then
			echo "Nothing to do" >&2
# M39G_MV_2-758 M39G_MV_2-1131
			exit 0
		elif [ "$WEBUI_STATUS" == "ON" ] && [ "$2" == "ON" ] ; then
			echo "Nothing to do" >&2
# M39G_MV_2-758 M39G_MV_2-1131
			exit 0
		else
			echo "Invalid WebUI status: $WEBUI_STATUS" >&2
			exit 1
		fi
		set_wifi_webui_status $2
		;;

# TOBY_L200_50S-202 M39G_MV_2-380
	set_webui_ftp_status)         # enable/disable WebUI FTP access
# M39G_MV_2-760
		WEBUI_FTP_STATUS=$(${LWCONFIG_APP} read wui_access_enable)
		if [ "$WEBUI_FTP_STATUS" == "1" ] && [ "$2" == "0" ] ; then
			stop_wifi_webui_ftp
		elif [ "$WEBUI_FTP_STATUS" == "0" ] && [ "$2" == "1" ] ; then
			start_wifi_webui_ftp
		else
			exit 1
		fi
# M39G_MV_2-760
		${LWCONFIG_APP} write wui_access_enable "$2"
		;;

	revert_webui)                 # revert web pages
		killall ftpd 2>/dev/null	# kill any open connections first
		install_wifi_webui
		;;

#M39G_MV_2-1124
	set_tx_conf_wifi_ap)
		set_transmission_conf_wifi_ap
		;;

	*)
		echo "Unknown cmd: '$1'" >&2
		exit 1
esac

exit 0
