#!/bin/sh
 ###########################################################
 #
 # Copyright (C) u-blox Italia
 #
 # u-blox Italia
 # Via Stazione di Prosecco 15
 # 34010 Sgonico - TRIESTE, ITALY
 #
 # All rights reserved.
 #
 # This source file is the sole property of
 # u-blox Italia. Reproduction or utilization of
 # this source in whole or part is forbidden
 # without the written consent of u-blox Italia.
 #
 ###########################################################
 #
 # Project: SE_P21
 # Purpose: Change hostless/host mode
 #
 ###########################################################
 #
 #  $Archive::                                             $
 #
 # $Workfile:: run_mode.sh                                 $
 #  $Modtime::                                             $
 # $Revision::                                             $
 #   $Author:: Fabio Piccolo                               $
 #      $Log:: 01.00 First version for Marvell platform    $
 #
 ###########################################################

USAGE="Usage: `basename $0` [-hv] [-m arg]"
VERS="01.00"
CmdLine="/proc/cmdline"
NVMLine="/NVM/cmdline"

#U_M39G_MV-89
#defined also in teldev.h
NVMIptables="/NVM/iptables_nvm.sh"
NVMIptablesDefault="/NVM/iptables_nvm_default.sh"

RNDIS0_IPADDR=`getprop persist.sys.ublx_rndis0_ipaddr`
RNDIS0_IPMASK=`getprop persist.sys.ublx_rndis0_ipmask`
RNDIS0_DHCPSTART=`getprop persist.sys.ublx_rndis0_dhcpst`
RNDIS0_DHCPSTOP=`getprop persist.sys.ublx_rndis0_dhcpsp`

if [ -z "$RNDIS0_IPADDR" ] || [ -z "$RNDIS0_IPMASK" ] || [ -z "$RNDIS0_DHCPSTART" ] || [ -z "$RNDIS0_DHCPSTOP" ]; then
	setprop persist.sys.ublx_rndis0_ipaddr 192.168.1.1
	setprop persist.sys.ublx_rndis0_ipmask 255.255.255.0
	setprop persist.sys.ublx_rndis0_dhcpst 192.168.1.100
	setprop persist.sys.ublx_rndis0_dhcpsp 192.168.1.100
fi

if [ ! -f $NVMLine ]; then
        echo "Create temporary command line" >> /dev/kmsg
        cat $CmdLine > $NVMLine
fi

#U_M39G_MV-89
if [ ! -f $NVMIptablesDefault ]; then
        echo "Create NVMIptablesDefault" >> /dev/kmsg
        echo "#!/bin/sh"  > $NVMIptablesDefault
        chmod 700 $NVMIptablesDefault
fi

if [ ! -f $NVMIptables ]; then
        echo "Create NVMIptables" >> /dev/kmsg
        echo "#!/bin/sh"  > $NVMIptables
        chmod 700 $NVMIptables
fi

if [ $# -eq 0 ]; then
    echo $USAGE
    exit 0
fi

while getopts hvm: OPT; do
    case "$OPT" in
        h)
            echo $USAGE
            exit 0
            ;;
        m)
            HM=$OPTARG
            if [ $HM -gt 2 -a $HM -lt 1 ]; then
                echo $USAGE >&2
                exit 1
            fi
            ;;
        v)
            echo "`basename $0` version $VERS"
            exit 0
            ;;
        \?)
            # getopts issues an error message
            echo $USAGE >&2
            exit 1
            ;;
    esac
done
if [ -z $HM  ]; then
        exit 0
fi
if [ $HM -eq 2 ]; then
        #Set Host configuration
        sed -i -e  's/SYCG=[0-9]/SYCG=3/g' -e 's/IPTM=[0-9]/IPTM=4/g' $NVMLine
        echo "`basename $0`: Changed mode to Host." >> /dev/kmsg
elif [ $HM -eq 1 ]; then
        #Set Hostless configuration
        sed -i -e  's/SYCG=[0-9]/SYCG=2/g' -e 's/IPTM=[0-9]/IPTM=5/g' $NVMLine
        echo "`basename $0`: Changed mode to Hostless." >> /dev/kmsg
else
        # Wrong parameter
        echo "`basename $0`: Error in parameter value." >> /dev/kmsg
fi


