#!/bin/sh

#add all kernel command line tokens to properties #U_M39G_MV-1627
awk '{for (i=1;i<=NF;i++){if ($i ~ /=/){gsub("="," ",$i);print "ro.cmdline."$i;}else{print "ro.cmdline."$i" 1";}}}' /NVM/cmdline | xargs -n 2 setprop

#create COMCfg.prop file, in csv format
getprop | sed -e "s/\]: \[/,/g" -e "s/\]$//g" -ne "s/\[ro.mrvl.comm.\|\[persist.mrvl.comm.//gp" > /tmp/COMCfg.prop

#create symlink to COMCfg.prop in /NVM
if [ ! -h /NVM/COMCfg.prop ]; then
	ln -s /tmp/COMCfg.prop /NVM/COMCfg.prop
fi

#create SymLink to APP files for COM in /NVM

#option 1 - from ro.mrvl.link2NVM property
LINK2NVM_PARAM=$(getprop ro.mrvl.link2NVM | awk -F"," '{for (i=1;i<=NF;i++){print $i}}')
#option 2 - from link2NVM file
LINK2NVM_PARAM="$LINK2NVM_PARAM $(cat /system/etc/link2NVM)"

for file in $(echo $LINK2NVM_PARAM)	; do
	if [ ! -e /NVM/"$file" -a ! -h /NVM/"$file" ]; then
		ln -s /system/etc/"$file" /NVM/"$file"
	fi
done

#option 3 - from rf_files_# plugin file
RF_PLUGIN_NUM=$(getprop ro.cmdline.RFPL)
RF_PLUGIN_FILE="/system/etc/rf_files_$RF_PLUGIN_NUM"

RF_PLUGIN_PARAM=$(cat "$RF_PLUGIN_FILE")

for files in $(echo $RF_PLUGIN_PARAM) ; do
	SRC=$(echo $files | awk -F"," '{print $1}')
	DST=$(echo $files | awk -F"," '{print $2}')

	if [ ! -e /NVM/"$SRC" -a ! -h /NVM/"$SRC" ]; then
		ln -s /system/etc/"$DST" /NVM/"$SRC"
	fi
done

#*** u-blox modification *** U_M39G_MV-474, U_M39G_MV-565, U_M39G_MV-2962
UBLOX_CHAR_FACTORY_INIT=`getprop persist.sys.ublx_chf_fct_init`
TOBY_HW_ID_L200=`grep "BOAR=d1" /proc/cmdline | wc -l`
TOBY_HW_ID_L210=`grep "BOAR=d2" /proc/cmdline | wc -l`
TOBY_HW_ID_L280=`grep "BOAR=d3" /proc/cmdline | wc -l`
TOBY_HW_ID_L201=`grep "BOAR=d4" /proc/cmdline | wc -l`

if [ "$TOBY_HW_ID_L200" == "1" ]; then
	TTYPE=L200
fi
if [ "$TOBY_HW_ID_L210" == "1" ]; then
	TTYPE=L210
fi
# U_M39G_MV-1454
if [ "$TOBY_HW_ID_L280" == "1" ]; then
	TTYPE=L280
fi
if [ "$TOBY_HW_ID_L201" == "1" ]; then
	TTYPE=L201
fi

#if property is not set then we need to copy the files
if [ -z "$UBLOX_CHAR_FACTORY_INIT" ] ; then
	cp /system/marvell/etc/"$TTYPE"_GsmCharData.nvm /NVM/GsmCharData.nvm
	cp /system/marvell/etc/"$TTYPE"_WbCharData.nvm /NVM/WbCharData.nvm
	cp /system/marvell/etc/"$TTYPE"_LteCharData.nvm /NVM/LteCharData.nvm

# U_M39G_MV-2591 overwrite JSC chardata files, if present
if dmesg | grep -q 'JSC 1G 128M 16-bit BCH'; then
	cp /system/marvell/etc/"$TTYPE"_JSC_LteCharData.nvm /NVM/LteCharData.nvm
	setprop persist.sys.ublx_nand_mnfct JSC
fi
        #set the flag so that on next reboot the file won't be copied
	setprop persist.sys.ublx_chf_fct_init 1
fi
#U_M39G_MV-474, U_M39G_MV-565

#U_M39G_MV-373
UBLX_MRD_MPCI_INIT =`getprop persist.sys.mrd.ublox.init`

if [ -z "$UBLX_MRD_MPCI_INIT" ] || ["$UBLX_MRD_MPCI_INIT" == "0"]; then
	/marvell/tel/ublx_mrd_read
	# the init flags is set in ublx_mrd_read
fi
#U_M39G_MV-373


## U_M39G_MV-275
export TOBY_MPCI=`getprop persist.sys.mrd.ublox.mpci`

#uncomment for debug
#export TOBY_MPCI="1"

#*** u-blox modification *** U_M39G_MV-1127
if [ "$TOBY_MPCI" == "1" ] || [ "$TOBY_MPCI" == "2" ]; then
	setprop ro.mrvl.rf_gpio.enable true
	setprop ro.mrvl.rf_gpio.polarity false
else
	setprop ro.mrvl.rf_gpio.enable false
	setprop ro.mrvl.rf_gpio.polarity false
fi
### U_M39G_MV-275

### u-blox modification U_M39G_MV-431, U_M39G_MV-449, U_M39G_MV-1489
UDCONF_66=`getprop persist.sys.ublx_udconf_66`
if [ -z "$UDCONF_66" ]; then

	#if TOBY_L210 or TOBY_L280 or TOBY_L201 U_M39G_MV-2547 U_M39G_MV-3002
	if [ "$TOBY_HW_ID_L210" == "1" ] || [ "$TOBY_HW_ID_L280" == "1" ] || [ "$TOBY_HW_ID_L201" == "1" ]; then
		setprop persist.sys.ublx_udconf_66 1
	else
		setprop persist.sys.ublx_udconf_66 0
	fi

fi
#U_M39G_MV-431, U_M39G_MV-449, U_M39G_MV-1489

#U_M39G_MV-329, U_M39G_MV-485
UBLOX_FACTORY_INIT=`getprop persist.sys.ublx_factory_init`

# if property is not there we need to enable MTIL server init
if [ -z "$UBLOX_FACTORY_INIT" ]; then
	setprop persist.sys.ublx_factory_init 1
fi

#U_M39G_MV-329, U_M39G_MV-485

#U_M39G_MV-1068
UBLOX_MTIL_UDP_ENABLE=`getprop persist.sys.ublx_mtil_udp`

#U_M39G_MV-1119 : if property is not there we need to disable MTIL server UDP socket
if [ -z "$UBLOX_MTIL_UDP_ENABLE" ]; then
	setprop persist.sys.ublx_mtil_udp 0
fi
#U_M39G_MV-1068

#U_M39G_MV-1114
UBLOX_FPATH_ENABLE=`getprop persist.sys.ublx_udconf_67`

# if property is not there we need to enable fpath load (factory value = enabled)
if [ -z "$UBLOX_FPATH_ENABLE" ]; then
	setprop persist.sys.ublx_udconf_67 1
fi
#U_M39G_MV-1114

#U_M39G_MV-139
UBLOX_UIMSENABLED=`getprop persist.sys.ublx_uimsenabled`

# if property is not there we need to disable IMS (factory value of CL1 is AT&T which is OFF)
if [ -z "$UBLOX_UIMSENABLED" ]; then
	setprop persist.sys.ublx_uimsenabled 0
fi
#U_M39G_MV-139

#U_M39G_MV-1459 U_M39G_MV-1687
UBLOX_UMNOCONF=`getprop persist.sys.ublx_umnoconf`

# if property is not there we need to configure for AT&T (factory value)
if [ -z "$UBLOX_UMNOCONF" ]; then
	setprop persist.sys.ublx_umnoconf 2
	setprop persist.sys.ublx_umnoconf_bm 7
	setprop persist.sys.ublx_umnoconf_dmno 2
	setprop persist.sys.ublx_umnoc_ims_path /marvell/tel/Settings_preferences.xml
	#on factory boot we need to reset IMS NVM
	setprop persist.sys.ublx_umnoconf_res 1
fi
#U_M39G_MV-1459

##M39G_MV_2-282 #M39G_MV_2-313 #M39G_MV_2-314 M39G_MV_2-365
UBLX_EEH_SEV=`getprop persist.sys.ublx_eeh.sev`
UBLX_EEH_SIG_MASK=`getprop persist.sys.ublx_eeh.sig_mask`

#set maximum severity
if [ -z "$UBLX_EEH_SEV" ]; then
	setprop persist.sys.ublx_eeh.sev 1
	mkdir -p /cache/ublx_eeh/
fi

#set no sig masking
if [ -z "$UBLX_EEH_SIG_MASK" ]; then
	setprop persist.sys.ublx_eeh.sig_mask 0
fi
#U_M39G_MV-880

#U_M39G_MV-2038 U_M39G_MV-2040
UBLOX_OMADMSDMVER=`getprop persist.sys.ublx_sdm_cfg_ver`

# if property is not there we need to configure the factory value
if [ -z "$UBLOX_OMADMSDMVER" ]; then
	setprop persist.sys.ublx_sdm_cfg_ver F14.UBX.TOBYL201.0
fi
#U_M39G_MV-2038 U_M39G_MV-2040


