#!/bin/sh

IFACE=$1
ACTION=$2

log()
{
	/system/bin/log -t wifi:action "$*"
}

log iface=$IFACE action=$ACTION

[ "$IFACE" != "mlan0" ] && exit

# M39G_MV_2-2058
DHCP=$(lwconfig read net_iface_${IFACE}_dhcp)
if [ "$ACTION" == "CONNECTED" ]; then

# M39G_MV_2-2058
#	DHCP=$(lwconfig read net_iface_${IFACE}_dhcp)
	if [ "$DHCP" == "1" ]; then
		# use DHCP on interface
		if [ ! -e /var/run/udhcpc-${IFACE}.pid ]; then
			log "Polling for DHCP server on interface ${IFACE}"
			export DHCP_KEEPGW=y DHCP_KEEPRESOLV=y
			udhcpc -i ${IFACE} -b -R -s /system/marvell/etc/udhcpc/default.script \
				-p /var/run/udhcpc-${IFACE}.pid -F $(lwconfig read hostname)
		else
			# DHCP running; renew lease
			kill -USR1 $(cat /var/run/udhcpc-${IFACE}.pid)
		fi
	else
		# use static ip configuration
		ADDRESS=$(lwconfig read net_iface_${IFACE}_address)
		NETMASK=$(lwconfig read net_iface_${IFACE}_netmask)
		if [ -n "$ADDRESS" ]; then
			[ -n "$NETMASK" ] && NETMASK="netmask $NETMASK"
			log "Configure network interface ${IFACE}: $ADDRESS $NETMASK"
			ifconfig ${IFACE} $ADDRESS $NETMASK
		fi

		# set gateway
		GATEWAY=$(lwconfig read net_${IFACE}_gateway)
		if [ -n "$GATEWAY" ]; then
			log "Adding gateway ${GATEWAY} for ${IFACE}"
			setprop net.${IFACE}.gw $GATEWAY
		fi

		# set dns
		NAMESERVERS=$(lwconfig read net_${IFACE}_nameservers)
		n=1;
		for i in $NAMESERVERS; do
			setprop net.${IFACE}.dns${n} $i;
			n=`expr $n + 1`;
		done

		# setup routing for WLAN station
		/system/marvell/tel/mlan_routing.sh CONNECTED

	fi

elif [ "$ACTION" == "DISCONNECTED" ]; then

	# reset routing
	/system/marvell/tel/mlan_routing.sh DISCONNECTED
# M39G_MV_2-2058
	if [ "$DHCP" == "1" ]; then
		if [ -e /var/run/udhcpc-${IFACE}.pid ]; then
			# DHCP running; renew lease; it will fail in 10 sec
			kill -USR1 $(cat /var/run/udhcpc-${IFACE}.pid)
		fi
	fi
fi
