var v = {
	  hb: {}
	, system: {
		    connection_lost: 0
		  , uptime: 0
	}
	, timers: {}
	, timings: {
		  bottomnavbar: 6000
		, busyPage: 5000
		, can: 1618
		, fw_update: 3000
		, main: 3000
		, sodCountdown : 1000
	}
	, xhrs: {}
};
// IE Mobile fix
if (navigator.userAgent.match(/IEMobile\/10\.0/)) {
	var msViewportStyle = document.createElement('style');
	msViewportStyle.appendChild(
		document.createTextNode('@-ms-viewport{width:auto!important}')
	)
	document.querySelector('head').appendChild(msViewportStyle)
}
// Check if toISOString is available, create function if not
if ( !Date.prototype.toISOString ) {
	( function() {
		function pad(number) {
			var r = String(number);
			if ( r.length === 1 ) {
				r = '0' + r;
			}
			return r;
		}

		Date.prototype.toISOString = function() {
			return this.getUTCFullYear()
				+ '-' + pad( this.getUTCMonth() + 1 )
				+ '-' + pad( this.getUTCDate() )
				+ 'T' + pad( this.getUTCHours() )
				+ ':' + pad( this.getUTCMinutes() )
				+ ':' + pad( this.getUTCSeconds() )
				+ '.' + String( (this.getUTCMilliseconds()/1000).toFixed(3) ).slice( 2, 5 )
				+ 'Z';
		};
	}() );
}
/*
 *  Set default settings to ajax calls
 *
 **/
$.ajaxSetup({
	  async: true
	, dataType: 'json'
	, type: 'POST'
	, url: 'ajaj.php'
});

/*
 * Initialize timers in v.timers
 * 
 * 	- v.timers.main
 *		This is the primary timer. Checks modem connection
 *
 *	- v.timers.bottomnavbar
 *		This timer creates an animation when viewport is xs (mobile).
 *		Switches between signal strength and up/down data
 *
 *	- v.timers.busy
 *		Checking whether device is busy
 *
 *	- v.timers.fw_update
 *		Handles manual firmware update.
 * 
 *	- v.timers.sodCountdown
 * 		Decrease time every second when Shut-off delay is set
 **/

 /*
  * Primary timer
  **/
v.timers.main = $.timer(function() {
	var xhr = $.ajax({
		beforeSend: function(xhr) {
			v.timers.main.pause();
		},
		data: {
			c: "RefreshStatus",
			isOverview: $('body').hasClass('page-overview')
		}
	}).done(function(json) {
		v.modem = json.data.status.modem;
		v.modem_session = json.data.status.modem.session;
		v.sim = json.data.sim_status;
		// v.modem.session = json.data.status.modem.session;
		// Set Modem IP and Connected Clients list in Overview page
		if( json.data.hasOwnProperty('settings') && ($('#Modal_ConnectedClientsWlan').length > 0  || $('.ConnectedClientsWlan').length > 0 ) ) {

			// DarkKnight: Temporary fix. If ip is zero set it back (hardcoded) EN language message.
			// Roni: Please fix it... :)
			if ( json.data.status.modem.ip.length > 0 )
				$('.internetIP').text(json.data.status.modem.ip);
			else
				$('.internetIP').text('No network available');
 
			if( $('#Modal_ConnectedClientsWlan').length > 0 ) {
				// $('#Modal_ConnectedClientsWlan .modal-body').html("");
				$(json.data.conn_devs.wlan).each(function( index, device ) {
					// TODO do this only when modal is opened
					// $('#Modal_ConnectedClientsWlan .modal-body').append(' \
						// <div class="row"> \
							// <div class="col-name col-xs-8 col-sm-6 text-right">'+device.name+'</div> \
							// <div class="col-ip col-xs-4 col-sm-6">'+device.ip+'</div> \
						// </div>'
					// );
				});
			} else {
				$('.ConnectedClientsWlan').html("");
				$(json.data.conn_devs.wlan).each(function( index, device ) {
					$('.ConnectedClientsWlan').append(' \
						<dt>'+device.name+'</dt> \
						<dd>'+device.ip+'</dd>'
					);
				});
			}
			$('.wlanDevicesCount').text(json.data.conn_devs.wlan.length);
			equal_box_heights();
		}
		// Set modem traffic (up and down)
		$('.internetUp').text(v.modem.up);
		$('.internetDown').text(v.modem.down);
		// Set modem signal strength
		v.modem.signalClass = 'signal'+v.modem.signal;
		if( !$('.modemSignal').hasClass(v.modem.signalClass) ) {
			$('.modemSignal').removeClass('signal0 signal1 signal2 signal3 signal4 signal5');
			$('.modemSignal').addClass(v.modem.signalClass);
			$('.modemSignal').attr('title', v.modem.signal);
		}
		// Set modem Operator
		$('.modemOperator').text(v.modem.operator);
		// Set mode of modem Operator
		$('.modemMode').text(v.modem.radio);
		switch (v.modem.radio) {
			case "LTE":
				$('.modemMode').text("4G");
				break;
			case "DC-HSPA":
			case "DC-HSPA+":
			case "HSDPA":
			case "HSPA":
			case "HSPA+":
			case "HSUPA":
			case "HSDPA/HSUPA":
			case "UMTS":
			case "WCDMA":
				$('.modemMode').text("3G");
				break;
			case "EDGE":
			case "GPRS":
			case "GSM":
				$('.modemMode').text("2G");
				break;
			default:
				$('.modemMode').text(v.modem.radio);
				break;
		}
/* U_M39G_MV-2327 */
		switch (json.data.settings.wlan.region_blocked) {
			case "OFF":
				$('#region_blocked_EU_div').hide();
				$('#region_blocked_JP_div').hide();
				$('#region_blocked_US_div').hide();
				$('#region_blocked_OFF_div').show();
				$('#channel_list_EU_div').hide();
				$('#channel_list_JP_div').hide();
				$('#channel_list_US_div').hide();
				$('#channel_list_OFF_div').show();
				break;
			case "EU":
				$('#region_blocked_US_div').hide();
				$('#region_blocked_OFF_div').hide();
				$('#region_blocked_JP_div').hide();
				$('#region_blocked_EU_div').show();
				$('#channel_list_US_div').hide();
				$('#channel_list_OFF_div').hide();
				$('#channel_list_JP_div').hide();
				$('#channel_list_EU_div').show();
				break;
			case "JP":
				$('#region_blocked_US_div').hide();
				$('#region_blocked_OFF_div').hide();
				$('#region_blocked_EU_div').hide();
				$('#region_blocked_JP_div').show();
				$('#channel_list_US_div').hide();
				$('#channel_list_OFF_div').hide();
				$('#channel_list_EU_div').hide();
				$('#channel_list_JP_div').show();
				break;
			case "US":
			default:
				$('#region_blocked_EU_div').hide();
				$('#region_blocked_OFF_div').hide();
				$('#region_blocked_JP_div').hide();
				$('#region_blocked_US_div').show();
				$('#channel_list_EU_div').hide();
				$('#channel_list_OFF_div').hide();
				$('#channel_list_JP_div').hide();
				$('#channel_list_US_div').show();
				break;
		}
		
		// Set Temperature datas in Device information page
		if( json.data.status.hasOwnProperty('board_temp') ) {
			$('.board_temp').text(parseFloat(json.data.status.board_temp.value).toFixed(1));
			$('.cpu_temp').text(parseFloat(json.data.status.cpu_temp.value).toFixed(1));
		}
		// Set 'sim' object when it is not present by default
		if( !json.data.hasOwnProperty('sim_status') ) {
			v.sim = {inserted : 1, pin: "na"};
		}
		if( v.sim.inserted == 1 ) {
			if( json.data.status.modem.hasOwnProperty('connected_since') ) {
				$('.connTime').text( Math.floor(json.data.status.modem.connected_since / 60));
			}
			/*if(		json.data.status.modem.roaming == "TRYING_TO_REGISTER"
				||
					(
						json.data.status.modem.roaming == "REGISTERED_HOME"
					&&	
						(
							json.data.status.modem.session == ""
						||
							json.data.status.modem.session == "UNKNOWN"
						)
					)
				) 
			{
				if( ('.page-overview').length > 0 ) {
					$('.modem-connection').addClass("hidden");
					$('.data-volumes').addClass("hidden");
				}
				// Hide everything but LanguageSelector on Bottom navbar
				$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
				$('.navbar-fixed-bottom .sim_registering').show();
				//$('.navbar-fixed-bottom').html('<span class="global_sim_networksearch_msg pull-left">'+'Network search'+'</span>');
			} else */
			if( v.modem.roaming == "TRYING_TO_REGISTER" ) {
				$('.alert-warning').addClass('hidden');
				$('.modemSignal').removeClass('roaming');
				$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
				$('.navbar-fixed-bottom .sim_registering').show();
				if( ('.page-overview').length > 0 ) {
					$('.modem-connection').addClass("hidden");
					$('.data-volumes').addClass("hidden");
				}
			} else if( v.modem.roaming == "REGISTERED_HOME" || v.modem.roaming == "ROAMING_AVAILABLE" ) {
				if( v.modem.roaming == "ROAMING_AVAILABLE" ) {
					$('.modemSignal').addClass('roaming');
					$('.alert-warning').removeClass('hidden');
				} else {
					$('.modemSignal').removeClass('roaming');
					$('.alert-warning').addClass('hidden');
				}
				if( v.modem.session == "UNKNOWN" || v.modem.session == "SESSION_UNKNOWN" ) {
					$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
					$('.navbar-fixed-bottom .sim_registering').show();
					if( ('.page-overview').length > 0 ) {
						$('.modem-connection').addClass("hidden");
						$('.data-volumes').addClass("hidden");
					}
				} else if( v.modem.session == "SESSION_NOTSET" ) {
					$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
					$('.navbar-fixed-bottom .sim_apn_missing').show();
					if( ('.page-overview').length > 0 ) {
						$('.modem-connection').addClass("hidden");
						$('.data-volumes').addClass("hidden");
					}
				} else {
					$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
					$('.navbar-fixed-bottom .group_modem').show();
					$('.modem-connection').removeClass("hidden");
// 					if( v.modem.session == "SESSION_CONNECTED" && $('.page-overview').length > 0 && $('.modem-connection').length == 0 ) {
// 						location.reload();
// 					}
					// v.viewport = findBootstrapEnvironment();
					if( v.viewport != "xs" ) {
						if( (v.modem.session == "SESSION_DISCONNECTED" || v.modem.session == "SESSION_NOTSET") ) {
							$('.modemActualSpeed').hide();
						} else {
							$('.modemActualSpeed').show();
						}
					}
				}
// 				if( ('.page-overview').length > 0 ) {
// 					$('.modem-connection').removeClass("hidden");
// 					if( v.modem.session == "SESSION_CONNECTED" && $('.data-volumes').hasClass("hidden") ) {
// 						location.reload();
// 					}
// 				}
			} else if( v.modem.roaming == "NOT_REGISTERED" ) {
				$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
				$('.navbar-fixed-bottom .sim_limited_service').show();
			} else if( v.modem.roaming == "REGISTRATION_DENIED" ) {
				$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
				$('.navbar-fixed-bottom .sim_reg_denied').show();
			} else {
				if( v.sim.pin == "PIN_NEEDED" ) {
					if( $('.page-overview').length > 0 && $('#SimPinEntryGroup').length == 0 ) {
						location.reload();
					} else {
						$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
						$('.navbar-fixed-bottom .sim_pin_needed').show();
						// $('.navbar-fixed-bottom').html('<span class="global_sim_nopin_msg pull-left">'+json.i18n.global_sim_nopin_msg+'</span>');
					}
				} else if( v.modem.session == "SESSION_NOTSET" ) {
					$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
					$('.navbar-fixed-bottom .sim_apn_missing').show();
					if( ('.page-overview').length > 0 ) {
						$('.modem-connection').addClass("hidden");
						$('.data-volumes').addClass("hidden");
					}
				} else if( v.sim.pin == "PIN_OK" ) {
					$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
					$('.navbar-fixed-bottom .sim_registering').show();
					if( ('.page-overview').length > 0 ) {
						$('.modem-connection').addClass("hidden");
						$('.data-volumes').addClass("hidden");
					}
				} else {
					$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
					$('.navbar-fixed-bottom .sim_initializing').show();
					// $('.navbar-fixed-bottom').html('<span class="global_sim_networksearch_msg pull-left">'+'Initializing SIM card.'+'</span>');
					if( ('.page-overview').length > 0 ) {
						$('.modem-connection').addClass("hidden");
						$('.data-volumes').addClass("hidden");
					}
				}
			}
		} else {
			v.hb.run = 0;
			$('.sim-setup-box').remove();
			$('.navbar-fixed-bottom > *:not(#LanguageSelector)').hide();
			$('.navbar-fixed-bottom .sim_not_inserted').show();
			// $('.navbar-fixed-bottom').html('<span class="global_nosim_msg pull-left">'+json.i18n.global_nosim_msg+'</span>');
			if( ('.page-overview').length > 0 ) {
				$('.modem-connection').addClass("hidden");
				$('.data-volumes').addClass("hidden");
			}
			$('.modemSignal').removeClass('roaming');
			$('.alert-warning').addClass('hidden');
			equal_box_heights();
		}
		if( $('.page-overview').length > 0 || $('.page-settings-system').length > 0 ) {
			if( !json.data.status.sod ) {
				$('#Sod_btn').removeClass('disabled');
				$('.label-sod-activated').addClass('hidden');
				if( !$('.alert-sod-active').parent().hasClass('hidden') ) {
					$('.alert-sod-active').parent().addClass('hidden');
					v.timers.sodCountdown.stop();
				}
			} else {
				$('#Sod_btn').addClass('disabled');
				$('.label-sod-activated').removeClass('hidden');
				if( $('.alert-sod-active').parent().hasClass('hidden') ) {
					$('.alert-sod-active').parent().removeClass('hidden');
					$('.sod_remained').text(json.data.status.sod.remained);
					v.timers.sodCountdown.play();
				}
			}
// 			if( !$('.alert-sod-active').parent().hasClass('hidden') ) {
// 				if( json.status.sod == "" ) {
// 					$('.alert-sod-active').parent().addClass('hidden');
// 					v.timers.sodCountdown.stop();
// 				} else {
// 					v.timers.sodCountdown.play();
// 				}
// 			} else {
// 				if( json.status.sod ) {
// 					$('.alert-sod-active').parent().removeClass('hidden');
// 					v.timers.sodCountdown.play();
// 				} else {
// 					v.timers.sodCountdown.stop();
// 				}
// 			}
		}
		//~ if( json.data.hasOwnProperty('sim_status') ) {
			//~ 
			//~ if( 	json.data.sim_status.inserted == 1
				//~ &&
					//~ (
						//~ json.data.status.modem.roaming == "TRYING_TO_REGISTER"
					//~ ||
						//~ (
							//~ json.data.status.modem.roaming == "REGISTERED_HOME"
						//~ &&
							//~ json.data.status.modem.session == ""
						//~ )
					//~ )
				//~ ) {
				//~ $('.navbar-fixed-bottom').html(' \
				//~ <span class="global_sim_networksearch_msg pull-left">'+'Network search'+'</span> \
				//~ ');
			//~ }
		//~ }
		v.timers.main.play();
	});
}, v.timings.main, false);

v.timers.busyPage = $.timer(function() {
	var xhr = $.ajax({
		beforeSend: function(xhr) {
			window.timerFunctionBusyPage = 1;
			v.timers.busyPage.pause();
		}
		, data: {
			  c: "CheckBusyStatus"
		}
		, timeout: 5000
	}).done(function(json) {
		console.log(json);
		if( json.session.length == 0 && json.status == "success" ) {
			location.assign('./');
		} else if( json.data.code != 0 && json.status == "error" ) {
			location.assign('./settings-update.php');
		} else {
			v.timings.busyPage = 5000;
			v.timers.busyPage.play();
		}
		
// 		console.log(window.uptime +" "+json.data.uptime);
// 		v.system.uptime = json.data.uptime;
// 		if( v.system.connection_lost == 1 ) {
// 			v.timers.busyPage.stop();
// 			location.assign('./');
// 		} else {
// 			if( json.status == "success" ) {
// 				
// 			} else if( json.status == "error" ) {
// 				
// 			}
// 		}
	});
}, v.timings.busyPage, false);

 /*
  * Timer for bottom navbar when viewport is xs
  **/
v.timers.bottomnavbar = $.timer(function() {
	if( $('.navbar .modemActualSpeed').hasClass('hidden-xs') ) {
		$('.navbar .modemActualSpeed').addClass('fake-hidden-xs');
		$('.navbar .modemActualSpeed').hide().removeClass('hidden-xs');
	}
	if( $('.navbar .modemActualSpeed').is(':visible') ) {
		$('.navbar .modemActualSpeed').fadeToggle({
			  duration:'slow'
			, complete: function() {
				$('.navbar .modemActualSpeed').addClass('fake-hidden');
				$('.navbar .modemSignal').fadeToggle({
					  duration:'slow'
					, queue:false
					, complete: function() {
						$('.navbar .modemSignal').removeClass('fake-hidden');
					}
				});
				$('.navbar .modemOperator').fadeToggle({
					  duration:'slow'
					, queue:false
					, complete: function() {
						$('.navbar .modemOperator').removeClass('fake-hidden');
					}
				});
				$('.navbar .modemMode').fadeToggle({
					  duration:'slow'
					, queue:false
					, complete: function() {
						$('.navbar .modemMode').removeClass('fake-hidden');
					}
				});

			}
		});
	} else {
		$('.navbar .modemSignal').fadeToggle({
			  duration:'slow'
			, queue:false
			, complete: function() {
				$('.navbar .modemSignal').addClass('fake-hidden');
			}
		});
		$('.navbar .modemOperator').fadeToggle({
			  duration:'slow'
			, queue:false
			, complete: function() {
				$('.navbar .modemOperator').addClass('fake-hidden');
			}
		})
		$('.navbar .modemMode').fadeToggle({
			  duration:'slow'
			, queue:false
			, complete: function() {
				$('.navbar .modemMode').addClass('fake-hidden');
				$('.navbar .modemActualSpeed').fadeToggle('slow');
				$('.navbar .modemActualSpeed').removeClass('fake-hidden');
			}
		});
	}
	
}, v.timings.bottomnavbar, false);

 /*
  * Timer for FW update page
  **/
v.timers.fw_update = $.timer(function() {
	var xhr = $.ajax({
		data: {
			c: "CheckUpdateStatus"
		}
		, beforeSend: function(xhr) {
			v.timers.fw_update.pause();
		}
	}).done(function(json) {
		v.timers.fw_update.play();
		// console.log(window.uptime +" "+json.data.uptime);
		v.system.uptime = json.data.uptime;
		if( v.system.connection_lost == 1 ) {
			v.timers.fw_update.stop();
			location.assign('./');
		} else {
			if( json.status == "success" ) {
				
			} else if( json.status == "error" ) {
				v.timers.fw_update.stop();
				$('.panel-heading .loading').addClass('hidden');
				$('.panel-body.loading').addClass('hidden');
				$('.panel-heading .interaction').removeClass('hidden');
				$('.panel-body.interaction').removeClass('hidden');
				$('.panel-footer.interaction').removeClass('hidden');
				$('.panel-body.interaction').text(json.msg.text);
				$('.panel-heading .interaction').text(json.msg.header);
				$('#Ok_btn').attr("onclick", "javascript:location.reload();");
			}
		}
	});
}, v.timings.fw_update, false);

 /*
  * Timer for displaying Shut-off delay 
  **/
v.timers.sodCountdown = $.timer(function() {
	if( parseInt($('.alert-sod-active .sod_remained').text()) > 0 ) {
		$('.alert-sod-active .sod_remained').text( parseInt($('.alert-sod-active .sod_remained').text()) -1 );
	} else {
		v.timers.sodCountdown.stop();
	}
}, v.timings.sodCountdown, false);

//* ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *//

// Do a bunch of stuff when document done loading
$(document).ready(function() {
	if( $('.page-busy').length > 0 ) {
		v.timers.busyPage.play();
	} else {
		v.timers.main.play();
	}
	if( !($('.alert-sod-active').parent().hasClass('hidden')) ) {
		v.timers.sodCountdown.play();
	}
	if( $('.navbar-collapse').length > 0 ) {
		v.viewport = findBootstrapEnvironment();
		window.navbar_max_height = $('.navbar-collapse').css('max-height').substr(0,$('.navbar-collapse').css('max-height').length -2);
		if( v.viewport == "xs" ) {
			v.timers.bottomnavbar.play();
		}
		$(window).resize(function() {
			v.viewport = findBootstrapEnvironment();
			if( v.viewport == "xs" ) {
				v.timers.bottomnavbar.play();
			} else {
				$('.fake-hidden-xs').addClass('hidden-xs').removeClass('fake-hidden-xs');
				$('.fake-hidden').removeClass('fake-hidden').show();
				v.timers.bottomnavbar.stop();
				$('.navbar-collapse').removeClass('in');
			}
			$('.navbar-collapse').css('max-height', $(window).height() - $('.navbar-header').height() - $('.navbar-fixed-bottom').height() +"px");
			equal_box_heights();
		});
		equal_box_heights();
	}
	if( $('.page-settings-system').length > 0 || $('.page-settings-config').length > 0 ) {
		$('#SystemReset_btn, #FirmwareReset_btn').click(function(event) {
			var xhr = $.ajax({
				data: {
					c: "SetSessionVar"
					, key: "system_busy"
					, value: (($(this).attr('id') == "SystemReset_btn")? 'sw_reset' : 'fw_reset')
				}
			}).done(function(json) {
				if( json.status == "success" ) {
					location.assign("./busy.php");
				}
			});
		});
	}
	$('.custom-tooltip').tooltip();
	$('#Modal_ConnectedClientsWlan .col-name').tooltip();
	$('.btn').button();
	$(document).ajaxError(function(event, jqxhr, settings, exception) {
		switch( jqxhr.status ) {
			case 0:
			case 404:
			case 500:
				if( window.timerFunctionBusyPage == 1 ) {
					v.timings.busyPage = 250;
					v.timers.busyPage.play();
				} else {
					window.connection_lost = 1;
					if( settings.data.indexOf("c=CheckUpdateStatus") != -1 ) {
						v.timers.fw_update.play();
					}
					v.timers.main.play();
				}
				break;
			default:
				break;
		}
	});
	$('.navbar-fixed-bottom span[data-toggle]').tooltip({
		  template:'<div class="tooltip visible-xs" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
		, trigger: 'click hover focus'
	});
	$('#accordion_received').on('shown.bs.collapse', function(e) {
		var panel = {};
		panel.read = $('#'+e.target.id).hasClass('panel-info');
		if( panel.read == 0 ) {
			panel.obj = $('#'+e.target.id).parent();
			panel.checksum = $('#'+e.target.id).children('.checksum').val();
		}
	});
	// Close mini menu, when click outside of it
	$('.container').click(function( event ) {		
		if( !$(event.target).hasClass('navbar-collapse') && $(event.target).parents('.navbar-collapse') == 0 ) {
			if( $('.navbar-collapse').hasClass("in") ) {
				$('.navbar-collapse').collapse("hide");
			}
		}
	});

	if( $('.theme_selection').length > 0 ) {
		$('.theme_selection:not(.active) a').click(function( event ) {
			event.preventDefault();
			var a = $(this).attr('href').substr(1)
			var xhr = $.ajax({
				data: {
					  c: "SetTheme"
					, theme: a
				}
			}).done(function(json) {
				if( json.status == "success" ) {
					location.reload();
				}
			});
		});
	}

	if( $('.update-in-progress').length > 0 ) {
		v.timers.fw_update.play();
	}

	$('#langsel_modal .list-group li:not(.disabled) a').click(function( event ) {
		event.preventDefault();
		$('#langsel_modal input[name=selectedLang]').val( $(this).attr("href").substr(1) );
		$('#langsel_modal .list-group-item').removeClass("active");
		$(this).parent().addClass("active");
	});
	$('#SaveLang_btn').click(function(event) {
		$('#SaveLang_btn').button('loading');
		$('#SaveLang_btn').next().attr('disabled', 'disabled');
		var xhr = $.ajax({
				data: {
					  c: "SaveLanguageSettings"
					, selectedLang: $('#langsel_modal input[name=selectedLang]').val()
				}
			}).done(function(json) {
				if( json.status == "success" ) {
					location.reload();
				}
			});
	});
	$('.custom-option li:not(.disabled)').click(function( event ) {
		event.preventDefault();
		// this changes the current language by user selection
		if( ($(this).parents('.custom-option').eq(0).context.nodeName == "LI" || $(this).parents('.custom-option').eq(0).context.nodeName == "UL") && $(this).parents('#LanguageSelector').length > 0 ) {
			var lang = $(this).children('a').attr('href').substr(1);
			var xhr = $.ajax({
				data: {
					  c: "SaveLanguageSettings"
					, selectedLang: lang
				}
			}).done(function(json) {
				if( json.status == "success" ) {
					location.reload();
				}
			});
		}
		if( !$(this).hasClass('disabled') ) {
			if( $(this).children('a').hasClass('flag') ) {
				// Language Dropdown is clicked
				var prevLang = $(this).siblings('.active').children('a').attr('href').substr(1);
				var lang = $(this).children('a').attr('href').substr(1);
				if( $(this).parents('custom-option').eq(0).context.nodeName == "LI" ) {
					$(this).parents('.custom-option').find('.dropdown-toggle').children('.selectedOption').removeClass('flag_'+prevLang);
					$(this).parents('.custom-option').find('.dropdown-toggle').children('.selectedOption').addClass('flag_'+lang);
				} else {
					$(this).parents('.custom-option').find('.btn.dropdown-toggle').children('span.selectedOption').removeClass('flag_'+prevLang);
					$(this).parents('.custom-option').find('.btn.dropdown-toggle').children('span.selectedOption').addClass('flag_'+lang);
				}
			}
			$(this).parents('.custom-option').prev().attr("value", $(this).children('a').attr('href').substr(1)); // change value to newly selected value
			$(this).parents('.custom-option').find('li').removeClass("active");	// remove active class
			$(this).parents('.custom-option').find('.selectedOption').text($(this).text()); // change displayed text in dropdown btn
			$(this).addClass('active'); // add active class
			if( $(this).parents('.custom-option').prev().attr("name") == "selectedRegion" 
					||
				$(this).parents('.custom-option').prev().attr("name") == "selectedNetworkmode" ) {
				// WLAN Region Dropdown is clicked
/* M39G_MV_2-1152 */
				if ($('.group-NetworkMode input[name=selectedNetworkmode]').val() == "A" ||
					$('.group-NetworkMode input[name=selectedNetworkmode]').val() == "AN_MIXED" ||
					$('.group-NetworkMode input[name=selectedNetworkmode]').val() == "AN" ) {
				$('.group-Channel .custom-option li').removeClass("disabled");
				var max = 1; // index 0 == AUTO
				$('.group-Channel .custom-option li').each(function( index, value) {
					if( index >= max ) {
						$('.group-Channel .custom-option li').eq(index).addClass("disabled");
					}
				});
				}
				else {
				$('.group-Channel .custom-option li').removeClass("disabled");
				var max = 13;
/* U_M39G_MV-2327 */ 
				console.log( $('.group-Region:visible input[name=selectedRegion]').val() );
				switch( $('.group-Region:visible input[name=selectedRegion]').val() ) {
					case "EU":
						max = 13;
						break;
					case "US":
						max = 11;
						break;
					case "CN":
						max = 12;
						break;
					case "JP":
						if( $('.group-NetworkMode input[name=selectedNetworkmode]').val() == 'B') {
							max = 14;
						} else {
							max = 13;
						}
						break;
					default:
						max = 13;
				}
				max++; // index 0 == AUTO
/* U_M39G_MV-2327 */ 
				console.log(String("Max ") + max);
				console.log(String("NetworkMode ") + $('.group-NetworkMode input[name=selectedNetworkmode]').val());
				$('.group-Channel:visible .custom-option li').each(function( index, value) {
				console.log(String("Index ") + index);
					if( index >= max ) {
						$('.group-Channel:visible .custom-option li').eq(index).addClass("disabled");
					}
				});
/* M39G_MV_2-1152 */
				}
				
				// Toggle 'Bandwidth' & 'Guard Interval' according to Network mode
				if( $('.group-NetworkMode input[name=selectedNetworkmode]').val() == "N" ) {
					$('.group-Bandwidth').show();
					$('.group-Guardint').show();
				} else {
					$('.group-Bandwidth').hide();
					$('.group-Guardint').hide();
				}
			} else if( $(this).parents('.custom-option').prev().attr("name") == "selectedSecurityMode" ) {
				// WLAN Security Dropdown is clicked
				if( $('.group-Encryption input[name=selectedSecurityMode]').val() == "OPEN" ) {
					$('.group-Password').hide();
				} else {
					$('.group-Password').show();
				}
				if( $('.group-Encryption input[name=selectedSecurityMode]').val() == "WPA2_ENTERPRISE" ) {
					$('.group-user').show();
				} else {
					$('.group-user').hide();
				}
			// } else if(  $(this).parents('.custom-option').prev().attr("name") == "selectedNetworkmode"  ) {
				// // Toggle 'Bandwidth' & 'Guard Interval' according to Network mode
				// if( $('.group-NetworkMode input[name=selectedNetworkmode]').val() == "N" ) {
					// $('.group-Bandwidth').show();
					// $('.group-Guardint').show();
				// } else {
					// $('.group-Bandwidth').hide();
					// $('.group-Guardint').hide();
				// }
			} else if(  $(this).parents('.custom-option').prev().attr("name") == "selectedRoute"  ) {
				v.selected_route = $(this).children('a').attr('href').substr(1);
				v.xhr = $.ajax({
					  beforeSend: function() {
						$('#RouteSelection_btn').addClass('disabled');
						$('.ajaxloader').removeClass('hidden');
					}
					, data: {
						  c: "GetRoute"
						, selectedRoute: v.selected_route
					}
				}).done(function(json) {
					if( json.status == "success" ) {
						// console.log(json.data);
						mapi.route = [];
						$.each(json.data.coords, function( key, value ) {
							mapi.route.push(new google.maps.LatLng( value['lat'], value['long'] ));
						});
						// Remove Polyline if it was set previously
						if( mapi.path ) {
							mapi.path.setMap(null);
						}
						// Remove markers if was any
						$.each(mapi.markers, function( key ) {
							//console.log(key);
							mapi.markers[key].setMap(null);
						});
						if( json.data.coords.length > 0 ) {
							mapi.path = new google.maps.Polyline({
								path: mapi.route,
								geodesic: false,
								strokeColor: '#FF0000',
								strokeOpacity: 1.0,
								strokeWeight: 2
							});
							mapi.path.setMap(mapi.map);
							mapi.map.fitBounds(mapi.path.getBounds());
							if( mapi.map.getZoom() > 19 ) {
								mapi.map.setZoom(19);
							}
							// http://kml4earth.appspot.com/icons.html
							mapi.markers.m1 = new google.maps.Marker({
								  icon: {
									  scaledSize: new google.maps.Size(45, 45)
									, url: "http://maps.google.com/mapfiles/kml/paddle/A.png"
								}
								, map: mapi.map
								, position: mapi.route[0]
								// , title: "Start"
							});
							mapi.markers.m2 = new google.maps.Marker({
								  icon: {
									  scaledSize: new google.maps.Size(45, 45)
									, url: "http://maps.google.com/mapfiles/kml/paddle/B.png"
								}
								, map: mapi.map
								, position: mapi.route[mapi.route.length - 1]
								// , title: "Stop"
							});
						}
						$('.gps_count').text(json.data.coords.length);
						$('.vehicle_type').text(json.data.vehicle_type);
						$('.travel_time').text(parseFloat(json.data.travel_time / 60).toFixed(2) + " minutes");
						$('#RouteSelection_btn').removeClass('disabled');
						$('.ajaxloader').addClass('hidden');
					}
				});
			}
		}
	});
	/*
	 * Initialize Clickable Help Icons to show modals
	 * 
	 * */
	$('#'+$('#currentPage').val()+'_form .glyphicon-question-sign, #sim-setup_form .glyphicon-question-sign, #sim-setup_form-pin-input .glyphicon-question-sign, .page-overview .sim-setup-box .glyphicon-question-sign').click(function() {
		$(this).parent().parent().children('.modal').eq(0).modal();
	});
	/*
	 * Initialize Profile Selection list-group
	 * 
	 * */
	InitProfileSelection();
	$('#Save_btn, #PIN_Entry_btn, #PUK_Entry_btn').click(function() {
		v.save_fn = {
			panel: "default"
		};
		// This expects that button is member of panel
		if( $(this).parents('.panel').eq(0).hasClass("sim-setup-box") ) {
			v.save_fn.panel = "sim-setup-box";
		} else if( $(this).parents('.none').eq(0).hasClass("sim-setup-box") ) {
			v.save_fn.panel = "sim-setup-box";
		} else if( $(this).parents('.panel').eq(0).hasClass("panel-sim-setup") ) {
			v.save_fn.panel = "sim-setup-box";
		}
		
		if( v.save_fn.panel == "sim-setup-box" ) {
		// if( ($('.page-sim-setup').length > 0 || $('.page-overview').length > 0) && $('.page-login').length == 0 ) {
			SimSetup();
		} else {
			var page = $('#currentPage').val();
			$('#Save_btn').button('loading');
			var xhr = $.ajax({
				  async: true
				, beforeSend: function() {
					$('.alert-success').addClass('hidden');
					$('.alert-danger').addClass('hidden');
					$('.alert-success').removeClass('hidden');
					$('.panel-'+page).removeClass('panel-success panel-error');
/* M39G_MV_2-1152 */
					$('.panel-footer .msg_success, .panel-footer .msg_error .msg_error_validity').hide();
					$('.'+page+'_form .alert').alert('close');
					$(' \
						.page-'+page+' .form-group .form-control, \
						.page-'+page+' .form-group input[type=checkbox], \
						.page-'+page+' .form-group .custom-btn-group label, \
						.page-'+page+' .form-group .custom-option .btn.dropdown-toggle, \
						#Cancel_btn').attr("disabled", "disabled");
					$('.text-danger').addClass('hidden');
					$('.form-group').removeClass('has-error');
					var stopAjax = false;
					if( stopAjax == true ) {
						xhr.abort();
						return false;
					}
				}
				, dataType: 'json'
				, data: $('#'+page+'_form').serialize()
				, type: 'POST'
				, url: 'ajaj.php'
			}).done(function(json) {
				switch(json.status) {
					case "success":
						if( json.c == "LoginSettings" || json.c == "SaveLanguageSettings" ) {
							location.reload();
						} else {
							$('#Save_btn').button('reset');
							$(' \
								.page-'+page+' .form-group .form-control, \
								.page-'+page+' .form-group input[type=checkbox], \
								.page-'+page+' .form-group .custom-btn-group label, \
								.page-'+page+' .form-group .custom-option .btn.dropdown-toggle, \
								#Cancel_btn').removeAttr("disabled");
							$('.panel-'+page).addClass('panel-success');
/* M39G_MV_2-1152 */
							$('.panel-footer .msg_error_validity').hide();
/* U_M39G_MV-2251 */
							$('.panel-footer .msg_error').hide();
							$('.panel-footer .msg_success').show();
							$('.alert-success').removeClass('hidden');
						}
						break;
					case "error":
						$('.alert-danger').removeClass('hidden');
						$('#Save_btn').button('reset');
						$(' \
							.page-'+page+' .form-group .form-control, \
							.page-'+page+' .form-group input[type=checkbox], \
							.page-'+page+' .form-group .custom-btn-group label, \
							.page-'+page+' .form-group .custom-option .btn.dropdown-toggle, \
							#Cancel_btn').removeAttr("disabled");
						$('.panel-'+page).addClass('panel-error');
/* U_M39G_MV-2251 */
						$('.panel-footer .msg_error_validity').hide();
						$('.panel-footer .msg_success').hide();
						$('.panel-footer .msg_error').show();
						$('.text-danger').removeClass('hidden');
						if( json.msg == "validation error" ) {
							$.each(json.data, function( key, value ) {
	//						$(json.data).each(function( key, value ) {
								$('#'+key).parents('.form-group').addClass('has-error');
								//console.log(key + " "+value);
							});
						}
						break;
/* M39G_MV_2-1152 */
					case "error_validity":
						$('.alert-danger').removeClass('hidden');
						$('#Save_btn').button('reset');
						$(' \
							.page-'+page+' .form-group .form-control, \
							.page-'+page+' .form-group input[type=checkbox], \
							.page-'+page+' .form-group .custom-btn-group label, \
							.page-'+page+' .form-group .custom-option .btn.dropdown-toggle, \
							#Cancel_btn').removeAttr("disabled");
						$('.panel-'+page).addClass('panel-error');
						$('.panel-footer .msg_success').hide();
/* U_M39G_MV-2251 */
						$('.panel-footer .msg_error').hide();
						$('.panel-footer .msg_error_validity').show();
						$('.text-danger').removeClass('hidden');
						if( json.msg == "validation error" ) {
							$.each(json.data, function( key, value ) {
	//						$(json.data).each(function( key, value ) {
								$('#'+key).parents('.form-group').addClass('has-error');
								//console.log(key + " "+value);
							});
						}
						break;
					default:
						break;
				}
			});
		}
	});
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */	
	$('#wui_access_on_label').click(function() {
		$('#wui_revert_div').show();
		$('#wui_cache_div').show();
	});
	$('#wui_access_off_label').click(function() {
		$('#wui_revert_div').hide();
		$('#wui_cache_div').hide();
	});
	/*$('#dialin_on_label').click(function() {
		$('#connName_div').show();
		$('#ap_div').show();
		$('#simprofile_div').show();
		$('#roaming_div').show();
		$('#pin_div').show();
		$('#data_div').show();
		$('#reset_div').show();
		$('#user_div').show();
		$('#pass_div').show();
		$('#auth_div').show();
		$('#dns1_div').show();
		$('#dns2_div').show();
	});
	$('#dialin_off_label').click(function() {
		$('#connName_div').hide();
		$('#ap_div').hide();
		$('#simprofile_div').hide();
		$('#roaming_div').hide();
		$('#pin_div').hide();
		$('#data_div').hide();
		$('#reset_div').hide();
		$('#user_div').hide();
		$('#pass_div').hide();
		$('#auth_div').hide();
		$('#dns1_div').hide();
		$('#dns2_div').hide();
	})*/;
	$('#sta_enable_on_label').click(function() {
		$('#ssid_input_div').show();
		$('#encryption_input_div').show();
		$('#encryption_key_input_div').show();
		$('#dhcp_input_div').show();
		if ($("#sta_dhcp_input").val() == "0") {
			$('#ip_input_div').show();
			$('#subnet_input_div').show();
			$('#gateway_input_div').show();
			$('#dns_input_div').show();
		}
	});
	$('#sta_enable_off_label').click(function() {
		$('#ssid_input_div').hide();
		$('#encryption_input_div').hide();
		$('#encryption_key_input_div').hide();
		$('#dhcp_input_div').hide();
		$('#ip_input_div').hide();
		$('#subnet_input_div').hide();
		$('#gateway_input_div').hide();
		$('#dns_input_div').hide();
	});
	$('#sta_dhcp_on_label').click(function() {
		$("#sta_dhcp_input").val("1");
		$('#ip_input_div').hide();
		$('#subnet_input_div').hide();
		$('#gateway_input_div').hide();
		$('#dns_input_div').hide();		
	});
	$('#sta_dhcp_off_label').click(function() {
		$("#sta_dhcp_input").val("0");
		$('#ip_input_div').show();
		$('#subnet_input_div').show();
		$('#gateway_input_div').show();
		$('#dns_input_div').show();
	});
	$('.page-ftp #Upload_btn').click(function(e) {
		e.preventDefault();
		var xhr = $.ajax({
			beforeSend: function() {
				$('.fileuploadMask_btn').addClass('disabled');
				$('#Upload_btn').addClass('disabled');
			}
			, data: {
				  c: "ChangeTmpDir"
				, type: "ftp"
				, path: $('#current_directory').val()
			}
		}).done(function(json) {
			$('#ftp_form').submit();
		});
	});
	$('.page-ftp #ViewMode label').click(function(e) {
		var xhr = $.ajax({
			data: {
				  c: "SetSessionVar"
				, key: "thumbnail_view"
				, value: $(this).children('input').attr("value")
			}
//		}).done(function(json) {
		});
		if( $(this).children('input').attr("value") == 1 ) {
			$('.thumbnail-view').removeClass('hidden');
			$('.list-view').addClass('hidden');
		} else {
			$('.thumbnail-view').addClass('hidden');
			$('.list-view').removeClass('hidden');
		}
	});
	$('#LogoutAdmin_btn').click(function( event ) {
		event.preventDefault();
		var xhr = $.ajax({
			data: {
				c: "LogoutAdmin"
			}
		}).done(function(json) {
			if( json.status == "success" ) {
				location.assign("./");
			}
		});
	});
	$('.fileuploadMask_btn').click(function() {
		$('.fileupload_btn').click();
	});
	$('input[name="file_upload"]').change(function() {
		$('.fileuploadMask_btn').button('changed');
		$('#Upload_btn').removeClass('disabled');
	});
	$('input[name="file_upload_ftp"]').change(function() {
		$('.fileuploadMask_btn').button('changed');
		$('#Upload_btn').removeClass('disabled');
	});
	$('input[name="restore_config"]').change(function() {
		$('.fileuploadMask_btn').button('changed');
		$('#Upload_btn').removeClass('disabled');
	});
	$('.page-settings-config #Upload_btn').click(function() {
		$('#settings-config_form .btn').addClass("disabled");
		$('#settings-config_form').submit();
	});
	$('#Upload_btn').click( function() {
		$('.panel-settings-update .panel-heading .interaction').addClass('hidden');
		$('.panel-settings-update .panel-heading .loading').removeClass('hidden');
		$('.panel-settings-update .panel-body.interaction').addClass('hidden');
		$('.panel-settings-update .panel-body.loading').removeClass('hidden');
		$('#settings-update_form').submit();
	});
	$('#UploadFTP_btn').click( function() {
		$('.panel-settings-update .panel-heading .interaction').addClass('hidden');
		$('.panel-settings-update .panel-heading .loading').removeClass('hidden');
		$('.panel-settings-update .panel-body.interaction').addClass('hidden');
		$('.panel-settings-update .panel-body.loading').removeClass('hidden');
		$('#settings-update_form').submit();
	});
	$('#AutomaticUpdate_btn').click( function() {
		// $('.panel-settings-update .panel-heading .interaction').addClass('hidden');
		// $('.panel-settings-update .panel-heading .loading').removeClass('hidden');
		// $('.panel-settings-update .panel-body.interaction').addClass('hidden');
		// $('.panel-settings-update .panel-body.loading').removeClass('hidden');
		$('.group-ManualUpdate button').attr("disabled", "disabled");
		$('#AutomaticUpdate_btn').button('loading');
		var falseTimer = $.timer(function() {
			$('.group-ManualUpdate button').removeAttr("disabled");
		$('#AutomaticUpdate_btn').button('reset');
			falseTimer.stop();
		});
		falseTimer.set({
			  time: 2500
			, autostart: true
		});
	});
	$('input').keypress(function(event) {
		if( event.which == 13 ) {
			event.preventDefault();
			if($('.page-overview').length > 0 && $('.page-login').length == 0 ) {
				$('#PIN_Entry_btn').click();
			} else {
				$('#Save_btn').click();
			}
		}
	});
	$('.page-test #themes_btn').change(function() {
		var xhr = $.ajax({
			  async: true
			, beforeSend: function() {
				// $(".page-settings-wlan .alert").alert('close');
			}
			, dataType: 'json'
			, data: {
				  'c': 'ChangeTheme'
				, 'theme': $('#themes_btn').val()
			}
			, type: 'POST'
			, url: 'ajaj.php'
		}).done(function(json) {
			// console.log(json.data.random);
			switch(json.status) {
				case "success":
					location.reload();
					break;
				case "error":
					break;
				default:
					break;
			}
		});
	});
	$('#pinchange_btn, #pininput_btn, #loadprofiles_btn').click(function() {
		$(this).button('loading');
		var command = "";
		if( $(this).attr('id') == 'pinchange_btn' ) {
			command = "pin-change";
		} else if( $(this).attr('id') == 'pininput_btn' ) {
			command = "pin-input";
		} else if( $(this).attr('id') == 'loadprofiles_btn' ) {
			command = "profile-select";
		}
		var xhr = $.ajax({
			data: {
				  c: "SetSessionVar"
				, key: "sim-setup"
				, value: command
			}
		}).done(function(json) {
			if( json.status == "success" ) {
				location.assign("./sim.php");
			}
		});
	});
	//~ $('#help-affix .sidenav').affix({
		//~ offset: {
			  //~ top: 100
			//~ , bottom: function () {
				//~ return (this.bottom = $('.footer').outerHeight(true))
			//~ }
		//~ }
	//~ });
	$('a[data-toggle="tab-content"]').on('shown.bs.tab', function (e) {
		//e.target // activated tab
		//e.relatedTarget // previous tab
		console.log(e.target);
		console.log(e.relatedTarget);
	})
});

//* ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *//

/*
 * Check Sim Status after PIN code is entered
 **/
function checkSIMStatus() {
	var timer = $.timer(function() {
		var xhr = $.ajax({
			  beforeSend: function(xhr) {
				timer.pause();
			}
			, dataType: 'json'
			, data: {
				  c: "CheckSIMStatus"
			}
		}).done(function(json) {
			if( json.status == "success" ) {
				timer.stop();
				$('#PIN_Entry_btn').button('reset');
			}
			timer.play();
		});
	});
	timer.set({
		  autostart: true
		, time: 1000
	});
}

/*
 * Make left and right panel heights equal
 * Always grow first panels on each side, except when
 * 'SIM setup' panel is active.
 **/
function equal_box_heights() {
	// v.scrn_size = findBootstrapEnvironment();
	if( $('.page-overview').length > 0 && $('.left-column .panel').length > 0 ) {
		v.viewport = findBootstrapEnvironment();
		if( v.viewport != 'xs' ) {
			v.box_heights = {
				  border_gaps: 0
				, dim_to_add: 0
				, internetbox_num: 0
				, left: 0
				, original: 0
				, right: 0
			};
			// v.box_heights.left_height = 0;
			// v.box_heights.right_height = 0;
			$('.left-column .panel').each(function() {
				v.box_heights.left = v.box_heights.left + $(this).height();
			});
			$('.right-column .panel').each(function() {
				v.box_heights.right = v.box_heights.right + $(this).height();
			});
			if( v.box_heights.left < v.box_heights.right ) {
				v.box_heights.dim_to_add = v.box_heights.right - v.box_heights.left;
				v.box_heights.border_gaps = ($('.right-column .panel').length - $('.left-column .panel').length) * 21;
				v.box_heights.internetbox_num = 0;
				if( $('.sim-setup-box').length > 0 ) {
					v.box_heights.internetbox_num++;
				}
				v.box_heights.original = $('.left-column .panel').eq(v.box_heights.internetbox_num).height();
				$('.left-column .panel').eq(v.box_heights.internetbox_num).height( v.box_heights.original + v.box_heights.dim_to_add + v.box_heights.border_gaps );
				// $('.left-column .panel').eq(0).height(right_height + (($('.right-column .panel').length - 1) * 21 ));
			} else if( v.box_heights.left > v.box_heights.right ) {
				v.box_heights.dim_to_add = v.box_heights.left - v.box_heights.right;
				v.box_heights.border_gaps = ($('.left-column .panel').length - $('.right-column .panel').length) * 21;
				v.box_heights.original = $('.right-column .panel').eq(0).height();
				$('.right-column .panel').eq(0).height( v.box_heights.original + v.box_heights.dim_to_add + v.box_heights.border_gaps );
			} else {
				// $('.left-column .panel').eq(0).height("auto");
				// $('.right-column .panel').eq(0).height("auto");
				// equal_box_heights();
			}
		} else {
			$.each($('.left-column .panel'), function( key, value ) {
				$(value).height("auto");
			});
			$.each($('.right-column .panel'), function( key, value ) {
				$(value).height("auto");
			});
			// $('.left-column .panel').eq(0).height("auto");
			// $('.right-column .panel').eq(0).height("auto");
		}
	}
}
/*
 *	This tool helps to determine which viewport we are in, currently.
 **/
function findBootstrapEnvironment() {
	var envs = ['xs', 'sm', 'md', 'lg'];

	$el = $('<div>');
	$el.appendTo($('body'));

	for (var i = envs.length - 1; i >= 0; i--) {
		var env = envs[i];

		$el.addClass('hidden-'+env);
		if ($el.is(':hidden')) {
			$el.remove();
			return env
		}
	};
}

/*
 * Load profiles
 **/
function InitProfileSelection() {
	$('#SimProfileEntryGroup .list-group .list-group-item').click(function( event ) {
		//~ event.preventDefault();
		if( !$(this).hasClass('disabled') ) {
			var simsetup = $('#sim-setup').val();
			$(this).addClass("active");
			var i = $(this).attr('id');
			var xhr = $.ajax({
				beforeSend: function() {
					$('#SimProfileEntryGroup .list-group .list-group-item').addClass("disabled");
					$('#sim-setup_form-'+simsetup+'_waiting').show();
					equal_box_heights();
				}
				, data: $('#simprofile'+i.substr(7)).serialize()
			}).done(function(json) {
				if( json.status == "success" ) {
					location.assign("./");
				}
			});
		}
	});
}

/*
 * This function does what its name says.
 **/
function ResetDataVolume() {
	$('#resetCounter_btn').button('loading');
	var date = new Date();
	var xhr = $.ajax({
		data: {
			  c: "ResetDataVolume"
			, date: date.toISOString()
		}
	}).done(function(json) {
		if( json.status == "success" ) {
			$('.internetResetDataVolume').text(json.data.date);
		}
		$('#resetCounter_btn').button('reset');
	});
}

/*
 * Display PIN entry
 **/
function showEnterPin() {
	$('#ShowEnterPin_btn').hide();
	$('.pin_form').show();
}

/*
 * Display PUK entry
 **/
function showEnterPuk() {
	$('#ShowEnterPuk_btn').hide();
	$('.puk_form').show();
}

/*
 * This a is a rather big PIN & Profile selection function
 * Good luck!
 **/
function SimSetup() {
	equal_box_heights();
	$('#Save_btn, #PIN_Entry_btn, #PUK_Entry_btn').button('loading');
	var simsetup = $('#sim-setup').val();
	var xhr = $.ajax({
		  beforeSend: function() {
			equal_box_heights();
			$(' \
				#sim-setup_form-'+simsetup+' btn, \
				#sim-setup_form-'+simsetup+' input').attr("disabled", "disabled");
			$('#sim-setup_form-'+simsetup+'_waiting').show();
			$('#sim-setup_form-'+simsetup+'_wrongpin').hide();
			$('#sim-setup_form-'+simsetup+'_wrongpuk').hide();
			equal_box_heights();
		}
		, data: $('#sim-setup_form-'+simsetup).serialize()
	}).done(function(json) {
		var simsetup = $('#sim-setup').val();
		$('#Save_btn, #PIN_Entry_btn, #PUK_Entry_btn').button('reset');
		$(' \
			#sim-setup_form-'+simsetup+' btn, \
			#sim-setup_form-'+simsetup+' input').removeAttr("disabled");
		$('#sim-setup_form-'+simsetup+'_waiting').hide();
		if( simsetup == "pin-input" ) {
			if( json.status == "success" && json.data.hasOwnProperty('sim_status') && json.data.sim_status.pin == "PIN_OK" ) {
				$('#sim-setup').val('profile-select');
				$('.page-sim-setup .panel-heading h3').text(json.i18n.newsimprofile_header);
				$('#SimPinEntryGroup').hide();
				$('.sim-setup-box .panel-footer').hide();
				var counter = 0;
				$(json.data.sim_status.profiles.providers).each(function( index, value ) {
					$( value.gsm.apns ).each(function( apn_index, apn_value ) {
						counter++;
// 						var item_heading = ( apn_value.name1 != null )? value.name+' - '+apn_value.name1 : value.name ;
// 						var apn_auth = ( apn_value.auth != null )? apn_value.auth : 'NONE' ;
// 						var apn_user = ( apn_value.user != null )? apn_value.user_name : '' ;
// 						var apn_pass = ( apn_value.pass != null )? apn_value.pass : '' ;
						$('#SimProfiles').append('\
							<li id="profile'+counter+'" class="list-group-item"> \
								<h4 class="list-group-item-heading">'+ ( ( apn_value.name1 != null )? value.name+' - '+apn_value.name1 : value.name ) +'</h4> \
								<p class="list-group-item-text">APN: '+apn_value.apn+'</p> \
							</li> \
						');
						$('#SimProfileEntryGroup').append('\
							<form id="simprofile'+counter+'" name="simprofile'+counter+'" class="" role="form" autocomplete="off"> \
								<input type="hidden" name="c" value="PINProfile" /> \
								<input type="hidden" name="iccid" value="'+json.data.sim_status.iccid+'" /> \
								<input type="hidden" name="internet_profile" value="'+apn_value.plan1+'" /> \
								<input type="hidden" name="apn" value="'+apn_value.apn+'" /> \
								<input type="hidden" name="authentication" value="'+	((apn_value.auth)? apn_value.auth			: 'NONE') +'" /> \
								<input type="hidden" name="user_name" value="'+		((apn_value.username)? apn_value.username	: '' ) +'" /> \
								<input type="hidden" name="user_pass" value="'+		((apn_value.password)? apn_value.password	: '' ) +'" /> \
								<input type="hidden" name="dns1" value="'+				((apn_value.dns1)? apn_value.dns1			: '' ) +'" /> \
								<input type="hidden" name="dns2" value="'+				((apn_value.dns2)? apn_value.dns2			: '' ) +'" /> \
							</form> \
						');
					});
					$(' \
						.page-overview .form-group .form-control, \
						.page-overview .form-group input[type=checkbox], \
						.page-overview .form-group .custom-btn-group label, \
						.page-overview .form-group .custom-option .btn.dropdown-toggle, \
						#Cancel_btn').removeAttr("disabled");
				});
				$('#SimProfileEntryGroup').show();
				$('.page-sim-setup .panel-footer').hide();
				InitProfileSelection();
				equal_box_heights();
			} else if( json.status == "error" && json.data.hasOwnProperty('sim_status') ) {
				if( json.data.sim_status.pin == "PIN_NEEDED" ) {
					$('.sim_attempts').text(json.data.sim_status.attempts);
					$('.puk_attempts').text(json.data.sim_status.attempts);
					$('#sim-setup_form-pin-input_wrongpin').show();
					$('#PIN_input').parents('.form-group').addClass('has-error');
				} else if( json.data.sim_status.pin == "PUK_NEEDED" ) {
					$('#sim-setup').val('puk-input');
					$('#SimPinEntryGroup').hide();
					$('#SimPukEntryGroup').show();
					$('.sim_attempts').text(json.data.sim_status.attempts);
					$('.puk_attempts').text(json.data.sim_status.attempts);
					if( $('.page-overview').length > 0 ) {
						$('#ShowEnterPuk_btn').click();
						$('.sim_attempts').text(10);
						$('.puk_attempts').text(10);
					}
				}
			}
		} else if( simsetup == "profile-select" ) {
			if( json.status == "success" ) {
				location.assign("./");
			}
		} else if( simsetup == "puk-input" ) {
			if( json.status == "success" && json.data.hasOwnProperty('sim_status') && json.data.sim_status.pin == "PIN_OK" ) {
				$('#sim-setup').val('profile-select');
				$('.page-sim-setup .panel-heading h3').text(json.i18n.newsimprofile_header);
				$('#SimPukEntryGroup').hide();
				var counter = 0;
				$(json.data.sim_status.profiles.providers).each(function( index, value ) {
					$( value.gsm.apns ).each(function( apn_index, apn_value ) {
						counter++;
// 						var item_heading = ( apn_value.name1 != null )? value.name+' - '+apn_value.name1 : value.name ;
// 						var apn_auth = ( apn_value.auth != null )? apn_value.auth : 'NONE' ;
// 						var apn_user = ( apn_value.user != null )? apn_value.user : '' ;
// 						var apn_pass = ( apn_value.pass != null )? apn_value.pass : '' ;
						$('#SimProfiles').append('\
							<li id="profile'+counter+'" class="list-group-item"> \
								<h4 class="list-group-item-heading">'+ ( ( apn_value.name1 != null )? value.name+' - '+apn_value.name1 : value.name ) +'</h4> \
								<p class="list-group-item-text">APN: '+apn_value.apn+'</p> \
							</li> \
						');
						$('#SimProfileEntryGroup').append('\
							<form id="simprofile'+counter+'" name="simprofile'+counter+'" class="" role="form" autocomplete="off"> \
								<input type="hidden" name="c" value="PINProfile" /> \
								<input type="hidden" name="iccid" value="'+json.data.sim_status.iccid+'" /> \
								<input type="hidden" name="internet_profile" value="'+apn_value.plan1+'" /> \
								<input type="hidden" name="apn" value="'+apn_value.apn+'" /> \
								<input type="hidden" name="authentication" value="'+	((apn_value.auth)? apn_value.auth			: 'NONE') +'" /> \
								<input type="hidden" name="user_name" value="'+		((apn_value.username)? apn_value.username	: '' ) +'" /> \
								<input type="hidden" name="user_pass" value="'+		((apn_value.password)? apn_value.password	: '' ) +'" /> \
								<input type="hidden" name="dns1" value="'+				((apn_value.dns1)? apn_value.dns1			: '' ) +'" /> \
								<input type="hidden" name="dns2" value="'+				((apn_value.dns2)? apn_value.dns2			: '' ) +'" /> \
							</form> \
						');
					});
				});
				$('#SimProfileEntryGroup').show();
				$('.page-sim-setup .panel-footer').hide();
				InitProfileSelection();
				equal_box_heights();
			} else if( json.status == "error" && json.data.hasOwnProperty('sim_status') ) {
				if( json.data.sim_status.pin == "PUK_NEEDED" ) {
					$('.puk_attempts').text(json.data.sim_status.attempts);
					$('.sim_attempts').text(json.data.sim_status.attempts);
					$('#sim-setup_form-puk-input_wrongpuk').show();
					$('#PUK_input').parents('.form-group').addClass('has-error');
				}
			}
		}
		if( json.status == "error" && json.hasOwnProperty('msg') && json.msg == "validation error" ) {
			$.each(json.data, function( key, value ) {
				//~ console.log( key + " " + value);
				$('#'+key).parents('.form-group').addClass('has-error');
			});
		}
		equal_box_heights();
	});
}

/*
 * Toggles Internet connection
 **/
function ToggleConnection() {
	var xhr = $.ajax({
		data: {
			c: "ToggleConnection"
		}
	}).done(function(json) {
		if( json.status == "success" ) {
			location.reload();
		}
	});
}
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
function RevertWUIPages() {
	$('#wui_revert').button('loading');
	var xhr = $.ajax({
		data: {
			  c: "RevertWUIPages"
		}
	}).done(function(json) {
		$('#wui_revert').button('reset');
	});
}

function ClearWUICache() {
	$('#wui_cache').button('loading');
	var xhr = $.ajax({
		data: {
			  c: "ClearWUICache"
		}
	}).done(function(json) {
		$('#wui_cache').button('reset');
	});
}
