<?php
/*
 * Initilaization for every php page.
 * This is a must have.
 *
 * $Revision: 4287 $
 * $Author: PENET\roncsak $
 * $Date: 2014-07-01 16:04:38 +0200 (Tue, 01 Jul 2014) $
 *
 **/

// In production
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
define('SMARTY_DIR', 'smarty/');
define('WWW_ROOT', dirname(__FILE__).'/');
define('WWW_TMP', '/tmp/smarty/');
define('SMARTY_COMPILE_CHECK', false);
define('SERVICE_PROVIDERS', 'serviceproviders.xml');

// NOTE: Smarty has a capital 'S'
require_once(SMARTY_DIR . 'Smarty.class.php');
// require_once(ADODB_DIR . 'adodb.inc.php');
$smarty = new Smarty();
$smarty->config_overwrite=false;
$smarty->template_dir	= WWW_ROOT	. 'templates/';
$smarty->compile_dir	= WWW_TMP	. 'compile/';
$smarty->setConfigDir(array(
	  'general' => WWW_ROOT	. 'configs/'
	, 'i18n'	=> WWW_ROOT	. 'configs/i18n/'
));
//var_dump($smarty->getConfigDir());
$smarty->cache_dir		= WWW_TMP	. 'cache/';

if( !is_dir($smarty->getCompileDir()) ) mkdir($smarty->getCompileDir(), 0777, true);
if( !is_dir($smarty->getCacheDir())   ) mkdir($smarty->getCacheDir(),   0777, true);
//if( !is_dir(SMS_SEND_PATH)			  ) mkdir(SMS_SEND_PATH,			0777, true);

$smarty->php_handling	= Smarty::PHP_ALLOW; /*TODO turn off when done developing*/

/*
 * If $compile_check is enabled (default), every template file and config
 * file that is involved with the cache file is checked for modification.
 * If any of the files have been modified since the cache was generated,
 * the cache is immediately regenerated. This is a computational overhead,
 * so for optimum performance set $compile_check to FALSE.
 * */
$smarty->setCompileCheck(SMARTY_COMPILE_CHECK);

ini_set('display_errors', true);
error_reporting(E_ALL + E_NOTICE);

$http = $_REQUEST;

session_start();
if( empty($_SESSION['connection']) ) {
	$_SESSION['connection'] = 0;
}

date_default_timezone_set( "Europe/Berlin" );

/*
 * 
 * Custom plugins written to Smarty
 * 
 * */

/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
$smarty->registerPlugin("function","html_maskedinput", "print_masked_input");
$smarty->registerPlugin("modifier","pretty_bytes", "auto_byte_convert");
$smarty->registerPlugin("function","html_maskedinput_ftp", "print_masked_input_ftp");

function auto_byte_convert($byte, $precision = 2, $nounit = false) {
	$units = array(
		  'B'
		, 'KB'
		, 'MB'
		, 'GB'
		, 'TB'
	);
	if( empty($byte) ) {
		$byte = 0;
		return $byte." ".$units[0];
	} else {
		$pow = floor(log($byte)/log(1024));
		$pow = min($pow, count($units)-1);
		$byte /= pow(1024, $pow);
		return round($byte, $precision)." ".$units[$pow];
	}
}
function print_masked_input($params, $smarty) {
	if( !empty($params["content"]) ) {
		$content = $params["content"];
	} else {
		$content = "button";
	}
	if( !empty($params["name"]) ) {
		$name = $params["name"];
	} else {
		$name = "file_upload";
	}
	if( !empty($params["accept"]) ) {
		$accept = $params["accept"];
	} else {
		$accept = "";
	}
	if( !empty($params["class"]) ) {
		$class = $params["class"];
	} else {
		$class = "btn btn-default fileuploadMask_btn";
	}
	if( !empty($params["disabled"]) ) {
		$disabled = 'disabled="disabled"';
	} else {
		$disabled = "";
	}
	if( !empty($params["changed-text"]) ) {
		$data = 'data-changed-text="'.$params["changed-text"].'"';
	} else {
		$data = "";
	}
	$html = '<input type="file" name="'.$name.'" class="fileupload_btn" data-changed-text="{#global_uploadchosenbutton_label#}" style="display:none;" accept="'.$accept.'">';
	$html.= '<button type="button" class="'.$class.'" '.$disabled.' '.$data.'>'.$content.'</button>';
	return $html;
}
function print_masked_input_ftp($params, $smarty) {
	if( !empty($params["content"]) ) {
		$content = $params["content"];
	} else {
		$content = "button";
	}
	if( !empty($params["name"]) ) {
		$name = $params["name"];
	} else {
		$name = "file_upload_ftp";
	}
	if( !empty($params["accept"]) ) {
		$accept = $params["accept"];
	} else {
		$accept = "*";
	}
	if( !empty($params["class"]) ) {
		$class = $params["class"];
	} else {
		$class = "btn btn-default fileuploadMask_btn";
	}
	if( !empty($params["disabled"]) ) {
		$disabled = 'disabled="disabled"';
	} else {
		$disabled = "";
	}
	if( !empty($params["changed-text"]) ) {
		$data = 'data-changed-text="'.$params["changed-text"].'"';
	} else {
		$data = "";
	}
	$html = '<input type="file" name="'.$name.'" class="fileupload_btn" data-changed-text="{#global_uploadchosenbutton_label#}" style="display:none;" accept="'.$accept.'">';
	$html.= '<button type="button" class="'.$class.'" '.$disabled.' '.$data.'>'.$content.'</button>';
	return $html;
}
?>
