<?php
ini_set('display_errors', true);
error_reporting(E_ALL + E_NOTICE);

class InputValidator {
	
	private $fields = array();
	
	private $lastField = "";
	
	private $valid = true;
	
	private $output;
    
	public function __construct() { }
	
	private function addRule($ruleName) {
		
	}
	
	public function addField($fieldName, $val) {
		$this->lastfield = $fieldName;
		$this->fields[$fieldName] = array('value' => $val);
		
		return $this;
	}

	public function ascii() {
		$this->fields[$this->lastfield]['ruleset']['ascii'] = true;
		return $this;
	}
// U_M39G_MV-2251
	public function UblxHEX() {
		$this->fields[$this->lastfield]['ruleset']['UblxHEX'] = true;
		return $this;
	}
	public function UblxASCII() {
		$this->fields[$this->lastfield]['ruleset']['UblxHEX'] = true;
		return $this;
	}
	public function md5( $with = false) {
		if( $with != false ) {
			$this->fields[$this->lastfield]['ruleset']['md5'] = $with;
		}
		return $this;
	}
	public function max( $max = false ) {
		$this->fields[$this->lastfield]['ruleset']['max'] = $max;
		return $this;
	}
	public function min( $min = false ) {
		$this->fields[$this->lastfield]['ruleset']['min'] = $min;
		return $this;
	}
	public function number( ) {
		$this->fields[$this->lastfield]['ruleset']['number'] = $with;
		return $this;
	}
	public function required() {
		$this->fields[$this->lastfield]['ruleset']['required'] = true;
		return $this;
	}
	public function requiredIf( $condition = false ) {
		$this->fields[$this->lastfield]['ruleset']['requiredIf'] = $condition;
		return $this;
	}
	
	public function maxLength( $max = false ) {
		if( $max != false && is_int($max) ) {
			$this->fields[$this->lastfield]['ruleset']['maxLength'] = $max;
		}
		return $this;
	}
	public function minLength( $min = false ) {
		if( $min != false && is_int($min) ) {
			$this->fields[$this->lastfield]['ruleset']['minLength'] = $min;
		}
		return $this;
	}
	public function email() {
		$this->fields[$this->lastfield]['ruleset']['email'] = true;
		return $this;
	}
	public function phone() {
		$this->fields[$this->lastfield]['ruleset']['phone'] = true;
		return $this;
	}
	public function equals( $with = "" ) {
		$this->fields[$this->lastfield]['ruleset']['equals'] = $with;
		return $this;
	}
	public function equalsIf( $with = "", $condition = false ) {
		$this->fields[$this->lastfield]['ruleset']['equalsIf'] = array( "with" => $with, "condition" => $condition );
		return $this;
	}
	public function ip() {
		$this->fields[$this->lastfield]['ruleset']['ip'] = true;
		return $this;
	}
// U_M39G_MV-2251
	public function UblxWEPHEXLength() {
		$this->fields[$this->lastfield]['ruleset']['UblxWEPHEXLength'] = true;
		return $this;
	}
	public function UblxWEPASCIILength() {
		$this->fields[$this->lastfield]['ruleset']['UblxWEPASCIILength'] = true;
		return $this;
	}
	public function run() {
		foreach( $this->fields as $key => $arr ) {
			$this->lastfield = $key;
			$value = $this->fields[$key]['value'];
			$rules = $this->fields[$key]['ruleset'];
			foreach($rules as $ruleName => $rule) {
				if( method_exists('InputValidator', 'validate_'.$ruleName) ) {
					call_user_func('InputValidator::validate_'.$ruleName, $value, $rule);
				}
			}
		}
		return $this->valid;
	}
	public function getErrors() {
		$ret = array();
		foreach( $this->output as $field => $rules ) {
			foreach( $rules as $rule => $valid ) {
				if( $valid == 0 ) {
					$ret[$field][] = $rule;
				}
			}
		}
		return $ret;
	}
	public function getResults() {
		return $this->output;
	}
	protected function validate_ascii( $val ) {
		$valid = 1;
		for($i=0; $i<strlen($val); $i++) {
			if(ord($val[$i]) < 32 || ord($val[$i]) > 126 ) {
				$valid = 0;
				break;
			}
		}
		$this->output[$this->lastfield]['ascii'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
// U_M39G_MV-2251
	protected function validate_UblxHEX( $val ) {
		$valid = 1;
		for($i=0; $i<strlen($val); $i++) {
			if ( ! ( ( (ord($val[$i]) >= 65) && ( ord($val[$i]) <= 70 ) ) || 
					( (ord($val[$i]) >= 97 ) && ( ord($val[$i]) <= 102 ) ) || 
					( (ord($val[$i]) >= 48 ) && ( ord($val[$i]) <= 57 ) ) ) )
			{
				$valid = 0;
				break;
			}
		}
		$this->output[$this->lastfield]['UblxHEX'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_UblxASCII( $val ) {
		$valid = 1;
		for($i=0; $i<strlen($val); $i++) {
			if ( ! ( ( (ord($val[$i]) >= 35) && ( ord($val[$i]) <= 38 ) ) || 
					( (ord($val[$i]) >= 40 ) && ( ord($val[$i]) <= 95 ) ) || 
					( (ord($val[$i]) >= 97 ) && ( ord($val[$i]) <= 126 ) ) || 
					(ord($val[$i]) == 33 ) ) )
			{
				$valid = 0;
				break;
			}
		}
		$this->output[$this->lastfield]['UblxASCII'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_md5( $val, $with ) {
		if( md5($val) === $with ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['md5'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_email( $val ) {
		if( empty($val) || filter_var($val, FILTER_VALIDATE_EMAIL) ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['email'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_phone( $val ) {
		$regexp = "/^\+?\d+$/s";
		if( empty($val) || filter_var($val, FILTER_VALIDATE_REGEXP, array("options"=>array("regexp"=>$regexp))) ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['phone'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_equals( $val, $with ) {
		if( $val === $with ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['equals'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_equalsIf( $val, $mixed ) {
		$with = $mixed["with"];
		$condition = $mixed["condition"];
		if( !$condition || $val == $with || in_array($val, $with) ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['equalsIf'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_ip( $val ) {
		if( empty($val) || filter_var($val, FILTER_VALIDATE_IP) ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['ip'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_maxLength( $val, $max ) {
		if( strlen($val) > $max ) {
			$valid = 0;
		} else {
			$valid = 1;
		}
		$this->output[$this->lastfield]['maxLength'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_max( $val, $max ) {
		if( empty($val) || (int) $val <= $max ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['max'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_min( $val, $min ) {
		if( empty($val) || (int) $val >= $min ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['min'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_number( $val ) {
		if( empty($val) || preg_match("/[0-9]/", $val) ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['number'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_minLength( $val, $min ) {
		if( strlen($val) < $min ) {
			$valid = 0;
		} else {
			$valid = 1;
		}
		$this->output[$this->lastfield]['minLength'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_required( $val ) {
		if( empty($val) ) {
			$valid = 0;
		} else {
			$valid = 1;
		}
		$this->output[$this->lastfield]['required'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_requiredIf( $val, $condition ) {
		if( $condition && empty($val) ) {
			$valid = 0;
		} else {
			$valid = 1;
		}
		$this->output[$this->lastfield]['requiredIf'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
// U_M39G_MV-2251
	protected function validate_UblxWEPHEXLength( $val ) {
		if ( ( strlen($val)  == 10 ) || ( strlen($val)  == 26 ) ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['UblxWEPHEXLength'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
	protected function validate_UblxWEPASCIILength( $val ) {
		if ( ( strlen($val)  == 5 ) || ( strlen($val)  == 13 ) ) {
			$valid = 1;
		} else {
			$valid = 0;
		}
		$this->output[$this->lastfield]['UblxWEPASCIILength'] = $valid;
		$this->valid = ($this->valid == 1)? $valid : $this->valid;
	}
}
// M39G_MV_2-1296
//~ $v = new InputValidator();
//~ $v->addField('password', "u-blox")
		//~ ->required()
		//~ ->minLength(5)
		//~ ->equals("");
//~ if( $v->run() ) {
	//~ print "valid";
//~ } else {
	//~ print "invalid";
//~ }
		//~ print "<pre>";
		//~ print_r( $v->getResults() );
		//~ print "</pre>";
?>
