#!/bin/sh
TEMP_DIR=/mrvlsys
awk 'BEGIN{print "[/proc/cmdline]"};{for (i=1;i<=NF;i++){if ($i ~ /=/){print $i;}else{print $i "=1";}}}
' /proc/cmdline > ${TEMP_DIR}/cmdline

MTILATCMD_EXT_LIBS=

####################
# Production mode  #
####################


# All TEL applications have private but same SIGn-handler
# The Pthread SIG is running under disable-IRQ and takes a lot of time
# but we have specual monitor going to Kpanic when limit exceeded.
# To avoid Kpanic inside of TEL-SIG handler expand the limit-time
# We need permissions to do this
chmod 0660 /sys/devices/system/cpu/cpu0/timer_irq_latency

cd /marvell/tel

if [ -e /dev/rdr ]; then
# RAMDUMP is prepared by U-boot in RAM
#  ABORT further init and call for upload (ended by reboot)
./ramdump_upload.sh
exit 0
fi

# U_M39G_MV-2256
##### Lesswire modifications #####
WIFI_ENABLE=`grep "WIFI=1" /proc/cmdline | wc -l`
##### Lesswire modifications #####


i=`grep -c "PROD=1,2" /proc/cmdline`
if [ $i == '1' ]; then
	if [ "$1" != "I_respawned" ]; then
		echo "START PRODUCTION OVER UART" > /dev/ttyS0
		# respawn myself with output redirection
		# cat /proc/kmsg >> /data/dump_production_log &
		# echo "==== respawn /marvell/tel/run_android_bsp_only.sh ====" > /dev/ttyS0
		cd /marvell/tel
		./busybox sh ./run_eshel_bsp_only.sh I_respawned $* 1>/dev/kmsg 2>&1
		exit $?
	else
		echo StartLogging >> /data/dump_production_log
	fi
fi

#U_M39G_MV-2717
# In order to force the restore of the *CharData.nvm files in the prop_cfg.sh script,
# the property persist.sys.ublx_chf_fct_init should be reverted
setprop persist.sys.ublx_chf_fct_init ""
# configure properties and COM symlinks - MUST BE BEFORE RELEASE COMM FROM RESET!!!
/system/marvell/tel/prop_cfg.sh

# Release COMM from reset
# (used when power support is not available) ./hwacc w 0x40F5001C   1
chmod 774 /sys/power/cp
echo 1 > /sys/power/cp

# Set error log location to /data volume, default is NVM
# Should be before mtsd starts as diag should be able to override the setting
echo "/data/log" > ${TEMP_DIR}/diag_log_path

busybox sh diag_port_conf.sh
port=`cat ${TEMP_DIR}/at_port.txt`
#disable DVFM and LPM
echo 0 > /sys/power/mspm/mspm
echo 0 > /sys/power/mspm/prof
echo disable > /sys/devices/platform/pxa2xx-uart.0/set_uart2gpio

insmod seh.ko
insmod acipcdev.ko
insmod ci_data_drv.ko
insmod citty.ko
insmod ccinetdev.ko
insmod cidatatty.ko

#U_M39G_MV-1306
if [ -f /marvell/tel/ublx_ugpio.ko ]; then
	insmod /marvell/tel/ublx_ugpio.ko
fi
#U_M39G_MV-1369
if [ -f /marvell/tel/ublx_adet.ko ]; then
  insmod /marvell/tel/ublx_adet.ko
fi

# init WTPSP command
insmod /marvell/tel/wtpsp.ko
mknod /dev/wtm c 150 0

# create link for Modem
ln -s /dev/ttyGS0 /dev/ttymodem
#insmod ppp.ko
chmod 664 /sys/class/android_usb/android0/*

chmod 777 /dbg /dbg/*

# setup NW configuration
busybox ifconfig usb0 192.168.1.1 netmask 255.255.255.0 up
busybox ifconfig lo 127.0.0.1

busybox ln -s /dev/ttyDIAG0 /dev/ttygserial

#################################################
# start User mode part.
# do not put ANY user mode before this line.
#################################################

i=`grep -c "PROD=1,3" /proc/cmdline`
## run dbg macro handler
##./dbg_macro_util &
#This proccess enables DIAG and must be before
#mtilatcmd (mtsd - MTIl Server, mtilatcmd - MTIL client)
./mtsd &

#U_M39G_MV-880
# must run before any client
if [ -f "./run_oem_proxy.sh" ] ; then
	"./run_oem_proxy.sh" &
fi
#U_M39G_MV-880

if [ $i == '0' ]; then
	if [ "$port" == "UART" ]; then
		# Production over UART
		#Set AT and Diag over UART
		./mtilatcmd -u 1 $MTILATCMD_EXT_LIBS &
		./mtilatcmd $MTILATCMD_EXT_LIBS &
	else
		# Production over USB
		# set USB default configuration for production (not persistent)
		setprop sys.usb.config "rndis,acm_at_0,debug_acm,diag,acm_wifi_cal"
		#Set AT and Diag over USB
		#U_M39G_MV-1031
		./mtilatcmd -m /dev/ttymodem $MTILATCMD_EXT_LIBS &
		#U_M39G_MV-1264
		./mtilatcmd $MTILATCMD_EXT_LIBS &
		#WiFi calibration
		j=`ml_ini -r -f /mrvlsys/cmdline -s /proc/cmdline -k MIFI`
		if [ $j == '1' ]; then
		#load mlan.ko and sd8xxx.ko for WiFi calibration
			/usr/app/wifi_calib.sh
		fi
	./eeh -D yes -M yes &
	fi
else
	# L1 mode
	# set USB L1 configuration for production (not persistent)
	setprop sys.usb.config "diag,debug"
	## run hwacc
	insmod hwmap.ko
	./eeh -M 2 -a 1 -A 1 &
fi

# MIM ./audioserver -D yes&

#  U_M39G_MV-2256 TOBY_L200_50S-139
if [ $WIFI_ENABLE = '1' ]; then
	/system/marvell/tel/run_wifi.sh init_bsp_only
fi

