#!/bin/sh

CmdLine="/proc/cmdline"

myself=${0##*/}
TEMP_DIR=/mrvlsys
NVM_DIR=/NVM
VZWCM_FILE=${NVM_DIR}/run_vzwcm
RB_FILE=${NVM_DIR}/run_rb

MTILATCMD_EXT_LIBS=
#MTILATCMD_EXT_LIBS="-e libublxat.so" #Not used anymore

#U_M39G_MV-527
TRACE_STOP=`getprop sys.trace.state | grep -c "stopped"`
TRACE_FS_START=`getprop sys.trace.state | grep -c "fs"`
TRACE_SDCARD_START=`getprop sys.trace.state | grep -c "sdcard"`
TRACE_UART_START=`getprop sys.trace.state | grep -c "uart"`
TRACE_USB_START=`getprop sys.trace.state | grep -c "usb"`
TRACE_TCP_START=`getprop sys.trace.state | grep -c "tcp"`

#Updating boot sequence number
[ -f ${NVM_DIR}/ml_boot_seq.txt ] &&
	a=`awk ' {a=$1+1;};END{print a}' ${NVM_DIR}/ml_boot_seq.txt` ||
	a=1;
echo $a > ${NVM_DIR}/ml_boot_seq.txt

awk 'BEGIN{print "[/proc/cmdline]"};{for (i=1;i<=NF;i++){if ($i ~ /=/){print $i;}else{print $i "=1";}}}
' $CmdLine > ${TEMP_DIR}/cmdline

# Open for debug
#echo 7 > /proc/sys/kernel/printk
#U_M39G_MV-2977 AT+UFACTORY Implementation
/system/marvell/tel/ublx_factory.sh
cd /marvell/tel

#set cp_sr_enable silent reset enable
cp_sr_enable=`ml_ini -r -f /mrvlsys/cmdline -s /proc/cmdline -k CPSR -v 0`

#backup rw image of cp, rf and dsp.
if [ $cp_sr_enable == '1' ]; then
	/marvell/tel/cp_sr_backup.sh
fi

# configure properties and COM symlinks - MUST BE BEFORE RELEASE COMM FROM RESET!!!
/system/marvell/tel/prop_cfg.sh

# Release COMM from reset
# (used when power support is not available) ./hwacc w 0x40F5001C   1
chmod 774 /sys/power/cp
echo 1 > /sys/power/cp

# Keep suplementary group root for accessing /sys files
mrvlacc="system system root"

# Set error log location to /data volume, default is NVM
# Should be before mtsd starts as diag should be able to override the setting

ml_setid $mrvlacc -- sh -c "echo /dbg/log > ${TEMP_DIR}/diag_log_path"

echo disable > /sys/devices/platform/pxa2xx-uart.0/set_uart2gpio

insmod seh.ko
insmod acipcdev.ko
insmod ci_data_drv.ko
# U_M39G_MV-2565
insmod hwmap.ko
#sleep 1
insmod citty.ko
insmod ccinetdev.ko
insmod cidatatty.ko
#U_M39G_MV-52
if [ -f /marvell/tel/ublx_ugpio.ko ]; then
  insmod /marvell/tel/ublx_ugpio.ko
fi
#U_M39G_MV-342
if [ -f /marvell/tel/ublx_adet.ko ]; then
  insmod /marvell/tel/ublx_adet.ko
fi
# U_M39G_MV-2232 U_M39G_MV-1181
if [ -f /marvell/tel/ublx_sts.ko ]; then
  insmod /marvell/tel/ublx_sts.ko
fi

#U_M39G_MV-275
#exported from prop_cfg.sh
if [ "$TOBY_MPCI" == "1" ]; then
  #cat mpci default gpio conf file
else
  #cat toby default gpio conf file
fi

#cat user gpio and sd card conf file

#U_M39G_MV-275

# U_M39G_MV-320
RADIO_ENABLE=`getprop persist.sys.ublx_radio_enable`
# at the first boot after the flash set the parameter to 1
if [ -z "$RADIO_ENABLE" ]; then
setprop persist.sys.ublx_radio_enable 1
echo "uplink_user_data_plane_enable: set to 1" >> /dev/kmsg
fi
# at further reboots turn off the radio if specified by the previous setting 
if [ "$RADIO_ENABLE" = "0" ]; then
echo -cd > /dev/ci_data_drv
setprop persist.sys.ublx_radio_enable 0
echo "uplink_user_data_plane_enable: set to 0" >> /dev/kmsg
fi
# U_M39G_MV-320 end

PROD=`grep -c "PROD=1" $CmdLine`
UARTCFG=`getprop persist.sys.ublx_uart`

UPSV_MODE=`getprop persist.upsv.mode`
UPSV_TIMEOUT=`getprop persist.upsv.timeout`
echo m=$UPSV_MODE t=$UPSV_TIMEOUT > /sys/devices/platform/pxa2xx-uart.0/upsv

# create link for Modem
ln -s /dev/ttyGS0 /dev/ttymodem
insmod ppp.ko
# U_M39G_MV-1017 U_M39G_MV-2896 PPP_trace disabled by default and enabled at will
PPP_TRACE_ENABLE=`getprop persist.sys.trace.PPP 0`
if [ "$PPP_TRACE_ENABLE" = "0" ]; then
  echo 0 > /proc/PPP_trace
else
  echo 1 > /proc/PPP_trace
fi

chmod 777 /dbg /dbg/*

# enable read/write from USB proc
chmod 674 /sys/class/android_usb/android0/* # U_M39G_MV-445 Permits MTIL server to disable USB during HALT
#chmod 664 /sys/class/android_usb/android0/*

if [ -e /dev/rdr ]; then
	# RAMDUMP is prepared by U-boot in RAM
	#  ABORT further init and call for upload (ended by reboot)
	./ramdump_upload.sh
exit 0
fi

# setup NW configuretion
./busybox sh /marvell/tel/run_nw_conf.sh

./busybox ifconfig lo 127.0.0.1

# sleep 1 sec before starting user mode applications
#sleep 1
#################################################
# start User mode part.
# do not put ANY user mode before this line.
#################################################

ML_HAWK_ID=`ml_ini -r -f /mrvlsys/cmdline -s /proc/cmdline -k HAWK -v 0`
ML_BOARD_ID=`ml_ini -r -f /mrvlsys/cmdline -s /proc/cmdline -k BOAR -v 00`
eeh_log_level="-M 1"
if [ $ML_HAWK_ID = '1' ]; then
	# "c4" is hamilton UT board and "ca" is mPCI omer board - Both connected to tablet
	# thus we run it in ADB mode
	if [ $ML_BOARD_ID = "c4" -o $ML_BOARD_ID = "ca" ]; then
		./hawk -t adb &
	else
		./hawk -t standalone &
	fi
	rm /dbg/log/Log000/log*.sdl
	cp ${NVM_DIR}/diag_fs.cfg /dbg/log
	cp $NVM_DIR/diag_bsp_hawk.cfg $TEMP_DIR/diag_bsp.cfg
	if [ "$cp_sr_enable" == "1" ]; then
		#M 2 in CP-SR save full comm-DDR but don't save LogStream
		#M 3 in CP-SR always everything just like non-CP-SR case
		eeh_log_level="-M 3"
	fi
fi
# Every new message in DMESG will be copied into DMESG_trace file.
cat /proc/kmsg >> /tmp/DMESG_trace &	#U_M39G_MV-742
#empty file creation for MtilServer (need to be root to do so in /tmp)
touch /tmp/UBLX_trace
touch /tmp/RDtemp.txt

# U_M39G_MV-2742
./root_server &

# VZio: OTA-DM temporary file creation. it is used inside 
# \src\vendor\marvell\generic\telephony\rb_omadm\PL\linux_comm\linux\vdm_comm_pl_conn.c
# the value is stored in RB_IFCONFIG_RESULT_FILE in the file above
touch /tmp/rb_ifconfig.txt

#U_M39G_MV-2580 - Persists the usecmng after FW update
mkdir /cache/usecmng
ln -s /cache/usecmng /data/userfs/usecmng
#end U_M39G_MV-2580

#U_M39G_MV-1068
UBLOX_MTIL_UDP_ENABLE=`getprop persist.sys.ublx_mtil_udp`

if [ "$UBLOX_MTIL_UDP_ENABLE" == "1" ]; then
	./mtsd --secure --udp &
else
	./mtsd --secure &
fi
#U_M39G_MV-1068

# wait for Diag, CCI registartion befor running any mtil clients
#sleep 1


#U_M39G_MV-880
# must run before any client
if [ -f "./run_oem_proxy.sh" ] ; then
	"./run_oem_proxy.sh" &
fi
#U_M39G_MV-880

#BIP client enabled (the same for all certifications), iproute shall be disabled
#U_M39G_MV-2542 Always start BIP client
if [ -f "./run_bip_client.sh" ] ; then
	"./run_bip_client.sh" &
fi
#U_M39G_MV-2542 

# U_M39G_MV-2887
# This MtilClient has been removed, since it is not used
#./mtilatcmd -S $MTILATCMD_EXT_LIBS &

# run mtil client for APX service
MIFI_ENABLE=`grep "MIFI=1" $CmdLine |wc -l`
DATACARD_ENABLE=`grep "SYCG=3" $CmdLine|grep "IPTM=5"|wc -l`
if [ $MIFI_ENABLE = '1' -o $DATACARD_ENABLE = '1' ]; then
./mtilatcmd -S -s /dev/cctdev2 $MTILATCMD_EXT_LIBS &
fi

#number of silent reset, if cp_sr_enable =1
#it will confige 17 silent reset
if [ $cp_sr_enable == '1' ]; then
	ml_setid $mrvlacc -- sh -c "echo 17 > $NVM_ROOT_DIR/eeh_cp_sr.cfg"
else
	ml_setid $mrvlacc -- sh -c "echo 0 > $NVM_ROOT_DIR/eeh_cp_sr.cfg"
fi

# MIM ./audioserver -D yes&

# U_M39G_MV-1139 - Check for JTAG external debugger and avoid COMM crash after stop/start system desync
# You need to power on the XDB debugger, connect JTAG, power on the target and
# start the JTAG script once after at least a couple of seconds but within Marvell Scalable Power/Performance Manager activation (30 seconds max).
# Then you need to "Restart" the debugger script so you will be ready to debug, since PJ4_DEBUG_STAT is updated at reset.
JTAG_TEST_STR=$(devmem 0x581100A8 32) # Read PJ4_DEBUG_STAT
JTAG_TEST=`echo $JTAG_TEST_STR | cut -c ${#JTAG_TEST_STR}` # Take the last character
if [ $JTAG_TEST == '1' ]; then
  if [ -f /sys/devices/system/cpu/cpu0/timer_irq_latency ]; then # If not already disabled at compile time by setting CONFIG_PXA_TIMER_IRQ_MAX_LATENCY=0 in pxa1801ublox_defconfig
    chmod 0660 /sys/devices/system/cpu/cpu0/timer_irq_latency # We need permissions
    echo 0 > /sys/devices/system/cpu/cpu0/timer_irq_latency # Disable Kpanic inside of TEL-SIG handler
  fi
  # U_M39G_MV-1970 - JTAG options: COMM mode set to EE_RESET_COMM_SILENT=5
  ./eeh -s $eeh_log_level -a 5 &
else
  # EEH Operating defaults: -s (Turn on secure mode only for Android) -a 8 -A 8 (ramdump) eeh_log_level = -M 1 (save non-SR CP-logs)
  # DEBUG options: -a 1 -A 1 (stall) -M 2  (save non-SR small CP-logs)
./eeh -s $eeh_log_level &
fi

## run dbg macro handler
##./dbg_macro_util &

#Optional compuntents configurations
./busybox sh /marvell/tel/run_optional_comp.sh

#if configured bu user at NVM run vzw cm #U_M39G_MV-1459 U_M39G_MV-1596 U_M39G_MV-1627 U_M39G_MV-1747
if [ -f ${VZWCM_FILE} ]; then

	#get current bitmap
	UBLOX_UMNOCONF_BM=`getprop persist.sys.ublx_umnoconf_bm`

	#has to handle 3G?
	UBLOX_UMNOCONF_HANDLE_3G=" "

	#has to disable PLMN check?
	UBLOX_UMNOCONF_DISABLE_PLMN_CHECK=" "

	#has to disable IPV6 tethering?
	UBLOX_UMNOCONF_DISABLE_IPV6_TETHERING=" "

	if [ $((UBLOX_UMNOCONF_BM & 32)) -eq 32 ]; then 
		UBLOX_UMNOCONF_HANDLE_3G="-3g"
	fi

	if [ $((UBLOX_UMNOCONF_BM & 64)) -eq 64 ]; then 
		UBLOX_UMNOCONF_DISABLE_PLMN_CHECK="-vzwonly"
	fi

	if [ $((UBLOX_UMNOCONF_BM & 128)) -eq 128 ]; then 
		UBLOX_UMNOCONF_DISABLE_IPV6_TETHERING="-nipv6t"
	fi
	
	#if IMS test mode
	if [ $((UBLOX_UMNOCONF_BM & 8)) -eq 8 ]; then 
		vzwcm -nipt -nims -dsims $UBLOX_UMNOCONF_HANDLE_3G $UBLOX_UMNOCONF_DISABLE_PLMN_CHECK $UBLOX_UMNOCONF_DISABLE_IPV6_TETHERING > /dev/null &
	elif [ $((UBLOX_UMNOCONF_BM & 16)) -eq 16 ]; then 
		#internet auto start
		vzwcm -nipt -dsims $UBLOX_UMNOCONF_HANDLE_3G $UBLOX_UMNOCONF_DISABLE_PLMN_CHECK $UBLOX_UMNOCONF_DISABLE_IPV6_TETHERING > /dev/null &
	else 
		# manual vzwinternet
		vzwcm -nipt -ninet -dsims $UBLOX_UMNOCONF_HANDLE_3G $UBLOX_UMNOCONF_DISABLE_PLMN_CHECK $UBLOX_UMNOCONF_DISABLE_IPV6_TETHERING > /dev/null &
	fi

  touch /tmp/vzwcm_activated
fi

#Run mtil client for ACM-0 interface
./mtilatcmd -m /dev/ttymodem $MTILATCMD_EXT_LIBS &

#Run mtil client for ACM-1 interface
getprop | grep acm_at_1 > ${TEMP_DIR}/usbprop1
if [ $? == 0 ]; then
#U_M39G_MV-359
./mtilatcmd -m /dev/ttyGS1 $MTILATCMD_EXT_LIBS &
fi

#Run mtil client for ACM-2 interface
getprop | grep acm_at_2 > ${TEMP_DIR}/usbprop2
if [ $? == 0 ]; then
#U_M39G_MV-359
./mtilatcmd -m /dev/ttyGS2 $MTILATCMD_EXT_LIBS &
fi

#U_M39G_MV-284
# must run after MTSD server
if [ $PROD == '1' ]  || [ $UARTCFG == 1 ] ; then
	#Enable console
	setprop uart.cfg 1
else
#U_M39G_MV-811 Start UART AT client only if no TRACE over UART 
  if [ $TRACE_UART_START == '1' ] ; then
      #Do not run anything
      setprop uart.cfg 2
  else
	  #Enable serial_client
	  setprop uart.cfg 0
  fi
fi

#U_M39G_MV-527
#TRACE_STOP=`getprop sys.trace.state | grep -c "stopped"`
#TRACE_FS_START=`getprop sys.trace.state | grep -c "fs"`
#TRACE_SDCARD_START=`getprop sys.trace.state | grep -c "sdcard"`
#TRACE_UART_START=`getprop sys.trace.state | grep -c "uart"`
#TRACE_USB_START=`getprop sys.trace.state | grep -c "usb"`
#TRACE_TCP_START=`getprop sys.trace.state | grep -c "tcp"`

#U_M39G_MV-811 Get the required UART speed for trace
UART_TRACE_SPEED=`getprop sys.trace.speed`

if [ $TRACE_STOP == '1' ] ; then
	#Disable trace
	./busybox sh	/marvell/tel/diag_stop.sh
elif [ $TRACE_FS_START == '1' ] ; then
	#Enable trace on FS
	./busybox sh /marvell/tel/diag_fs_start.sh
elif [ $TRACE_SDCARD_START == '1' ] ; then
	#Enable trace on SD card
	./busybox sh /marvell/tel/diag_sdcard_start.sh
elif [ $TRACE_UART_START == '1' ] ; then
#U_M39G_MV-811 Do not start UART trace if UART is required for console
  if [ $PROD == '1' ] || [ $UARTCFG == 1 ] ; then
  else
      echo "UART speed for trace $UART_TRACE_SPEED b/s"
	  #Enable trace on UART
	  ./busybox sh /marvell/tel/diag_uart_start.sh $UART_TRACE_SPEED
  fi
elif [ $TRACE_USB_START == '1' ] ; then
	#Enable trace on USB
	./busybox sh /marvell/tel/diag_usb_start.sh
elif [ $TRACE_TCP_START == '1' ] ; then
	#Enable trace on TCP
	./busybox sh /marvell/tel/diag_tcp_start.sh
else
	./busybox sh /marvell/tel/diag_stop.sh
fi

#Run audio_calibration and pluggin proxy process
audio_manager&

# increase writeback interval for powersaving
echo 3000 > /proc/sys/vm/dirty_writeback_centisecs

# Not needed in 00s
#if USB MBIM configured, run the MBIM MTIL application
#getprop sys.usb.state | grep cdc_mbim > ${TEMP_DIR}/usbprop3
#if [ $? == 0 ]; then
#/marvell/tel/mbim &
#fi
#if configured by user at NVM run rb
#U_M39G_MV-2761 Sleep timers are reduced to avoid Wap Push SMS discard after IMS Registration
if [ -f ${RB_FILE} ]; then
sleep 1
rm /tmp/rb_cli
rm /data/oma_reg.conf
rm /data/oma_reg_new.conf
sleep 2
/marvell/tel/rb -t /data/tree.xml &
fi

setprop persist.sys.ublx_rndis0_ipv6 `ifconfig usb0 | awk '/inet6[[:space:]]/ {print $3}'`

sleep 20

# U_M39G_MV-1139 - Marvell Scalable Power/Performance Manager (MSPM) enabled only if JTAG was not detected
if [ $JTAG_TEST != '1' ]; then
  #enable MSPM - Marvell Scalable Power/Performance Manager Idle Profiler
  echo 1 > /sys/power/mspm/mspm
fi

echo 1 > /sys/power/mspm/prof
