#!/bin/sh

RESOLV_CONF=/tmp/resolv.conf
RESOLV_CONF_DNS=/tmp/resolv-dnsmasq.conf
RESOLV_CONF_MLAN=/tmp/resolv-mlan0.conf

log()
{
	/system/bin/log -t wifi:routing "$*"
}

# M39G_MV_2-1846
# this check should be removed in order to permit consecutive execution of +UWSTAIPCFG
#if [ "$(lwconfig read net_mlan0_routing)" != "1" ]; then
#	exit 0
#fi

#M39G_MV_2-1690
touch $RESOLV_CONF
touch $RESOLV_CONF_DNS
touch $RESOLV_CONF_MLAN

if [ "$1" == "CONNECTED" ] && [ "$(lwconfig read net_mlan0_routing)" == "1" ] ; then

	log "Setup routing for mlan0"

	# redirect resolv.conf link for dnsmasq
	echo "# Generated by $0" >$RESOLV_CONF_MLAN;
	for n in 1 2 3 4; do
		dns=$(getprop net.mlan0.dns${n})
		[ -z "$dns" ] && break
		echo "nameserver $dns" >>$RESOLV_CONF_MLAN;
		# set net.dnsX; will be overwritten next time modem reconnects
		setprop net.dns${n} $dns
	done
	ln -sf $RESOLV_CONF_MLAN $RESOLV_CONF_DNS;

#M39G_MV_2-1690
	icmp_timeout_old=$(sysctl -n net.ipv4.netfilter.ip_conntrack_icmp_timeout)
	sysctl -w net.ipv4.netfilter.ip_conntrack_icmp_timeout=1
	sleep 1
	# add routing table for mlan0 and a rule to use it
	gw=$(getprop net.mlan0.gw)
	ip route flush table 200
	ip route show table main | grep -Ev ^default | while read ROUTE; do
		ip route add table 200 $ROUTE;
	done
	ip route add default via $gw dev mlan0 table 200
	ip rule add table 200
	ip route flush cache
	
	lwconfig --db=status write mlan_routing_active 1
#M39G_MV_2-1690
	sysctl -w net.ipv4.netfilter.ip_conntrack_icmp_timeout=$icmp_timeout_old

elif [ "$1" == "DISCONNECTED" ] && [ "$(lwconfig read net_mlan0_routing)" == "0" ] ; then

	log "Reset routing to default"

	# revert resolv.conf
	ln -sf $RESOLV_CONF $RESOLV_CONF_DNS;

#M39G_MV_2-1690
	icmp_timeout_old=$(sysctl -n net.ipv4.netfilter.ip_conntrack_icmp_timeout)
	sysctl -w net.ipv4.netfilter.ip_conntrack_icmp_timeout=1
	sleep 1
	
#	# revert routing tables
#	ip rule del table 200
#	ip route flush table 200
#	ip route flush cache

	ip route del default via $gw dev mlan0 table 200
	ip route flush table 200
	ip rule del table 200
	ip route flush cache

# M39G_MV_2-1846
	for n in 1 2 3 4; do
		dns=`awk -v var="${n}" 'FNR==var {print $2}' ${RESOLV_CONF}`
		[ -z "${dns}" ] && break
		setprop net.dns${n} ${dns}
	done
	
	lwconfig --db=status write mlan_routing_active 0

#M39G_MV_2-1690
	sysctl -w net.ipv4.netfilter.ip_conntrack_icmp_timeout=$icmp_timeout_old

fi
