#!/system/xbin/sh

HAWK_SENDER_SERVER_URL=ftp://212.199.69.13
HAWK_SENDER_SERVER_USERNAME=HAWKClient
HAWK_SENDER_SERVER_PASSWORD=I3YGD2E5

#2G upload speed around 236 kbps
let "DEFAULT_FTP_UPLOAD_SPEED=30*1024"

BOARD_IMEI=`tr -d '\n' < /NVM/ml_imei.txt`
if [ $? != 0 ] ; then
	echo "eshel_create_log.sh:missing IMEI file..." > /dev/kmsg
	exit 1
fi

if [ -z "$1" ] ; then
	echo "eshel_create_log.sh:Wrong parameter..." > /dev/kmsg
	exit 1
fi

EVENT_DIR=$1
cd $EVENT_DIR

#taking only EVENT_ID(directory name)
EVENT_ID=${EVENT_DIR##*/}

TINY_LOG=tiny_logs.tgz
FULL_LOG=full_logs.tgz

if [ \( -e OFFLINE \) -a \( -e "$TINY_LOG" -o -e "$FULL_LOG" \) ] ; then
	# if tar doesn't exist, we pack new one
	FILE=`find -name \*.tar`
	if [ -z "$FILE" ] ; then
		UNIQUE_ID=$BOARD_IMEI-$RANDOM-$RANDOM-$RANDOM-$RANDOM-$RANDOM
		mkdir $EVENT_ID
		FILE=__$UNIQUE_ID.tar
		if [ -e "$TINY_LOG" ] ; then
			cp $TINY_LOG $EVENT_ID/
		fi
		if [ -e "$FULL_LOG" ] ; then
			cp $FULL_LOG $EVENT_ID/
		fi

		tar -cf $FILE $EVENT_ID
	fi
	#sending logs to server
	FILE_SIZE=`stat -c %s $FILE`
	let "MAX_UPLOAD_TIME=$FILE_SIZE / $DEFAULT_FTP_UPLOAD_SPEED"
	if [ "$MAX_UPLOAD_TIME" -lt "10" ] ; then
		#set defualt upload time to 10 seconds
		MAX_UPLOAD_TIME=10
	fi
	curl --connect-timeout 20 -m $MAX_UPLOAD_TIME -C - -T $FILE -u $HAWK_SENDER_SERVER_USERNAME:$HAWK_SENDER_SERVER_PASSWORD $HAWK_SENDER_SERVER_URL/
	exval=$?
	echo "curl exit: $exval" > /dev/kmsg
	if [ $exval == 0 ] ; then
		NEW_FILE=`echo $FILE | cut -d '_' -f3`
		curl --connect-timeout 20 -Q "-RNFR $FILE" -Q "-RNTO $NEW_FILE" -u $HAWK_SENDER_SERVER_USERNAME:$HAWK_SENDER_SERVER_PASSWORD $HAWK_SENDER_SERVER_URL/
		if [ $? == 0 ] ; then
			#if we succeeded to upload logs, then delete from SD
			cd ..
			rm -r $EVENT_DIR
		fi
	fi
fi
